/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.core.scheduler;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.connections.mail.PopConnection;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.util.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FetchIssueMailTask {
    private static final Logger LOGGER = Logger.getLogger(FetchIssueMailTask.class.getName());

    public void execute() {
        PopConnection conn = new PopConnection();
        conn.setProtocol(ConfigManager.email.getIncomingEmailProtocol());
        conn.setOauthEndpoint(ConfigManager.email.getInboundEmailOauthEndpoint());
        conn.setOauthParams(ConfigManager.email.getInboundEmailOauthParams());
        conn.setHost(ConfigManager.email.getPopHost());
        conn.setPort(ConfigManager.email.getPopPort());
        conn.setUsername(ConfigManager.email.getPopUsername());
        conn.setPassword(StringUtils.decodeBase64Codec(ConfigManager.email.getPopPassword()));
        conn.setSslEnabled(ConfigManager.email.isPopSslEnabled());
        conn.setMessagesLimit(ConfigManager.email.getPopMessagesLimit());
        conn.setSenderIgnoreList(ConfigManager.email.getPopSenderIgnoreList());
        if (conn.isConfigured()) {
            LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.SCHEDULER_PREFIX), LogConfigManager.SCHEDULER_PREFIX + " Fetching issue emails...");
            try {
                IssueService issueService = ServiceProvider.getIssueService(new RequestContext());
                issueService.retrieveIssueEmails(conn);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LogConfigManager.SCHEDULER_PREFIX + " Problem fetching emails ", e);
            }
        } else {
            LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.SCHEDULER_PREFIX), LogConfigManager.SCHEDULER_PREFIX + " Fetching issue emails... not configured, skipping");
        }
    }
}

