/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.core.scheduler;

import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.biz.system.core.scheduler.ContractExpirationNotificationTask;
import com.kwoksys.biz.system.core.scheduler.FetchIssueMailTask;
import java.util.logging.Logger;

public class TaskRunner {
    private static final Logger LOGGER = Logger.getLogger(TaskRunner.class.getName());
    private static long lastIssueMailRunTime = 0L;
    private static long lastContractNotificationRunTime = 0L;

    public void execute() {
        long currentTime = System.currentTimeMillis();
        LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.SCHEDULER_PREFIX), "{0} Scheduler running in the background, current system time: {1}", new String[]{LogConfigManager.SCHEDULER_PREFIX, String.valueOf(currentTime)});
        this.runIssueEmailTask(currentTime);
        this.runContractNotificationTask(currentTime);
    }

    private void runIssueEmailTask(long currentTime) {
        int issueEmailRepeatInterval = ConfigManager.email.getPopRepeatInterval();
        if (issueEmailRepeatInterval != 0 && lastIssueMailRunTime + (long)issueEmailRepeatInterval < currentTime + 1000L) {
            lastIssueMailRunTime = currentTime;
            new FetchIssueMailTask().execute();
        }
    }

    private void runContractNotificationTask(long currentTime) {
        if (ConfigManager.email.isContractExpireNotificationEnabled()) {
            long contractNotificationInterval = ConfigManager.email.getContractNotificationInterval();
            if (lastContractNotificationRunTime + contractNotificationInterval < currentTime + 1000L) {
                lastContractNotificationRunTime = currentTime;
                new ContractExpirationNotificationTask().execute();
            }
        } else {
            LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.SCHEDULER_PREFIX), LogConfigManager.SCHEDULER_PREFIX + " Sending contract expiration notification emails... not configured, skipping");
        }
    }
}

