/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.core.scheduler;

import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.biz.system.core.scheduler.TaskRunner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskScheduler {
    private static final Logger LOGGER = Logger.getLogger(TaskScheduler.class.getName());
    private static ScheduledExecutorService scheduler;

    public static void init() throws Exception {
        try {
            LOGGER.info(LogConfigManager.CONFIG_PREFIX + " Scheduling jobs...");
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    new TaskRunner().execute();
                }
            };
            scheduler = Executors.newScheduledThreadPool(3);
            scheduler.scheduleAtFixedRate(runnable, 0L, 1L, TimeUnit.MINUTES);
            LOGGER.info(LogConfigManager.CONFIG_PREFIX + " Scheduler started");
        }
        catch (Exception e) {
            throw new Exception("Failed to start scheduler", e);
        }
    }

    public static void destroy() {
        if (scheduler != null) {
            try {
                scheduler.shutdown();
                LOGGER.info(LogConfigManager.SHUTDOWN_PREFIX + " Scheduler shutdown");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LogConfigManager.SHUTDOWN_PREFIX + " Error shutting down scheduler", e);
            }
        }
    }
}

