/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.dao;

import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.system.dao.BookmarkQueries;
import com.kwoksys.biz.system.dto.Bookmark;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.StringUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class BookmarkDao
extends BaseDao {
    public BookmarkDao(RequestContext requestContext) {
        super(requestContext);
    }

    public List<Bookmark> getBookmarks(QueryCriteria query, Integer objectTypeId, Integer objectId) throws DatabaseException {
        final ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
        QueryHelper queryHelper = new QueryHelper(BookmarkQueries.selectBookmarkListQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Bookmark bookmark = new Bookmark();
                bookmark.setId(rs.getInt("bookmark_id"));
                bookmark.setName(StringUtils.replaceNull(rs.getString("bookmark_name")));
                bookmark.setDescription(StringUtils.replaceNull(rs.getString("bookmark_description")));
                bookmark.setPath(StringUtils.replaceNull(rs.getString("bookmark_path")));
                bookmarks.add(bookmark);
            }
        };
        queryHelper.addInputInt(objectTypeId);
        queryHelper.addInputInt(objectId);
        this.executeQuery(queryHelper);
        return bookmarks;
    }

    public Bookmark getBookmark(final Integer objectTypeId, final Integer objectId, Integer bookmarkId) throws DatabaseException, ObjectNotFoundException {
        final ArrayList bookmarks = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(BookmarkQueries.selectBookmarkDetailQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Bookmark bookmark = new Bookmark(objectTypeId, objectId);
                bookmark.setId(rs.getInt("bookmark_id"));
                bookmark.setName(StringUtils.replaceNull(rs.getString("bookmark_name")));
                bookmark.setDescription(StringUtils.replaceNull(rs.getString("bookmark_description")));
                bookmark.setPath(StringUtils.replaceNull(rs.getString("bookmark_path")));
                bookmarks.add(bookmark);
            }
        };
        queryHelper.addInputInt(objectTypeId);
        queryHelper.addInputInt(objectId);
        queryHelper.addInputInt(bookmarkId);
        this.executeSingleRecordQuery(queryHelper);
        if (!bookmarks.isEmpty()) {
            return (Bookmark)bookmarks.get(0);
        }
        throw new ObjectNotFoundException("Bookmark ID: " + bookmarkId);
    }

    public ActionMessages add(Bookmark bookmark) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(BookmarkQueries.insertBookmarkQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(bookmark.getName());
        queryHelper.addInputStringConvertNull(bookmark.getPath());
        queryHelper.addInputStringConvertNull(bookmark.getDescription());
        queryHelper.addInputInt(bookmark.getObjectTypeId());
        queryHelper.addInputInt(bookmark.getObjectId());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        this.executeProcedure(queryHelper);
        if (this.errors.isEmpty()) {
            bookmark.setId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }

    public ActionMessages update(Bookmark bookmark) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(BookmarkQueries.updateBookmarkQuery());
        queryHelper.addInputInt(bookmark.getId());
        queryHelper.addInputStringConvertNull(bookmark.getName());
        queryHelper.addInputStringConvertNull(bookmark.getPath());
        queryHelper.addInputStringConvertNull(bookmark.getDescription());
        queryHelper.addInputInt(bookmark.getObjectTypeId());
        queryHelper.addInputInt(bookmark.getObjectId());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages delete(Bookmark bookmark) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(BookmarkQueries.deleteBookmarkQuery());
        queryHelper.addInputInt(bookmark.getObjectTypeId());
        queryHelper.addInputInt(bookmark.getObjectId());
        queryHelper.addInputInt(bookmark.getId());
        return this.executeProcedure(queryHelper);
    }
}

