/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.dao;

import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.system.dao.CategoryQueries;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.StringUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class CategoryDao
extends BaseDao {
    public CategoryDao(RequestContext requestContext) {
        super(requestContext);
    }

    public List<Category> getCategoryList(QueryCriteria query, Integer objectTypeId) throws DatabaseException {
        final ArrayList<Category> categories = new ArrayList<Category>();
        QueryHelper queryHelper = new QueryHelper(CategoryQueries.selectCategoryListQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Category category = new Category();
                category.setId(rs.getInt("category_id"));
                category.setName(StringUtils.replaceNull(rs.getString("category_name")));
                category.setCountObjects(rs.getInt("object_count"));
                category.setObjectTypeId(rs.getInt("object_type_id"));
                categories.add(category);
            }
        };
        queryHelper.addInputInt(objectTypeId);
        this.executeQuery(queryHelper);
        return categories;
    }

    public Category getCategory(Integer categoryId, Integer objectTypeId) throws DatabaseException, ObjectNotFoundException {
        final ArrayList categories = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(CategoryQueries.selectCategoryDetailQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Category category = new Category();
                category.setId(rs.getInt("category_id"));
                category.setName(StringUtils.replaceNull(rs.getString("category_name")));
                category.setDescription(StringUtils.replaceNull(rs.getString("category_description")));
                category.setObjectTypeId(rs.getInt("object_type_id"));
                categories.add(category);
            }
        };
        queryHelper.addInputInt(categoryId);
        queryHelper.addInputInt(objectTypeId);
        this.executeSingleRecordQuery(queryHelper);
        if (!categories.isEmpty()) {
            return (Category)categories.get(0);
        }
        throw new ObjectNotFoundException("Category ID: " + categoryId);
    }

    public ActionMessages addCategory(Category category) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(CategoryQueries.insertCategoryQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(category.getName());
        queryHelper.addInputStringConvertNull(category.getDescription());
        queryHelper.addInputInt(category.getObjectTypeId());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        this.executeProcedure(queryHelper);
        if (this.errors.isEmpty()) {
            category.setId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }

    public ActionMessages editCategory(Category category) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(CategoryQueries.updateCategoryQuery());
        queryHelper.addInputInt(category.getId());
        queryHelper.addInputStringConvertNull(category.getName());
        queryHelper.addInputStringConvertNull(category.getDescription());
        queryHelper.addInputInt(category.getObjectTypeId());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        return this.executeProcedure(queryHelper);
    }
}

