/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.dao;

import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.biz.system.dao.SystemQueries;
import com.kwoksys.biz.system.dto.SystemInfo;
import com.kwoksys.biz.system.dto.linking.ObjectLink;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemDao
extends BaseDao {
    private static final Logger LOGGER = Logger.getLogger(SystemDao.class.getName());

    public SystemDao(RequestContext requestContext) {
        super(requestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDatabaseInfo() throws DatabaseException {
        Connection conn = this.getConnection();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            DatabaseMetaData meta = conn.getMetaData();
            map.put("DatabaseProductName", meta.getDatabaseProductName());
            map.put("DatabaseProductVersion", meta.getDatabaseProductVersion());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, LogConfigManager.DATABASE_ACCESS_PREFIX + " Exception: " + e.getMessage());
        }
        finally {
            this.closeConnection(conn);
        }
        return map;
    }

    public SystemInfo getSystemInfo() throws DatabaseException {
        final SystemInfo systemInfo = new SystemInfo();
        QueryHelper queryHelper = new QueryHelper(SystemQueries.selectSystemValues()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                systemInfo.setCacheKey(StringUtils.replaceNull(rs.getString("cache_key")));
                systemInfo.setSysdate(DatetimeUtils.getDate(rs, "sysdate"));
            }
        };
        this.executeSingleRecordQuery(queryHelper);
        return systemInfo;
    }

    public String getTimezone() throws DatabaseException {
        final ArrayList list = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(SystemQueries.selectCurrentTimezone()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                list.add(rs.getString("timezone"));
            }
        };
        this.executeSingleRecordQuery(queryHelper);
        return (String)list.get(0);
    }

    public ActionMessages updateTimezone() throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(SystemQueries.updateCurrentTimezone());
        return this.executeUpdate(queryHelper);
    }

    public List<String> getFlushSystemCacheKeys(Long cacheTime) throws DatabaseException {
        final ArrayList<String> cacheKeys = new ArrayList<String>();
        QueryHelper queryHelper = new QueryHelper(SystemQueries.selectFlushSystemCaches()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                cacheKeys.add(rs.getString("cache_key"));
            }
        };
        queryHelper.addInputLong(cacheTime);
        this.executeQuery(queryHelper);
        return cacheKeys;
    }

    public Map<String, String> getSystemConfig() throws DatabaseException {
        final HashMap<String, String> map = new HashMap<String, String>();
        QueryHelper queryHelper = new QueryHelper(SystemQueries.selectSystemConfig()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                map.put(rs.getString("config_key"), StringUtils.replaceNull(rs.getString("config_value")));
            }
        };
        this.executeQuery(queryHelper);
        return map;
    }

    public int getObjectMapCount(List<Integer> objectTypeIds, Integer linkedObjectId, List<Integer> linkedObjectTypeIds) throws DatabaseException {
        String objectTypeIdOption = StringUtils.joinIntegers(objectTypeIds, ",");
        String linkedTypeIdOption = StringUtils.joinIntegers(linkedObjectTypeIds, ",");
        String sqlQuery = SystemQueries.selectObjectMapCount(objectTypeIdOption, linkedTypeIdOption);
        final ArrayList list = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(sqlQuery){

            @Override
            public void callback(ResultSet rs) throws Exception {
                list.add(rs.getInt("obj_count"));
            }
        };
        queryHelper.addInputInt(linkedObjectId);
        this.executeSingleRecordQuery(queryHelper);
        return (Integer)list.get(0);
    }

    public int getLinkedObjectMapCount(List<Integer> linkedObjectTypeIds, Integer objectId, Integer objectTypeId) throws DatabaseException {
        final ArrayList list = new ArrayList();
        String linkedTypeIdOption = StringUtils.joinIntegers(linkedObjectTypeIds, ",");
        QueryHelper queryHelper = new QueryHelper(SystemQueries.selectLinkedObjectMapCount(linkedTypeIdOption)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                list.add(rs.getInt("obj_count"));
            }
        };
        queryHelper.addInputInt(objectId);
        queryHelper.addInputInt(objectTypeId);
        this.executeSingleRecordQuery(queryHelper);
        return (Integer)list.get(0);
    }

    public ActionMessages validateSystemCaches(Long cacheTime) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(SystemQueries.validateSystemCaches());
        queryHelper.addInputLong(cacheTime);
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages resetSystemCache(String cacheKey, Long cacheTime) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(SystemQueries.updateSystemCache());
        queryHelper.addInputString(cacheKey);
        queryHelper.addInputLong(cacheTime);
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages addObjectMapping(ObjectLink objectMap) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(SystemQueries.insertObjectMapQuery());
        queryHelper.addInputInt(objectMap.getObjectTypeId());
        queryHelper.addInputInt(objectMap.getObjectId());
        queryHelper.addInputInt(objectMap.getLinkedObjectTypeId());
        queryHelper.addInputInt(objectMap.getLinkedObjectId());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        queryHelper.addInputStringConvertNull(objectMap.getRelDescription());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages deleteObjectMapping(ObjectLink objectMap) throws DatabaseException {
        if (objectMap.getLinkedObjectId() == 0) {
            return this.errors;
        }
        QueryHelper queryHelper = new QueryHelper(SystemQueries.deleteObjectMapQuery());
        queryHelper.addInputInt(objectMap.getObjectTypeId());
        queryHelper.addInputInt(objectMap.getObjectId());
        queryHelper.addInputInt(objectMap.getLinkedObjectTypeId());
        queryHelper.addInputInt(objectMap.getLinkedObjectId());
        return this.executeProcedure(queryHelper);
    }
}

