/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.system.dao;

import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.properties.PropertiesManager;

public class SystemQueries {
    public static String selectCurrentTimezone() {
        return "select current_setting('TIMEZONE') as timezone";
    }

    public static String updateCurrentTimezone() {
        return "ALTER DATABASE " + PropertiesManager.get("db.name") + " SET TimeZone=" + ConfigManager.system.getTimezoneBaseString();
    }

    public static String selectSystemValues() {
        return "select now() as sysdate, config_value as cache_key from system_config where config_key='system.cacheKey'";
    }

    public static String selectFlushSystemCaches() {
        return "select cache_key from system_cache where cache_time >= ?";
    }

    public static String validateSystemCaches() {
        return "{call sp_system_cache_validate(?)}";
    }

    public static String updateSystemCache() {
        return "{call sp_system_cache_add(?, ?)}";
    }

    public static String selectSystemConfig() {
        return "select config_key, config_value from system_config";
    }

    public static String selectObjectMapCount(String objectTypeIds, String linkedObjectTypeIds) {
        return "select count(object_id) as obj_count from object_map where object_type_id in (" + objectTypeIds + ") and linked_object_id=? and linked_object_type_id in (" + linkedObjectTypeIds + ") ";
    }

    public static String selectLinkedObjectMapCount(String linkedObjectTypeIds) {
        return "select count(linked_object_id) as obj_count from object_map where linked_object_type_id in (" + linkedObjectTypeIds + ") and object_id=? and object_type_id = ?";
    }

    public static String insertObjectMapQuery() {
        return "{call sp_object_map_add(?,?,?,?,?,?)}";
    }

    public static String deleteObjectMapQuery() {
        return "{call sp_object_map_delete(?,?,?,?)}";
    }
}

