/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.connections.database;

import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.connections.database.DatabaseFactory;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.properties.PropertiesManager;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DatabaseManager {
    private static final Logger LOGGER = Logger.getLogger(DatabaseManager.class.getName());
    protected static final String DB_SERVERHOST = PropertiesManager.get("db.serverHost");
    protected static final String DB_SERVERPORT = PropertiesManager.get("db.serverPort");
    protected static final String DB_NAME = PropertiesManager.get("db.name");
    protected static final String DB_USERNAME = PropertiesManager.get("db.username");
    protected static final String DB_PASSWORD = PropertiesManager.get("db.password");
    private Set<Connection> availablePool = new HashSet<Connection>();
    private Set<Connection> checkedOutPool = new HashSet<Connection>();
    private static DatabaseManager instance;

    public static DatabaseManager getInstance() {
        if (instance == null) {
            instance = DatabaseFactory.getDatabaseManager(PropertiesManager.get("db.type"));
            String driverName = instance.getDriverName();
            try {
                LOGGER.log(Level.INFO, LogConfigManager.DATABASE_ACCESS_PREFIX + " Loading database driver: " + driverName);
                Class.forName(driverName);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.SEVERE, "Failed to load database driver: " + driverName, e);
            }
        }
        return instance;
    }

    protected abstract String getDriverName();

    protected abstract String getJdbcUrl();

    public abstract Connection createConnection() throws DatabaseException;

    public abstract void closeConnection(Connection var1, boolean var2);

    protected abstract boolean isConnectionValid(Connection var1);

    protected synchronized void registerConn(Connection conn) {
        this.checkedOutPool.add(conn);
        LOGGER.log(Level.FINER, LogConfigManager.DATABASE_ACCESS_PREFIX + " Adding/moving to checkout pool... (" + this.checkedOutPool.size() + ", " + this.availablePool.size() + ")");
    }

    protected synchronized void checkInConnection(Connection conn) {
        this.checkedOutPool.remove(conn);
        this.availablePool.add(conn);
        LOGGER.log(Level.FINER, LogConfigManager.DATABASE_ACCESS_PREFIX + " Moving from checkout pool to available pool... (" + this.checkedOutPool.size() + ", " + this.availablePool.size() + ")");
    }

    protected synchronized Connection checkOutConnection() throws SQLException {
        Iterator<Connection> iter = this.availablePool.iterator();
        while (iter.hasNext()) {
            Connection conn = iter.next();
            iter.remove();
            if (!this.isConnectionValid(conn)) continue;
            return conn;
        }
        if (this.isDbMaxConnectionExceeded()) {
            throw new SQLException("Max " + ConfigManager.system.getDbMaxConnection() + " connection exceeded.");
        }
        return null;
    }

    private boolean isDbMaxConnectionExceeded() {
        if (ConfigManager.system.getDbMaxConnection() == -1) {
            return false;
        }
        return this.availablePool.size() + this.checkedOutPool.size() + 2 >= ConfigManager.system.getDbMaxConnection();
    }

    public static void destroy() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
                LOGGER.log(Level.INFO, LogConfigManager.SHUTDOWN_PREFIX + " Deregistering jdbc driver: " + driver);
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, LogConfigManager.SHUTDOWN_PREFIX + " Error deregistering driver: " + driver, e);
            }
        }
    }

    public int getAvailablePoolSize() {
        return this.availablePool.size();
    }

    public int getCheckedOutPoolSize() {
        return this.checkedOutPool.size();
    }
}

