/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.connections.database;

import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.connections.database.DatabaseManager;
import com.kwoksys.framework.exceptions.DatabaseException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class PostgresDatabase
extends DatabaseManager {
    private static final Logger LOGGER = Logger.getLogger(PostgresDatabase.class.getName());
    private Properties prop = new Properties();

    public PostgresDatabase() {
        this.prop.put("user", DB_USERNAME);
        this.prop.put("password", DB_PASSWORD);
        this.prop.put("timezone", "GMT");
    }

    @Override
    protected String getDriverName() {
        return "org.postgresql.Driver";
    }

    @Override
    protected String getJdbcUrl() {
        return "jdbc:postgresql://" + DB_SERVERHOST + ":" + DB_SERVERPORT + "/" + DB_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isConnectionValid(Connection conn) {
        boolean isValid = true;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (conn.isClosed()) {
                boolean bl = false;
                return bl;
            }
            ps = conn.prepareStatement("select 1");
            rs = ps.executeQuery();
        }
        catch (Exception e) {
            isValid = false;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (!isValid) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return isValid;
    }

    @Override
    public Connection createConnection() throws DatabaseException {
        try {
            Connection conn = this.checkOutConnection();
            if (conn == null) {
                LOGGER.log(Level.INFO, LogConfigManager.DATABASE_ACCESS_PREFIX + " Creating connection to " + this.getJdbcUrl());
                conn = DriverManager.getConnection(this.getJdbcUrl(), this.prop);
                conn.setAutoCommit(false);
            }
            this.registerConn(conn);
            return conn;
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, LogConfigManager.DATABASE_ACCESS_PREFIX + " Problem connecting to " + this.getJdbcUrl(), e);
            throw new DatabaseException(e);
        }
    }

    @Override
    public void closeConnection(Connection conn, boolean hasError) {
        if (hasError) {
            try {
                LOGGER.log(Level.FINER, LogConfigManager.DATABASE_ACCESS_PREFIX + " Rolling back transaction.");
                conn.rollback();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, LogConfigManager.DATABASE_ACCESS_PREFIX + " Problem rolling back a transaction.", e);
            }
        } else {
            try {
                LOGGER.log(Level.FINER, LogConfigManager.DATABASE_ACCESS_PREFIX + " Committing transaction.");
                conn.commit();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, LogConfigManager.DATABASE_ACCESS_PREFIX + " Problem committing a transaction.", e);
            }
        }
        this.checkInConnection(conn);
    }
}

