/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.connections.database;

import com.kwoksys.biz.base.BaseSearch;
import com.kwoksys.framework.util.Callback;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryCriteria {
    public static final String ASCENDING = "asc";
    public static final String DESCENDING = "desc";
    private List<String> whereClauses = new ArrayList<String>();
    private Map<String, String> sortColumns = new LinkedHashMap<String, String>();
    private int rowOffset;
    private int rowLimit;
    private Callback callback;

    public QueryCriteria() {
    }

    public QueryCriteria(BaseSearch search) {
        search.applyMap(this);
    }

    public void setLimit(int rowLimit, int rowOffset) {
        this.rowLimit = rowLimit;
        this.rowOffset = rowOffset;
    }

    public void appendWhereClause(String query) {
        this.whereClauses.add(query);
    }

    public String createWhereClause() {
        return this.createQueryClause(" where ");
    }

    public String createAndClause() {
        return this.createQueryClause(" and ");
    }

    public String createClause() {
        return this.createQueryClause("");
    }

    private String createQueryClause(String operator) {
        Iterator<Object> iter;
        StringBuilder query = new StringBuilder();
        if (!this.whereClauses.isEmpty() && !operator.isEmpty()) {
            query.append(operator);
            iter = this.whereClauses.iterator();
            while (iter.hasNext()) {
                query.append((String)iter.next());
                if (!iter.hasNext()) continue;
                query.append(" and ");
            }
        }
        if (!this.sortColumns.isEmpty()) {
            query.append(" order by ");
            iter = this.sortColumns.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                query.append((String)entry.getKey());
                if (((String)entry.getValue()).equals(DESCENDING)) {
                    query.append(" ").append(DESCENDING);
                }
                if (!iter.hasNext()) continue;
                query.append(", ");
            }
        }
        if (this.rowLimit > 0) {
            query.append(" limit ").append(this.rowLimit);
            if (this.rowOffset > 0) {
                query.append(" offset ").append(this.rowOffset);
            }
        }
        return query.toString();
    }

    public String createWhereCountClause() {
        return this.createQueryCountClause(" where ");
    }

    public String createAndCountClause() {
        return this.createQueryCountClause(" and ");
    }

    private String createQueryCountClause(String operator) {
        StringBuilder query = new StringBuilder();
        if (!this.whereClauses.isEmpty() && !operator.isEmpty()) {
            query.append(operator);
            Iterator<String> iter = this.whereClauses.iterator();
            while (iter.hasNext()) {
                query.append(iter.next());
                if (!iter.hasNext()) continue;
                query.append(" and ");
            }
        }
        return query.toString();
    }

    public void addSortColumn(String orderByColumn) {
        this.addSortColumn(orderByColumn, ASCENDING);
    }

    public void addSortColumn(String orderByColumn, String orderBy) {
        this.sortColumns.put(orderByColumn, orderBy);
    }

    public Callback getCallback() {
        return this.callback;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }
}

