/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.connections.database;

import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class QueryHelper {
    private static final Logger LOGGER = Logger.getLogger(QueryHelper.class.getName());
    private static final String IN_PARAM = "in";
    private static final String OUT_PARAM = "out";
    private List<Object[]> sqlParams = new ArrayList<Object[]>();
    private List<Object> sqlOutputs = new ArrayList<Object>();
    private String sqlStatement;
    private QueryCriteria clauses;
    private ResultSet rs;
    private PreparedStatement pstmt;
    private CallableStatement cstmt;

    public QueryHelper() {
    }

    public QueryHelper(String sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    public void addInputStringConvertNull(String value) {
        if (value == null || value.isEmpty()) {
            this.sqlParams.add(new Object[]{IN_PARAM, 0, 12});
        } else {
            this.addInputString(value);
        }
    }

    public void addInputIntegerConvertNull(Integer value) {
        if (value == null || value.equals(0)) {
            this.sqlParams.add(new Object[]{IN_PARAM, 0, 4});
        } else {
            this.addInputInt(value);
        }
    }

    public void addInputDoubleConvertNull(Double value) {
        if (value == null || value.equals(0.0)) {
            this.sqlParams.add(new Object[]{IN_PARAM, 0, 8});
        } else {
            this.addInputDouble(value);
        }
    }

    public void addInputString(String value) {
        this.sqlParams.add(new Object[]{IN_PARAM, 12, value});
    }

    public void addInputInt(Integer value) {
        this.sqlParams.add(new Object[]{IN_PARAM, 4, value});
    }

    public void addInputLong(Long value) {
        this.sqlParams.add(new Object[]{IN_PARAM, -5, value});
    }

    public void addInputDouble(Double value) {
        this.sqlParams.add(new Object[]{IN_PARAM, 8, value});
    }

    public void addOutputParam(int keyPos) {
        this.sqlParams.add(new Object[]{OUT_PARAM, keyPos, keyPos});
    }

    private void setCsInputParameters(CallableStatement cstmt, List<Object[]> sqlParams) throws SQLException {
        int i = 1;
        for (Object[] param : sqlParams) {
            Object paramType = param[0];
            int dataType = (Integer)param[1];
            Object dataValue = param[2];
            if (paramType.equals(IN_PARAM)) {
                if (dataType == 0) {
                    cstmt.setNull(i++, (int)((Integer)dataValue));
                    continue;
                }
                if (dataType == 4) {
                    cstmt.setInt(i++, (int)((Integer)dataValue));
                    continue;
                }
                if (dataType == -5) {
                    cstmt.setLong(i++, (long)((Long)dataValue));
                    continue;
                }
                if (dataType == 12) {
                    cstmt.setString(i++, (String)dataValue);
                    continue;
                }
                if (dataType == 8) {
                    cstmt.setDouble(i++, (double)((Double)dataValue));
                    continue;
                }
                if (dataType != 93) continue;
                cstmt.setTimestamp(i++, (Timestamp)dataValue);
                continue;
            }
            if (!paramType.equals(OUT_PARAM)) continue;
            cstmt.registerOutParameter(i++, dataType);
        }
    }

    public String concatSqlParams() {
        StringBuilder output = new StringBuilder();
        for (Object[] param : this.sqlParams) {
            output.append("[").append(param[2]).append("] ");
        }
        return output.toString();
    }

    public List<Map<String, String>> executeQueryReturnList(Connection conn) throws SQLException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        this.rs = this.executeQuery(conn);
        ResultSetMetaData rsm = this.rs.getMetaData();
        while (this.rs.next()) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int counter = 1; counter <= rsm.getColumnCount(); ++counter) {
                map.put(rsm.getColumnName(counter), this.rs.getString(counter));
            }
            result.add(map);
        }
        return result;
    }

    private void initPreparedStatement(Connection conn) throws SQLException {
        LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.DATABASE_ACCESS_PREFIX), LogConfigManager.DATABASE_ACCESS_PREFIX + " Executing statement: " + this.sqlStatement + "; params: " + this.concatSqlParams());
        this.pstmt = conn.prepareStatement(this.sqlStatement);
        int i = 1;
        for (Object[] param : this.sqlParams) {
            int dataType = (Integer)param[1];
            Object dataValue = param[2];
            if (dataType == 4) {
                this.pstmt.setInt(i++, (Integer)dataValue);
                continue;
            }
            if (dataType == -5) {
                this.pstmt.setLong(i++, (Long)dataValue);
                continue;
            }
            if (dataType != 12) continue;
            this.pstmt.setString(i++, (String)dataValue);
        }
    }

    public ResultSet executeQuery(Connection conn) throws SQLException {
        this.initPreparedStatement(conn);
        this.rs = this.pstmt.executeQuery();
        return this.rs;
    }

    public int executeUpdate(Connection conn) throws SQLException {
        this.initPreparedStatement(conn);
        try {
            int n = this.pstmt.executeUpdate();
            return n;
        }
        finally {
            this.close();
        }
    }

    public void executeProcedure(Connection conn) throws DatabaseException {
        LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.DATABASE_ACCESS_PREFIX), LogConfigManager.DATABASE_ACCESS_PREFIX + " Executing procedure: " + this.sqlStatement + "; params: " + this.concatSqlParams());
        try {
            this.cstmt = conn.prepareCall(this.sqlStatement);
            this.setCsInputParameters(this.cstmt, this.sqlParams);
            this.cstmt.execute();
            int i = 1;
            for (Object[] param : this.sqlParams) {
                Object paramType = param[0];
                int dataType = (Integer)param[1];
                if (paramType.equals(OUT_PARAM)) {
                    switch (dataType) {
                        case 4: {
                            this.sqlOutputs.add(this.cstmt.getInt(i++));
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e, this);
        }
        finally {
            this.close();
        }
    }

    public void prepareBatch(Connection conn) throws DatabaseException {
        LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.DATABASE_ACCESS_PREFIX), LogConfigManager.DATABASE_ACCESS_PREFIX + " Preparing batch query: " + this.sqlStatement + "; params: " + this.concatSqlParams());
        try {
            this.cstmt = conn.prepareCall(this.sqlStatement);
        }
        catch (Exception e) {
            this.close();
            throw new DatabaseException(e, this);
        }
    }

    public void addBatch() throws DatabaseException {
        LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.DATABASE_ACCESS_PREFIX), LogConfigManager.DATABASE_ACCESS_PREFIX + " Adding batch query: " + this.sqlStatement + "; params: " + this.concatSqlParams());
        try {
            this.setCsInputParameters(this.cstmt, this.sqlParams);
            this.cstmt.addBatch();
            this.sqlParams = new ArrayList<Object[]>();
        }
        catch (Exception e) {
            this.close();
            throw new DatabaseException(e, this);
        }
    }

    public void executeBatch() throws DatabaseException {
        LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.DATABASE_ACCESS_PREFIX), LogConfigManager.DATABASE_ACCESS_PREFIX + " Executing batch query: " + this.sqlStatement + "; params: " + this.concatSqlParams());
        try {
            this.cstmt.executeBatch();
        }
        catch (Exception e) {
            throw new DatabaseException(e, this);
        }
        finally {
            this.close();
        }
    }

    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rs = null;
        }
        if (this.pstmt != null) {
            try {
                this.pstmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pstmt = null;
        }
        if (this.cstmt != null) {
            try {
                this.cstmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cstmt = null;
        }
    }

    public void setSqlStatement(String sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    public List<Object> getSqlOutputs() {
        return this.sqlOutputs;
    }

    public QueryCriteria getClauses() {
        return this.clauses;
    }

    public void setClauses(QueryCriteria clauses) {
        this.clauses = clauses;
    }

    public void callback(ResultSet rs) throws Exception {
    }
}

