/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.connections.ldap;

import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;

public class Ldap {
    private static final Logger LOGGER = Logger.getLogger(Ldap.class.getName());
    private String protocol;
    private String url;
    private String username;
    private String password;
    private String securityPrincipal;

    public static void testAuthenticate(String[] args) throws Exception {
        Ldap ldap = new Ldap();
        ldap.setProtocol("ldap://");
        ldap.setUrl("ldap.forumsys.com");
        ldap.setUsername("cn=read-only-admin,dc=example,dc=com");
        ldap.setSecurityPrincipal("cn=read-only-admin,dc=example,dc=com");
        ldap.setPassword("");
        ldap.authenticate();
        System.out.println("Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages authenticate() {
        this.securityPrincipal = this.securityPrincipal.isEmpty() ? this.username : this.securityPrincipal.replace("${USERNAME}", this.username);
        LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.AUTHENTICATION_PREFIX), LogConfigManager.AUTHENTICATION_PREFIX + " URL: " + this.protocol + this.url + ". Username: " + this.username + ". Security principal: " + this.securityPrincipal);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.protocol + this.url);
        if (this.protocol.equals("ldaps://")) {
            env.put("java.naming.security.protocol", "ssl");
            env.put("java.naming.ldap.factory.socket", "com.kwoksys.framework.connections.CustomSslSocketFactory");
        }
        env.put("java.naming.security.principal", this.securityPrincipal);
        env.put("java.naming.security.credentials", this.password);
        InitialDirContext ctx = null;
        ActionMessages errors = new ActionMessages();
        try {
            ctx = new InitialDirContext(env);
            LOGGER.info(LogConfigManager.AUTHENTICATION_PREFIX + " Login success for user: " + this.username);
        }
        catch (Exception e) {
            LOGGER.warning(LogConfigManager.AUTHENTICATION_PREFIX + " Login failed for user: " + this.username + ". Class: " + e.getClass().getName() + ". Message: " + e.getMessage() + ". Cause: " + e.getCause());
            errors.add("connectError", new ActionMessage("admin.config.auth.ldap.error.connect", this.username + ". Message: " + e.getMessage() + ". Cause: " + e.getCause() + ". Class: " + e.getClass().getName()));
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return errors;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSecurityPrincipal() {
        return this.securityPrincipal;
    }

    public void setSecurityPrincipal(String securityPrincipal) {
        this.securityPrincipal = securityPrincipal;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

