/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.connections.mail;

import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.connections.CustomSslSocketFactory;
import com.kwoksys.framework.connections.mail.EmailMessage;
import com.kwoksys.framework.connections.mail.PopConnection;
import com.kwoksys.framework.parsers.email.IssueEmailParser;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.HttpHelper;
import com.kwoksys.framework.util.StringUtils;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.search.FlagTerm;
import jakarta.mail.search.SearchTerm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.json.JSONObject;

public class Pop3 {
    private static final Logger LOGGER = Logger.getLogger(Pop3.class.getName());
    private ActionMessages errors = new ActionMessages();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EmailMessage> receive(PopConnection conn) throws Exception {
        String protocol = conn.getProtocol();
        String accessToken = conn.getPassword();
        Properties props = new Properties();
        if (conn.isOffice365Imap()) {
            protocol = "imap";
            props.put("mail.imap.auth.login.disable", "true");
            props.put("mail.imap.auth.mechanisms", "XOAUTH2");
            props.put("mail.imap.auth.plain.disable", "true");
            props.put("mail.imaps.auth.mechanisms", "XOAUTH2");
            props.put("mail.imaps.sasl.enable", "true");
            props.put("mail.imaps.sasl.mechanisms", "XOAUTH2");
            CustomSslSocketFactory sf = new CustomSslSocketFactory();
            props.put("mail.imap.ssl.socketFactory", sf);
            HttpPost httppost = new HttpPost(conn.getOauthEndpoint());
            httppost.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
            String params = conn.getOauthParams().replace("${PASSWORD}", accessToken);
            StringEntity entity = new StringEntity(params);
            httppost.setEntity((HttpEntity)entity);
            String response = new HttpHelper().httpExecute((HttpUriRequestBase)httppost);
            JSONObject jsonObject = new JSONObject(response);
            accessToken = jsonObject.getString("access_token");
        }
        props.put("mail." + protocol + ".timeout", "10000");
        if (conn.isSslEnabled()) {
            props.put("mail." + protocol + ".ssl.enable", "true");
            props.put("mail." + protocol + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail." + protocol + ".socketFactory.fallback", "false");
            props.put("mail." + protocol + ".socketFactory.port", conn.getPort());
            props.put("mail." + protocol + ".ssl.checkserveridentity", "false");
            props.put("mail." + protocol + ".ssl.trust", conn.getHost());
        }
        Session session = Session.getInstance((Properties)props);
        ArrayList<EmailMessage> emailMessages = new ArrayList<EmailMessage>();
        Folder folder = null;
        Store store = null;
        try {
            store = session.getStore(protocol);
            store.connect(conn.getHost(), Integer.valueOf(conn.getPort()).intValue(), conn.getUsername(), accessToken);
            folder = store.getFolder("INBOX");
            folder.open(2);
            if (protocol.equals("pop3")) {
                int messageCount = folder.getMessageCount();
                LOGGER.log(Level.INFO, "Retrieving up to {0} messages. Number of messages in issue mailbox: {1}", new Object[]{conn.getMessagesLimit(), messageCount});
                for (int i = 1; i <= messageCount && i <= conn.getMessagesLimit(); ++i) {
                    Message message = folder.getMessage(i);
                    message.setFlag(Flags.Flag.DELETED, true);
                    this.processEmailMessage(conn, emailMessages, message, i);
                }
            } else if (protocol.equals("imap")) {
                FlagTerm flagTerm = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
                Message[] messages = folder.search((SearchTerm)flagTerm);
                LOGGER.log(Level.INFO, "Retrieving up to {0} messages. Number of messages in issue mailbox: {1}", new Object[]{conn.getMessagesLimit(), messages.length});
                int n = messages.length;
                for (int i = 0; i < n && i < conn.getMessagesLimit(); ++i) {
                    Message message = messages[i];
                    message.setFlag(Flags.Flag.SEEN, true);
                    this.processEmailMessage(conn, emailMessages, message, i);
                }
            }
        }
        catch (Exception e) {
            this.errors.add("fetchMail", new ActionMessage("admin.config.email.pop.error", e.getClass(), e.getMessage()));
            LOGGER.log(Level.SEVERE, "Failed to receive emails", e);
        }
        finally {
            try {
                if (folder != null && folder.isOpen()) {
                    folder.close(true);
                }
            }
            catch (Exception e) {
                this.errors.add("fetchMail", new ActionMessage("admin.config.email.pop.error", e.getClass(), e.getMessage()));
                LOGGER.log(Level.SEVERE, "Failed to close inbox folder", e);
                emailMessages.clear();
            }
            if (store != null) {
                store.close();
            }
        }
        return emailMessages;
    }

    public void processEmailMessage(PopConnection conn, List<EmailMessage> emailMessages, Message message, int i) {
        try {
            EmailMessage emailMessage = new EmailMessage();
            emailMessage.setFromField(IssueEmailParser.parseEmailAddress(message.getFrom()[0].toString()));
            emailMessage.setSubjectField(StringUtils.replaceNull(message.getSubject()));
            emailMessage.setBodyField(IssueEmailParser.parseEmailBody(Pop3.getBodyContent(message).toString().trim()));
            Address[] ccList = message.getRecipients(MimeMessage.RecipientType.CC);
            if (ccList != null) {
                for (Address ccAddress : ccList) {
                    emailMessage.getCcField().add(IssueEmailParser.parseEmailAddress(ccAddress.toString()));
                }
            }
            if (Pop3.ignoreSender(conn.getSenderIgnoreList().split("\n"), emailMessage.getFromField())) {
                LOGGER.info(LogConfigManager.EMAIL_PREFIX + " Ignored issue email from: " + emailMessage.getFromField());
            } else {
                emailMessages.add(emailMessage);
                LOGGER.info(LogConfigManager.EMAIL_PREFIX + " Received issue email from: " + emailMessage.getFromField());
            }
        }
        catch (Exception e) {
            this.errors.add("fetchMail", new ActionMessage("admin.config.email.pop.error", e.getClass(), e.getMessage()));
            LOGGER.log(Level.WARNING, "Failed to receive email " + i, e);
        }
    }

    public static boolean ignoreSender(String[] senderList, String from) {
        for (String ignoreSender : senderList) {
            if (!ignoreSender.trim().equalsIgnoreCase(from)) continue;
            return true;
        }
        return false;
    }

    public static StringBuilder getBodyContent(Message message) throws MessagingException, IOException {
        Object content = message.getContent();
        StringBuilder bodyText = new StringBuilder();
        if (content instanceof MimeMultipart) {
            MimeMultipart mp = (MimeMultipart)content;
            for (int j = 0; j < mp.getCount(); ++j) {
                String text;
                BodyPart bodyPart = mp.getBodyPart(j);
                String disposition = bodyPart.getDisposition();
                if ("attachment".equals(disposition) || (text = Pop3.getText((Part)bodyPart)) == null || !bodyText.toString().isEmpty()) continue;
                bodyText.append(text);
            }
        } else {
            bodyText.append(StringUtils.replaceNull(content));
        }
        return bodyText;
    }

    private static String getText(Part p) throws MessagingException, IOException {
        if (p.isMimeType("text/*")) {
            return (String)p.getContent();
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart bp = mp.getBodyPart(i);
                if (bp.isMimeType("text/html")) {
                    if (text != null) continue;
                    text = Pop3.getText((Part)bp);
                    continue;
                }
                if (bp.isMimeType("text/plain")) {
                    String s = Pop3.getText((Part)bp);
                    if (s == null) continue;
                    return s;
                }
                return Pop3.getText((Part)bp);
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                String s = Pop3.getText((Part)mp.getBodyPart(i));
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    public ActionMessages getErrors() {
        return this.errors;
    }
}

