/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.connections.mail;

import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.connections.mail.EmailMessage;
import com.kwoksys.framework.connections.mail.MailAuthenticator;
import com.kwoksys.framework.connections.mail.SmtpConnection;
import com.kwoksys.framework.parsers.email.IssueEmailParser;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.StringUtils;
import jakarta.mail.Address;
import jakarta.mail.AuthenticationFailedException;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SmtpService {
    private static final Logger LOGGER = Logger.getLogger(SmtpService.class.getName());
    private SmtpConnection conn;

    public SmtpService() {
        this.conn = new SmtpConnection();
    }

    public SmtpService(SmtpConnection conn) {
        this.conn = conn;
    }

    public ActionMessages send(EmailMessage message) throws Exception {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", this.conn.getHost());
        properties.put("mail.smtp.port", this.conn.getPort());
        properties.put("mail.smtp.auth", String.valueOf(this.conn.isAuthRequired()));
        properties.put("mail.smtp.timeout", "8000");
        properties.put("mail.smtp.connectiontimeout", "8000");
        properties.put("mail.smtp.starttls.enable", String.valueOf(this.conn.getStarttls()));
        if (this.conn.getStarttls()) {
            properties.put("mail.smtp.socketFactory.port", this.conn.getPort());
            properties.put("mail.smtp.ssl.checkserveridentity", "false");
            properties.put("mail.smtp.ssl.trust", this.conn.getHost());
        }
        MimeMessage msg = new MimeMessage(Session.getInstance((Properties)properties, (Authenticator)new MailAuthenticator(this.conn.getUsername(), this.conn.getPassword())));
        msg.addHeader("Content-Type", "text/HTML; charset=UTF-8");
        msg.setSentDate(new Date());
        msg.setFrom((Address)(message.getFromField().isEmpty() ? null : new InternetAddress(message.getFromField())));
        for (String to : message.getToField()) {
            if (!SmtpService.emailAddressAllowed(to)) continue;
            msg.addRecipients(Message.RecipientType.TO, to);
        }
        for (String cc : message.getCcField()) {
            if (!SmtpService.emailAddressAllowed(cc)) continue;
            msg.addRecipients(Message.RecipientType.CC, cc);
        }
        msg.setSubject(StringUtils.encodeBase64Codec(message.getSubjectField()));
        msg.setText(message.getBodyField(), ConfigManager.system.getCharacterEncoding());
        ActionMessages errors = new ActionMessages();
        if (msg.getAllRecipients() != null) {
            try {
                Transport.send((Message)msg);
                LOGGER.info(LogConfigManager.EMAIL_PREFIX + " Successfully sent an email message to: " + SmtpService.joinList(msg.getAllRecipients(), ","));
            }
            catch (AuthenticationFailedException e) {
                errors.add("sendMail", new ActionMessage("admin.config.email.error.authentication"));
                LOGGER.severe(LogConfigManager.EMAIL_PREFIX + " Failed to send mail: Authentication error. Please make sure username and password are correct.");
            }
            catch (Exception e) {
                errors.add("sendMail", new ActionMessage("admin.config.email.error", e.getClass(), e.getMessage()));
                LOGGER.log(Level.SEVERE, LogConfigManager.EMAIL_PREFIX + " Failed to send mail to: " + SmtpService.joinList(msg.getAllRecipients(), ","), e);
            }
        }
        return errors;
    }

    public static boolean emailAddressAllowed(String receipient) {
        if (ConfigManager.email.getAllowedDomainLowercaseOptions().isEmpty()) {
            return true;
        }
        LOGGER.info(LogConfigManager.EMAIL_PREFIX + " Check recipient " + receipient + " is allowed in domain list. " + ConfigManager.email.getAllowedDomainLowercaseOptions());
        for (String allowedDomain : ConfigManager.email.getAllowedDomainLowercaseOptions()) {
            if (!receipient.toLowerCase().endsWith(allowedDomain)) continue;
            return true;
        }
        LOGGER.info(LogConfigManager.EMAIL_PREFIX + " Recipient " + receipient + " was blocked because it's not in allowed domain list.");
        return false;
    }

    public static boolean isMessageOriginatedFromApp(String smtpFrom, String messageFrom) {
        return IssueEmailParser.parseEmailAddress(smtpFrom).equalsIgnoreCase(messageFrom);
    }

    public static void testIsMessageOriginatedFromApp() {
        System.out.println(SmtpService.isMessageOriginatedFromApp("Kwoksys <support@kwoksys.com>", "Support@kwoksys.com"));
        System.out.println(SmtpService.isMessageOriginatedFromApp("Kwoksys < Support@kwoksys.com> ", "support@kwoksys.com"));
        System.out.println(SmtpService.isMessageOriginatedFromApp("support@kwoksys.com ", "Support@kwoksys.com"));
        System.out.println(SmtpService.isMessageOriginatedFromApp("support@Kwoksys.com", "support@kwoksys.com"));
    }

    public static String joinList(Address[] addresses, String token) {
        StringBuilder result = new StringBuilder();
        for (Address address : addresses) {
            if (result.length() != 0) {
                result.append(token).append(" ");
            }
            result.append(address.toString());
        }
        return result.toString();
    }

    public static void isEmailAddressValidTest() {
        String regex = ".*@.*\\..*";
        System.out.println(SmtpService.isEmailAddressValid(regex, "test@kwoksys.com"));
    }

    public static boolean isEmailAddressValid(String regex, String emailAddress) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(emailAddress);
        return matcher.find();
    }
}

