/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.http;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.util.NumberUtils;
import com.kwoksys.framework.util.StringUtils;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class RequestContext {
    public static final String PAGE_START_TIME = "_pageStartTime";
    public static final String PAGE_EXEC_TIME = "_pageExecutionTime";
    public static final String REQUEST_CONTEXT = "_requestContext";
    public static final String MODULE_KEY = "_module";
    public static final String USER_KEY = "_user";
    public static final String HAS_ERROR_KEY = "_hasErrors";
    public static final String MESSAGES_KEY = "_messages";
    public static final String ERROR_FIELDS_KEY = "_formErrorFields";
    public static final String FORM_KEY = "form";
    public static final String URL_PARAM_RESUBMIT = "_resubmit";
    public static final String URL_PARAM_AJAX = "_ajax";
    public static final String URL_PARAM_NOTIFY = "_notify";
    public static final String URL_PARAM_NOTIFY_TRUE = "_notify=true";
    public static final String URL_PARAM_ERROR = "_error";
    public static final String URL_PARAM_ERROR_TRUE = "_error=true";
    private HttpServletRequest request;
    private String pageName;
    private ActionConfig actionConfig;
    private AccessUser user = Access.GUESS_USER;
    private Date sysDate;

    public RequestContext() {
    }

    public RequestContext(HttpServletRequest request) {
        this.request = request;
        request.setAttribute(REQUEST_CONTEXT, (Object)this);
    }

    public AccessUser getUser() {
        if (this.request != null) {
            this.user = (AccessUser)this.request.getAttribute(USER_KEY);
        }
        return this.user;
    }

    public void setSysdate(Date sysDate) {
        this.sysDate = sysDate;
    }

    public Date getSysdate() {
        return this.sysDate;
    }

    public Locale getLocale() {
        return RequestContext.getLocale(this.request);
    }

    public static Locale getLocale(HttpServletRequest request) {
        if (request != null) {
            return (Locale)request.getSession().getAttribute("SESSION_LOCALE");
        }
        return ConfigManager.system.getLocale();
    }

    public int getParameter(String paramName) {
        String requestValue = this.request.getParameter(paramName);
        return NumberUtils.replaceNull(requestValue);
    }

    public int getParameter(String paramName, int defaultValue) {
        String requestValue = this.request.getParameter(paramName);
        return NumberUtils.replaceNull(requestValue, defaultValue);
    }

    public Integer getParameterInteger(String paramName) {
        String requestValue = this.request.getParameter(paramName);
        return requestValue == null ? null : NumberUtils.replaceNull(requestValue);
    }

    public String getParameterString(String paramName) {
        String requestValue = this.request.getParameter(paramName);
        return StringUtils.replaceNull(requestValue);
    }

    public String getParameterString(String paramName, String defaultValue) {
        String requestValue = this.request.getParameter(paramName);
        return StringUtils.replaceNull(requestValue, defaultValue);
    }

    public List<String> getParameterStrings(String paramName, List<String> defaultValues) {
        if (this.request.getParameterValues(paramName) == null) {
            return defaultValues;
        }
        return this.getParameterStrings(paramName);
    }

    public List<String> getParameterStrings(String paramName) {
        String[] strings = this.request.getParameterValues(paramName);
        ArrayList<String> list = new ArrayList<String>();
        if (strings != null) {
            for (String value : strings) {
                if (value.isEmpty()) continue;
                list.add(value);
            }
        }
        return list;
    }

    public boolean getParameterBoolean(String paramName) {
        String requestValue = this.request.getParameter(paramName);
        return "true".equals(requestValue);
    }

    public boolean getParameterBoolean(String paramName, boolean defaultValue) {
        String requestValue = this.request.getParameter(paramName);
        if (requestValue == null) {
            return defaultValue;
        }
        return "true".equals(requestValue);
    }

    public List<Integer> getParameters(String paramName) {
        String[] strings = this.request.getParameterValues(paramName);
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (strings != null) {
            for (String value : strings) {
                if (value.isEmpty()) continue;
                list.add(Integer.parseInt(value));
            }
        }
        return list;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public void setUser(AccessUser user) {
        this.user = user;
    }

    public boolean isAjax() {
        return this.getParameterBoolean(URL_PARAM_AJAX);
    }

    public boolean hasErrors() {
        return this.getParameterBoolean(URL_PARAM_ERROR) || "true".equals(this.request.getAttribute(URL_PARAM_ERROR));
    }

    public String getPageName() {
        return this.pageName == null ? this.request.getServletPath() : this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public ActionConfig getActionConfig() {
        return this.actionConfig;
    }

    public void setActionConfig(ActionConfig actionConfig) {
        this.actionConfig = actionConfig;
    }

    public void setModuleId(Integer moduleId) {
        this.request.setAttribute(MODULE_KEY, (Object)moduleId);
    }

    public Integer getModuleId() {
        return (Integer)this.request.getAttribute(MODULE_KEY);
    }
}

