/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.parsers.email;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IssueEmailParser {
    public static final String EMAIL_BODY_SEPARATOR = "----------------------------------------";

    public static String parseEmailAddress(String content) {
        String regex = ".*?<(.*?)>";
        Matcher m = Pattern.compile(regex).matcher(content.trim());
        if (m.matches()) {
            try {
                content = m.group(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return content.trim();
    }

    public static Integer parseEmailIssueId(String content) {
        Integer issueId = null;
        if (content == null) {
            return issueId;
        }
        String regex = ".*?\\[.*? (.*?)\\].*?";
        Matcher m = Pattern.compile(regex).matcher(content);
        if (m.matches()) {
            try {
                issueId = Integer.parseInt(m.group(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return issueId;
    }

    public static String parseEmailBody(String content) {
        if (content.contains(EMAIL_BODY_SEPARATOR)) {
            return content.substring(0, content.indexOf(EMAIL_BODY_SEPARATOR));
        }
        return content;
    }
}

