/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.parsers.rss;

import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.files.core.FileUtils;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.parsers.rss.RssModel;
import com.kwoksys.framework.util.HttpHelper;
import com.kwoksys.framework.util.XmlUtils;
import java.io.StringReader;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class RssModelHelper {
    private static final Logger LOGGER = Logger.getLogger(BaseDao.class.getName());
    private String xmlString;
    private RssModel rssModel;

    public static void main(String[] args) throws Exception {
        String xmlString = FileUtils.fileToString("C:\\Kwok\\server\\Projects\\Trunk\\kwok-app\\src\\main\\com\\kwoksys\\web\\modules\\rss\\XssVulnerabilityTest.xml");
        new RssModelHelper().xmlToModel(xmlString);
    }

    public void xmlToModel(String xmlString) throws Exception {
        this.xmlString = xmlString;
        this.rssModel = new RssModel();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        StringReader reader = new StringReader(xmlString);
        XMLStreamReader streamReader = xmlInputFactory.createXMLStreamReader(reader);
        this.rssModel = new RssModel();
        RssModel.Item rssItem = null;
        while (streamReader.hasNext()) {
            try {
                streamReader.next();
                if (streamReader.getEventType() == 1) {
                    if (streamReader.getLocalName().equalsIgnoreCase("item")) {
                        rssItem = this.rssModel.new RssModel.Item();
                        rssItem.setTitle("");
                        rssItem.setLink("");
                        rssItem.setDescription("");
                    }
                    if (rssItem == null) {
                        if (streamReader.getLocalName().equalsIgnoreCase("title")) {
                            this.rssModel.setTitle(streamReader.getElementText());
                        }
                        if (streamReader.getLocalName().equalsIgnoreCase("description")) {
                            this.rssModel.setDescription(streamReader.getElementText());
                        }
                        if (streamReader.getLocalName().equalsIgnoreCase("link")) {
                            this.rssModel.setLink(streamReader.getElementText());
                        }
                        if (streamReader.getLocalName().equalsIgnoreCase("pubDate")) {
                            this.rssModel.setDescription(streamReader.getElementText());
                        }
                    } else {
                        if (streamReader.getLocalName().equalsIgnoreCase("title")) {
                            rssItem.setTitle(streamReader.getElementText());
                        }
                        if (streamReader.getLocalName().equalsIgnoreCase("description")) {
                            rssItem.setDescription(streamReader.getElementText());
                        }
                        if (streamReader.getLocalName().equalsIgnoreCase("link")) {
                            rssItem.setLink(streamReader.getElementText());
                        }
                    }
                }
                if (streamReader.getEventType() != 2 || !streamReader.getLocalName().equalsIgnoreCase("item")) continue;
                this.rssModel.addItem(rssItem);
                rssItem = null;
            }
            catch (Exception e) {
                LOGGER.info("skipped the one that cannot be parsed" + e.getLocalizedMessage());
            }
        }
    }

    public void urlToModel(String url) throws Exception {
        HttpHelper httpHelper = new HttpHelper();
        if (!ConfigManager.app.getRssProxyServerAddress().isEmpty()) {
            httpHelper.setProxyServerAddress(ConfigManager.app.getRssProxyServerAddress());
        }
        if (!ConfigManager.app.getRssProxyServerPort().isEmpty()) {
            httpHelper.setProxyServerPort(Integer.parseInt(ConfigManager.app.getRssProxyServerPort()));
        }
        this.xmlToModel(httpHelper.getContent(url));
    }

    public void modelToXml(RssModel rssModel) {
        this.rssModel = rssModel;
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement rss = factory.createOMElement("rss", null);
        rss.addAttribute("version", "2.0", null);
        OMElement channel = factory.createOMElement("channel", null, (OMContainer)rss);
        if (rssModel.getTitle() != null) {
            factory.createOMElement("title", null, (OMContainer)channel).setText(rssModel.getTitle());
        }
        if (rssModel.getLink() != null) {
            factory.createOMElement("link", null, (OMContainer)channel).setText(rssModel.getLink());
        }
        if (rssModel.getDescription() != null) {
            factory.createOMElement("description", null, (OMContainer)channel).setText(rssModel.getDescription());
        }
        if (rssModel.getLanguage() != null) {
            factory.createOMElement("language", null, (OMContainer)channel).setText(rssModel.getLanguage());
        }
        for (RssModel.Item rssItem : rssModel.getItems()) {
            OMElement item = factory.createOMElement("item", null, (OMContainer)channel);
            factory.createOMElement("title", null, (OMContainer)item).setText(rssItem.getTitle());
            factory.createOMElement("link", null, (OMContainer)item).setText(rssItem.getLink());
        }
        this.xmlString = XmlUtils.prependDocType(rss.toString());
    }

    public String getXmlString() {
        return this.xmlString;
    }

    public RssModel getRssModel() {
        return this.rssModel;
    }
}

