/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.parsers.wiki;

import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.parsers.wiki.Parser;
import com.kwoksys.framework.parsers.wiki.Tag;
import com.kwoksys.framework.parsers.wiki.generic.MatchingTags;
import com.kwoksys.framework.parsers.wiki.generic.SingleTag;
import com.kwoksys.framework.parsers.wiki.mediawiki.ExternalLabelLinkTag;
import com.kwoksys.framework.parsers.wiki.mediawiki.ExternalLinkTag;
import com.kwoksys.framework.parsers.wiki.mediawiki.ExternalNumberLinkTag;
import com.kwoksys.framework.parsers.wiki.mediawiki.HtmlEncodeTag;
import com.kwoksys.framework.parsers.wiki.mediawiki.HtmlRestoreTag;
import com.kwoksys.framework.parsers.wiki.mediawiki.InternalLabelLinkTag;
import com.kwoksys.framework.parsers.wiki.mediawiki.InternalLinkTag;
import com.kwoksys.framework.parsers.wiki.mediawiki.NowikiRestoreTag;
import com.kwoksys.framework.parsers.wiki.mediawiki.NowikiStripTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MediawikiParser
extends Parser {
    public static List<Tag> list = new ArrayList<Tag>();
    private Map<Integer, String> nowikiMap = new HashMap<Integer, String>();
    private int externalLinkCounter = 1;
    private StringBuffer sb;

    @Override
    public String parseHtml(RequestContext requestContext, String content) {
        this.sb = new StringBuffer(content);
        NowikiStripTag stripTag = new NowikiStripTag("<nowiki>(([\\S\\s\r\n])*?)</nowiki>");
        stripTag.setTags("<nowiki>", "</nowiki>");
        stripTag.setRestoreGroup(1);
        this.parseContent(stripTag);
        stripTag = new NowikiStripTag("<pre(.*?)>(([\\S\\s\r\n])*?)</pre>");
        stripTag.setTags("<pre$1>", "</pre>");
        stripTag.setRestoreGroup(2);
        this.parseContent(stripTag);
        Tag tag = new SingleTag("<!-{2,} (.+?) -{2,}>");
        tag.setExample("<!-- This is a comment -->");
        tag.setTag("");
        this.parseContent(tag);
        tag = new HtmlEncodeTag();
        this.parseContent(tag);
        tag = new HtmlRestoreTag("&lt;(i|b|del|s|strike|blockquote|(br(|( *?/)|/))|((code|tt|div|font|span|table|td|tr)(.*?))|((/)(i|b|del|s|strike|blockquote|code|tt|font|div|span|table|td|tr)))&gt;");
        this.parseContent(tag);
        tag = new MatchingTags("'''''(.+?)'''''");
        tag.setExample("'''''bold & italic'''''");
        tag.setTags("<i><b>", "</b></i>");
        this.parseContent(tag);
        tag = new MatchingTags("'''(.+?)'''");
        tag.setExample("'''bold'''");
        tag.setTags("<b>", "</b>");
        this.parseContent(tag);
        tag = new MatchingTags("''(.+?)''");
        tag.setExample("''italic''");
        tag.setTags("<i>", "</i>");
        this.parseContent(tag);
        tag = new MatchingTags("^======(.+?)======");
        tag.setExample("======level 6======");
        tag.setTags("<h6>", "</h6>");
        this.parseContent(tag);
        tag = new MatchingTags("^=====(.+?)=====");
        tag.setExample("=====level 5=====");
        tag.setTags("<h5>", "</h5>");
        this.parseContent(tag);
        tag = new MatchingTags("^====(.+?)====");
        tag.setExample("====level 4====");
        tag.setTags("<h4>", "</h4>");
        this.parseContent(tag);
        tag = new MatchingTags("^===(.+?)===");
        tag.setExample("===level 3===");
        tag.setTags("<h3>", "</h3>");
        this.parseContent(tag);
        tag = new MatchingTags("^==(.+?)==");
        tag.setExample("==level 2==");
        tag.setTags("<h2 class=\"mediawikiH2\">", "</h2>");
        this.parseContent(tag);
        tag = new MatchingTags("^=(.+?)=");
        tag.setExample("=level 1=");
        tag.setTags("<h1 class=\"mediawikiH1\">", "</h1>");
        this.parseContent(tag);
        tag = new SingleTag("^----");
        tag.setExample("----");
        tag.setTag("<hr/>");
        this.parseContent(tag);
        tag = new SingleTag("^$");
        tag.setTag("\n<p>");
        this.parseContent(tag);
        tag = new MatchingTags("\n (([\\S\\s\r\n])*?)(\n[^ ]|$)");
        tag.setPattern(32);
        tag.setExample(" preformatted text is done with a space at the beginning of the line");
        tag.setTags("<pre> ", "\n</pre>$3");
        this.parseContent(tag);
        boolean hasMatches = true;
        int ulCharCount = 1;
        while (hasMatches) {
            tag = new MatchingTags("\n(" + this.getCharacters("\\*", ulCharCount++) + "(.+?))(\n[^*]|$)");
            tag.setPattern(32);
            tag.setExample("\n* Bullet 1\n* Bullet 2");
            tag.setTags("\n<ul>\n", "\n</ul>$3");
            this.parseContent(tag);
            hasMatches = tag.hasMatches();
        }
        tag = new MatchingTags("^\\*+(.+)$");
        tag.setExample("* one");
        tag.setTags("<li>\n", "\n</li>");
        this.parseContent(tag);
        hasMatches = true;
        int olCharCount = 1;
        while (hasMatches) {
            tag = new MatchingTags("\n(" + this.getCharacters("\\#", olCharCount++) + "(.+?))(\n[^#]|$)");
            tag.setPattern(32);
            tag.setExample("\n# Bullet 1\n# Bullet 2");
            tag.setTags("\n<ol>\n", "\n</ol>$3");
            this.parseContent(tag);
            hasMatches = tag.hasMatches();
        }
        tag = new MatchingTags("^\\#+(.+)$");
        tag.setExample("# one");
        tag.setTags("<li>\n", "\n</li>");
        this.parseContent(tag);
        tag = new InternalLabelLinkTag(requestContext, "\\[\\[([\\w ]+?)\\|(.+?)\\]\\]");
        tag.setExample("[[Main Page|different text]]");
        this.parseContent(tag);
        tag = new InternalLinkTag(requestContext, "\\[\\[([\\w ]+?)\\]\\]");
        tag.setExample("[[Main Page]]");
        this.parseContent(tag);
        tag = new ExternalLinkTag("(^|.)((https|http|ftp)://.+?)($|[^\\w\\.:/\\?=&#;])");
        tag.setExample("http://mediawiki.org");
        this.parseContent(tag);
        tag = new ExternalLabelLinkTag("\\[((https|http|ftp)://.+?) (.+?)\\]");
        tag.setExample("[http://mediawiki.org MediaWiki]");
        this.parseContent(tag);
        tag = new ExternalNumberLinkTag("\\[((https|http|ftp)://.+?)\\]");
        tag.setExample("[http://mediawiki.org]");
        this.parseContent(tag);
        NowikiRestoreTag restoreTag = new NowikiRestoreTag("&lt;nowiki&gt;([0-9]+)&lt;/nowiki&gt;");
        restoreTag.setRestoreGroup(1);
        restoreTag.setTags("", "");
        this.parseContent(restoreTag);
        restoreTag = new NowikiRestoreTag("&lt;pre(.*?)&gt;([0-9]+)&lt;/pre&gt;");
        restoreTag.setRestoreGroup(2);
        restoreTag.setTags("<pre$1>", "</pre>");
        this.parseContent(restoreTag);
        return this.sb.toString();
    }

    public void parseContent(Tag tag) {
        this.sb = tag.parseContent(this.sb, this);
    }

    public static String getLinkCssClass(String prefix) {
        if ("https".equals(prefix) || "http".equals(prefix) || "ftp".equals(prefix)) {
            return "link_" + prefix;
        }
        return "";
    }

    public int incrExternalLinkLevel() {
        return this.externalLinkCounter++;
    }

    public Map<Integer, String> getNowikiMap() {
        return this.nowikiMap;
    }

    private String getCharacters(String character, int numberOfTimes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfTimes; ++i) {
            sb.append(character);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        MediawikiParser parse = new MediawikiParser();
        MatchingTags tag = new MatchingTags("'''''(.+?)'''''");
        tag.setTags("<i><b>", "</b></i>");
        System.out.println(tag.parseContent(new StringBuffer("This is a \n'''''bold & italic'''''"), parse));
    }
}

