/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.parsers.wiki;

import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Parser {
    public static final String WIKI_URL = AppPaths.KB_ARTICLE_DETAIL + "?title=";
    public static final Pattern LINK_PATTERN = Pattern.compile("(?<!\")((http|https|ftp)" + HtmlUtils.encode("://") + "[^\\s]+)(?!\")", 2);
    private Map<String, String> options;

    public abstract String parseHtml(RequestContext var1, String var2);

    public void setOption(String propName, String propValue) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(propName, propValue);
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public static String replaceLineBreaks(String content) {
        return content == null ? "" : content.replace("\n", "<br>");
    }

    public static String convertUrls(String fieldValue) {
        Matcher m = LINK_PATTERN.matcher(fieldValue);
        if (m.find()) {
            fieldValue = m.replaceAll("<a href=\"$1\" target=\"_blank\">$1</a>");
        }
        return fieldValue;
    }
}

