/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.parsers.wiki;

import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.parsers.wiki.Parser;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.Map;

public class TextParser
extends Parser {
    public static final String OPTION_ENCODE_HTML = "encodehtml";
    public static final String OPTION_REPLACE_LINE_BREAKS = "replacelinebreak";
    public static final String OPTION_CONVERT_URLS = "converturls";

    @Override
    public String parseHtml(RequestContext requestContext, String content) {
        Map<String, String> options = this.getOptions();
        if (options != null) {
            if (options.containsKey(OPTION_ENCODE_HTML) && options.get(OPTION_ENCODE_HTML) == "true") {
                content = HtmlUtils.encode(content);
            }
            if (options.containsKey(OPTION_REPLACE_LINE_BREAKS) && options.get(OPTION_REPLACE_LINE_BREAKS) == "true") {
                content = TextParser.replaceLineBreaks(content);
            }
            if (options.containsKey(OPTION_CONVERT_URLS) && options.get(OPTION_CONVERT_URLS) == "true") {
                content = TextParser.convertUrls(content);
            }
        }
        return content;
    }
}

