/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.parsers.wiki.mediawiki;

import com.kwoksys.framework.parsers.wiki.MediawikiParser;
import com.kwoksys.framework.parsers.wiki.Parser;
import com.kwoksys.framework.parsers.wiki.Tag;
import com.kwoksys.framework.util.HtmlUtils;
import com.kwoksys.framework.util.StringUtils;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NowikiRestoreTag
extends Tag {
    private int restoreGroup;

    public NowikiRestoreTag(String regex) {
        super(regex);
    }

    @Override
    public StringBuffer parseContent(StringBuffer content, Parser parser) {
        Map<Integer, String> nowikiMap = ((MediawikiParser)parser).getNowikiMap();
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile(this.getRegex(), 8).matcher(content);
        while (m.find()) {
            int index = Integer.parseInt(m.group(this.restoreGroup));
            String replace = HtmlUtils.encode(nowikiMap.get(index));
            m.appendReplacement(sb, this.getOpenTag() + StringUtils.encodeMatcherReplacement(replace) + this.getCloseTag());
            nowikiMap.remove(index);
        }
        m.appendTail(sb);
        return sb;
    }

    public void setRestoreGroup(int restoreGroup) {
        this.restoreGroup = restoreGroup;
    }
}

