/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.properties;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class LocalizationSync {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void main(String[] args) throws Exception {
        String[] locales = new String[]{"de_DE", "es_ES", "hu_HU", "it_IT", "nl_NL", "pl_PL", "pt_BR", "sr_YU", "zh_CN"};
        LocalizationSync localizationSync = new LocalizationSync();
        for (String locale : locales) {
            localizationSync.processLocaleFile(locale);
        }
    }

    public void processLocaleFile(String locale) throws Exception {
        System.out.println("Processing locale: " + locale + "\n");
        TreeMap<String, String> map = new TreeMap<String, String>();
        String path = "C:\\Kwok\\Projects\\Trunk\\kwok-app\\web\\WEB-INF\\classes\\properties\\localization\\";
        String localeFile = path + "Localization_" + locale + ".properties";
        Properties baseProps = new Properties();
        baseProps.load(new FileInputStream(path + "Localization.properties"));
        for (Map.Entry<Object, Object> entry : baseProps.entrySet()) {
            map.put((String)entry.getKey(), LocalizationSync.escape((String)entry.getValue()));
        }
        Properties localeProps = new Properties();
        localeProps.load(new FileInputStream(localeFile));
        for (Map.Entry<Object, Object> entry : localeProps.entrySet()) {
            if (!map.containsKey(entry.getKey())) {
                System.out.println("Key missing in Localization.properties: " + entry.getKey());
            }
            map.put((String)entry.getKey(), LocalizationSync.escape((String)entry.getValue()));
        }
        this.write(locale, localeFile, map);
    }

    private void write(String locale, String localeFile, Map<String, String> map) throws Exception {
        FileWriter fos = new FileWriter(localeFile);
        fos.write("# ====================================================================\n# Copyright 2018 Kwoksys\n#\n# http://www.kwoksys.com/LICENSE\n#\n# Licensed under the Apache License, Version 2.0 (the \"License\");\n# you may not use this file except in compliance with the License.\n# You may obtain a copy of the License at\n#\n# http://www.apache.org/licenses/LICENSE-2.0\n#\n# Unless required by applicable law or agreed to in writing, software\n# distributed under the License is distributed on an \"AS IS\" BASIS,\n# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n# See the License for the specific language governing permissions and\n# limitations under the License.\n# ====================================================================\n\n#\n# Locale: " + locale + "\n#\n");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().equals("admin.config.timezone")) {
                fos.write(entry.getKey() + " = " + entry.getValue() + "\n");
                this.writeTimezones(fos, map);
                continue;
            }
            if (entry.getKey().startsWith("admin.config.timezone.")) continue;
            fos.write(entry.getKey() + " = " + entry.getValue() + "\n");
        }
        fos.close();
    }

    private void writeTimezones(FileWriter fos, Map<String, String> map) throws Exception {
        String[] timezones;
        for (String timezone : timezones = new String[]{"Etc/GMT+12", "Etc/GMT+11", "US/Hawaii", "US/Alaska", "PST", "US/Arizona", "US/Mountain", "US/Central", "US/Eastern", "Canada/Atlantic", "America/Montevideo", "Atlantic/South_Georgia", "Atlantic/Cape_Verde", "Etc/Greenwich", "Europe/London", "Europe/Amsterdam", "Asia/Jerusalem", "Europe/Moscow", "Asia/Tehran", "Asia/Baku", "Asia/Kabul", "Asia/Karachi", "Asia/Calcutta", "Asia/Dhaka", "Asia/Bangkok", "Asia/Hong_Kong", "Asia/Seoul", "Australia/Brisbane", "Australia/Canberra", "Asia/Magadan", "Pacific/Auckland"}) {
            fos.write("admin.config.timezone." + timezone + " = " + map.get("admin.config.timezone." + timezone) + "\n");
        }
    }

    private static String escape(String theString) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case ' ': {
                    if (x == 0) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(LocalizationSync.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(LocalizationSync.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(LocalizationSync.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(LocalizationSync.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

