/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.properties;

import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.http.RequestContext;
import com.opensymphony.xwork2.util.GlobalLocalizedTextProvider;
import jakarta.servlet.http.HttpSession;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Localizer {
    private static final Logger LOGGER = Logger.getLogger(Localizer.class.getName());
    private static final Localizer INSTANCE = new Localizer();
    private static GlobalLocalizedTextProvider textProvider;
    private static Map<Locale, ResourceBundle> resourceBundlesMap;

    public static void init() {
        LOGGER.info(LogConfigManager.CONFIG_PREFIX + " Loading Localizer...");
        Localizer localizer = INSTANCE;
        Objects.requireNonNull(localizer);
        textProvider = localizer.new LocalizedTextProvider();
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle resourceBundle = resourceBundlesMap.get(locale);
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle("properties.localization.Localization", locale);
            resourceBundlesMap.put(locale, resourceBundle);
        }
        return resourceBundle;
    }

    public static void setSessionLocale(HttpSession session, String localeString) {
        String[] strings = localeString.split("_");
        session.setAttribute("SESSION_LOCALE", (Object)new Locale(strings[0], strings[1]));
    }

    public static String getText(Locale locale, String contentKey, Object[] params) {
        return textProvider.findText(Localizer.getResourceBundle(locale), contentKey, locale, null, params);
    }

    public static String getText(Locale locale, String contentKey) {
        return Localizer.getText(locale, contentKey, null);
    }

    public static String getText(RequestContext requestContext, String contentKey, Object[] params) {
        return Localizer.getText(requestContext.getLocale(), contentKey, params);
    }

    public static String getText(RequestContext requestContext, String contentKey) {
        return Localizer.getText(requestContext, contentKey, null);
    }

    static {
        resourceBundlesMap = new HashMap<Locale, ResourceBundle>();
    }

    private class LocalizedTextProvider
    extends GlobalLocalizedTextProvider {
        private LocalizedTextProvider() {
        }

        public String findText(ResourceBundle resourceBundle, String key, Locale locale, String defaultMessage, Object[] args) {
            try {
                String message = resourceBundle.getString(key);
                MessageFormat mf = this.buildMessageFormat(message.replaceAll("'", "''"), locale);
                return this.formatWithNullDetection(mf, args);
            }
            catch (MissingResourceException e) {
                LOGGER.log(Level.WARNING, "Missing key [" + key + "] in bundle [" + resourceBundle.getBaseBundleName() + "].");
                return null;
            }
        }
    }
}

