/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.properties;

import com.kwoksys.biz.system.core.configs.LogConfigManager;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;

public class PropertiesManager {
    private static final Logger LOGGER = Logger.getLogger(PropertiesManager.class.getName());
    private static final Properties props = new Properties();
    public static final String APP_VERSION_KEY = "app.version";
    public static final String APP_PATCH_KEY = "app.patch";
    public static final String BUILD_DATE = "build.date";
    public static final String DB_TYPE_KEY = "db.type";
    public static final String DB_SERVERHOST_KEY = "db.serverHost";
    public static final String DB_SERVERPORT_KEY = "db.serverPort";
    public static final String DB_NAME_KEY = "db.name";
    public static final String DB_USERNAME_KEY = "db.username";
    public static final String DB_PASSWORD_KEY = "db.password";

    private PropertiesManager() {
    }

    public static void init() throws Exception {
        try {
            for (String path : new String[]{"/build.properties", "/properties/Application.properties"}) {
                LOGGER.info(LogConfigManager.CONFIG_PREFIX + " Loading " + path + "...");
                InputStream in = PropertiesManager.class.getResourceAsStream(path);
                props.load(in);
                in.close();
            }
            props.put(DB_TYPE_KEY, "postgres");
        }
        catch (Exception e) {
            throw new Exception("Problem loading property file", e);
        }
    }

    public static String get(String key) {
        return props.containsKey(key) ? props.getProperty(key).trim() : null;
    }

    public static String getVersion() {
        return PropertiesManager.get(APP_VERSION_KEY);
    }

    public static String getPatchVersion() {
        return PropertiesManager.getVersion() + (PropertiesManager.get(APP_PATCH_KEY).isEmpty() ? "" : "." + PropertiesManager.get(APP_PATCH_KEY));
    }
}

