/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.servlets;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.biz.system.core.scheduler.TaskScheduler;
import com.kwoksys.framework.connections.database.DatabaseManager;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.properties.PropertiesManager;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.HttpHelper;
import com.kwoksys.framework.util.StringUtils;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServlet;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemInitServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(SystemInitServlet.class.getName());
    public static boolean init = false;
    public static String initError = "";

    public void init(ServletConfig cfg) {
        ServletContext context = cfg.getServletContext();
        SystemService systemService = ServiceProvider.getSystemService(null);
        try {
            AppPaths.init(context.getContextPath());
            PropertiesManager.init();
            LOGGER.info(LogConfigManager.CONFIG_PREFIX + " Starting Kwok application version " + PropertiesManager.getPatchVersion());
            Properties props = System.getProperties();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                LOGGER.info(LogConfigManager.CONFIG_PREFIX + " " + entry.getKey() + ": " + entry.getValue());
            }
            Localizer.init();
            CacheManager.init();
            TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
            ConfigManager.getInstance().init();
            if (!PropertiesManager.getVersion().equals(ConfigManager.getSchemaVersion())) {
                initError = Localizer.getText(new RequestContext(), "core.template.footer.versionMismatch", (Object[])new String[]{PropertiesManager.getVersion(), ConfigManager.getSchemaVersion()});
                LOGGER.warning(LogConfigManager.CONFIG_PREFIX + " " + initError);
                return;
            }
            try {
                String dbTimezone = systemService.getDatabaseTimezone();
                LOGGER.info(LogConfigManager.CONFIG_PREFIX + " Database timezone is: " + dbTimezone);
                if (!dbTimezone.equalsIgnoreCase(ConfigManager.system.getTimezoneBaseString())) {
                    LOGGER.info(LogConfigManager.CONFIG_PREFIX + " Updating database timezone to: " + ConfigManager.system.getTimezoneBaseString());
                    ActionMessages messages = systemService.updateDatabaseTimezone();
                    if (!messages.isEmpty()) {
                        throw new Exception("Problem updating database timezone");
                    }
                    LOGGER.warning(LogConfigManager.CONFIG_PREFIX + " Done updating database timezone, application server restart required!");
                    return;
                }
            }
            catch (DatabaseException e) {
                throw new Exception("Problem updating database timezone", e);
            }
            TaskScheduler.init();
            init = true;
            LOGGER.info(LogConfigManager.CONFIG_PREFIX + " Kwok application started successfully. Ports: " + StringUtils.join(HttpHelper.getListeningPorts(), ". "));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, LogConfigManager.CONFIG_PREFIX + " " + e.getMessage(), e);
        }
    }

    public void destroy() {
        TaskScheduler.destroy();
        DatabaseManager.destroy();
        LOGGER.info(LogConfigManager.CONFIG_PREFIX + " Kwok application shutdown completed");
    }
}

