/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.session;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AttributeSearch;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.admin.dto.AttributeGroup;
import com.kwoksys.biz.auth.AuthService;
import com.kwoksys.biz.auth.dto.AccessPage;
import com.kwoksys.biz.portal.PortalService;
import com.kwoksys.biz.portal.SiteSearch;
import com.kwoksys.biz.portal.dao.PortalQueries;
import com.kwoksys.biz.portal.dto.Site;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;

public class CacheManager {
    private static final Logger LOGGER = Logger.getLogger(CacheManager.class.getName());
    private static final String PAGES_INFO_CACHE = "pagesInfo";
    private static final String PERMISSION_PAGES_CACHE = "permissionPages";
    private static final String SYSTEM_CONFIG_CACHE = "sysconfig";
    private static final String MODULE_TABS_CACHE = "moduleTabs";
    private static final String SYSTEM_ATTR_MAP_CACHE = "systemAttrMap";
    private static final String SYSTEM_ATTR_FIELDS_CACHE = "systemAttrFields_";
    private static final String CUSTOM_ATTR_GROUPS_CACHE = "customAttrGroups_";
    private static final String GROUP_PERMISSION_CACHE = "groupPermissions_";
    private static final String USER_PERMISSION_CACHE = "userPermissions_";
    private static final String USER_CACHE = "user_";
    private RequestContext requestContext;
    private static JCS jcs;

    public CacheManager() {
    }

    public CacheManager(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public static void init() throws Exception {
        try {
            LOGGER.info(LogConfigManager.CONFIG_PREFIX + " Loading " + "/jcs.properties" + " file...");
            JCS.setConfigFilename((String)"/jcs.properties");
            jcs = JCS.getInstance((String)"KwokCache");
        }
        catch (Exception e) {
            throw new Exception("Failed to get cache instance.", e);
        }
    }

    public void checkRemoveCaches(Long newCacheTime) {
        try {
            Long cacheTime = ConfigManager.system.getCacheTime();
            if (cacheTime == null) {
                ConfigManager.system.setCacheTime(newCacheTime);
                return;
            }
            SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
            List<String> cacheKeys = systemService.getFlushSystemCacheKeys(cacheTime);
            if (!cacheKeys.isEmpty()) {
                for (String cacheKey : cacheKeys) {
                    CacheManager.removeCache(cacheKey);
                }
                systemService.validateSystemCaches(newCacheTime);
                ConfigManager.system.setCacheTime(newCacheTime);
            }
        }
        catch (Exception e) {
            LOGGER.severe("Problem removing cache... " + e.getMessage());
        }
    }

    private void removeClusterCache(String cacheKey) {
        try {
            LOGGER.info(LogConfigManager.CACHE_PREFIX + " Removing cache: " + cacheKey);
            jcs.remove((Object)cacheKey);
            SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
            systemService.resetSystemCache(cacheKey);
        }
        catch (Exception e) {
            LOGGER.severe("Problem removing cache... " + e.getMessage());
        }
    }

    private static Object getCache(String cacheKey) {
        return jcs.get((Object)cacheKey);
    }

    private static void addCache(String cacheKey, Object cacheObject) {
        LOGGER.info(LogConfigManager.CACHE_PREFIX + " Creating cache: " + cacheKey);
        try {
            jcs.put((Object)cacheKey, cacheObject);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Problem creating cache.", e);
        }
    }

    private static void removeCache(String cacheKey) throws CacheException {
        LOGGER.info(LogConfigManager.CACHE_PREFIX + " Removing cache: " + cacheKey);
        jcs.remove((Object)cacheKey);
    }

    public Map<String, String> cacheSystemConfigs() {
        Map<String, String> configMap = null;
        try {
            CacheManager.removeCache(SYSTEM_CONFIG_CACHE);
            SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
            configMap = systemService.getSystemConfig();
            if (!configMap.isEmpty()) {
                CacheManager.addCache(SYSTEM_CONFIG_CACHE, configMap);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Problem creating cache.", e);
        }
        return configMap;
    }

    public Attribute getSystemAttrCache(Integer attributeId) throws DatabaseException {
        HashMap<Integer, Attribute> attrMap = (HashMap<Integer, Attribute>)CacheManager.getCache(SYSTEM_ATTR_MAP_CACHE);
        if (attrMap == null) {
            AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
            attrMap = new HashMap<Integer, Attribute>();
            AttributeSearch attributeSearch = new AttributeSearch();
            attributeSearch.put("isCustomAttr", false);
            for (Attribute attr : adminService.getAttributes(new QueryCriteria(attributeSearch)).values()) {
                attrMap.put(attr.getId(), attr);
            }
            CacheManager.addCache(SYSTEM_ATTR_MAP_CACHE, attrMap);
        }
        return (Attribute)attrMap.get(attributeId);
    }

    public void removeSystemAttrCache() {
        this.removeClusterCache(SYSTEM_ATTR_MAP_CACHE);
    }

    public Map<Integer, AttributeField> getAttributeFieldsCache(Integer attributeId) throws DatabaseException {
        Map<Integer, AttributeField> attrFields = (Map<Integer, AttributeField>)CacheManager.getCache(SYSTEM_ATTR_FIELDS_CACHE + attributeId);
        if (attrFields == null) {
            AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
            attrFields = adminService.getAttributeFields(attributeId);
            CacheManager.addCache(SYSTEM_ATTR_FIELDS_CACHE + attributeId, attrFields);
        }
        return attrFields;
    }

    public void removeAttributeFieldsCache(Integer attributeId) {
        this.removeClusterCache(SYSTEM_ATTR_FIELDS_CACHE + attributeId);
    }

    public Map<Integer, AttributeGroup> getCustomAttrGroupsCache(Integer objectTypeId) throws DatabaseException {
        Map<Integer, AttributeGroup> groupMap = (Map<Integer, AttributeGroup>)CacheManager.getCache(CUSTOM_ATTR_GROUPS_CACHE + objectTypeId);
        if (groupMap == null) {
            groupMap = ServiceProvider.getAdminService(this.requestContext).getAttributeGroups(objectTypeId);
            CacheManager.addCache(CUSTOM_ATTR_GROUPS_CACHE + objectTypeId, groupMap);
        }
        return groupMap;
    }

    public void removeCustomAttrGroupsCache(Integer objectTypeId) {
        this.removeClusterCache(CUSTOM_ATTR_GROUPS_CACHE + objectTypeId);
    }

    public Map<Integer, Set<Integer>> getPermissionPagesCache() throws DatabaseException {
        Map<Integer, Set<Integer>> permPages = (Map<Integer, Set<Integer>>)CacheManager.getCache(PERMISSION_PAGES_CACHE);
        if (permPages == null) {
            AuthService authService = ServiceProvider.getAuthService(this.requestContext);
            permPages = authService.getAccessPermPages();
            CacheManager.addCache(PERMISSION_PAGES_CACHE, permPages);
        }
        return permPages;
    }

    public Set<Integer> getGroupPermissionsCache(Integer groupId) throws DatabaseException {
        Set<Integer> permSet = (Set<Integer>)CacheManager.getCache(GROUP_PERMISSION_CACHE + groupId);
        if (permSet == null) {
            AuthService authService = ServiceProvider.getAuthService(this.requestContext);
            permSet = authService.getAccessGroupPerms(groupId);
            CacheManager.addCache(GROUP_PERMISSION_CACHE + groupId, permSet);
        }
        return permSet;
    }

    public void removeGroupPermissionsCache(Integer groupId) {
        this.removeClusterCache(GROUP_PERMISSION_CACHE + groupId);
    }

    public Set<Integer> getUserPermissionsCache(Integer userId) throws DatabaseException {
        Set<Integer> permSet = (Set<Integer>)CacheManager.getCache(USER_PERMISSION_CACHE + userId);
        if (permSet == null) {
            AuthService authService = ServiceProvider.getAuthService(this.requestContext);
            permSet = authService.getAccessUserPerms(userId);
            CacheManager.addCache(USER_PERMISSION_CACHE + userId, permSet);
        }
        return permSet;
    }

    public void removeUserPermissionsCache(Integer userId) {
        this.removeClusterCache(USER_PERMISSION_CACHE + userId);
    }

    public Map<String, AccessPage> getPagesInfoCache() throws DatabaseException {
        Map pageMap = (Map)CacheManager.getCache(PAGES_INFO_CACHE);
        if (pageMap == null) {
            AuthService authService = ServiceProvider.getAuthService(this.requestContext);
            pageMap = authService.getAccessPages();
            CacheManager.addCache(PAGES_INFO_CACHE, pageMap);
        }
        return pageMap;
    }

    public List<Site> getModuleTabsCache() throws DatabaseException {
        List<Site> list = (List<Site>)CacheManager.getCache(MODULE_TABS_CACHE);
        if (list == null) {
            SiteSearch siteSearch = new SiteSearch();
            siteSearch.put("shownOnTab", "");
            QueryCriteria query = new QueryCriteria(siteSearch);
            query.addSortColumn(PortalQueries.getOrderByColumn("site_name"));
            PortalService portalService = ServiceProvider.getPortalService(this.requestContext);
            list = portalService.getSites(query);
            CacheManager.addCache(MODULE_TABS_CACHE, list);
        }
        return list;
    }

    public void removeModuleTabsCache() {
        this.removeClusterCache(MODULE_TABS_CACHE);
    }

    public AccessUser getUserCache(Integer userId) throws DatabaseException {
        AccessUser accessUser = (AccessUser)CacheManager.getCache(USER_CACHE + userId);
        if (accessUser == null) {
            try {
                accessUser = ServiceProvider.getAdminService(this.requestContext).getUser(userId);
            }
            catch (ObjectNotFoundException e) {
                accessUser = new AccessUser(userId);
                accessUser.setRemoved(true);
            }
            CacheManager.addCache(USER_CACHE + userId, accessUser);
        }
        return accessUser;
    }

    public AccessUser getUserCacheValidate(Integer userId) throws DatabaseException, ObjectNotFoundException {
        AccessUser accessUser = (AccessUser)CacheManager.getCache(USER_CACHE + userId);
        if (accessUser == null) {
            accessUser = ServiceProvider.getAdminService(this.requestContext).getUser(userId);
            CacheManager.addCache(USER_CACHE + userId, accessUser);
        }
        return accessUser;
    }

    public void removeUserCache(Integer userId) {
        this.removeClusterCache(USER_CACHE + userId);
    }
}

