/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.session;

import com.kwoksys.biz.system.core.AppPaths;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;

public class CookieManager {
    private static final String USER_ID = "userId";
    private static final String SESSION_TOKEN = "sessionToken";
    private static final String CUSTOM_FIELDS_EXPAND = "customFieldsExpand";

    private static String getCookieValue(Cookie[] cookies, String cookieName) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return "";
    }

    private static void setCookie(HttpServletResponse response, String cookieKey, String cookieValue) {
        Cookie cookie = new Cookie(cookieKey, cookieValue);
        cookie.setPath(AppPaths.COOKIE_ROOT);
        response.addCookie(cookie);
    }

    private static void clearCookie(HttpServletResponse response, String cookieKey) {
        Cookie cookie = new Cookie(cookieKey, "");
        cookie.setPath(AppPaths.COOKIE_ROOT);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public static void setUserId(HttpServletResponse response, String cookieValue) {
        CookieManager.setCookie(response, USER_ID, cookieValue);
    }

    public static String getUserId(Cookie[] cookies) {
        return CookieManager.getCookieValue(cookies, USER_ID);
    }

    public static void setSessionToken(HttpServletResponse response, String cookieValue) {
        CookieManager.setCookie(response, SESSION_TOKEN, cookieValue);
    }

    public static String getSessionToken(Cookie[] cookies) {
        return CookieManager.getCookieValue(cookies, SESSION_TOKEN);
    }

    public static String getCustomFieldsExpand(Cookie[] cookies) {
        return CookieManager.getCookieValue(cookies, CUSTOM_FIELDS_EXPAND);
    }

    public static void clearAllCookies(HttpServletResponse response) {
        CookieManager.clearCookie(response, USER_ID);
        CookieManager.clearCookie(response, SESSION_TOKEN);
        CookieManager.clearCookie(response, CUSTOM_FIELDS_EXPAND);
    }
}

