/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.struts2;

import com.kwoksys.action.common.template.AjaxTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.AuthService;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.auth.core.AuthUtils;
import com.kwoksys.biz.auth.dto.AccessPage;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.biz.system.dto.SystemInfo;
import com.kwoksys.framework.exceptions.AccessDeniedException;
import com.kwoksys.framework.exceptions.AjaxAuthenticationRequiredException;
import com.kwoksys.framework.exceptions.AuthenticationRequiredException;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.NonSupportedBrowserException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.servlets.SystemInitServlet;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.session.CookieManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.util.HttpHelper;
import com.kwoksys.framework.validations.BrowserValidator;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.struts2.ServletActionContext;

public class RequestInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = Logger.getLogger(RequestInterceptor.class.getName());

    public String intercept(ActionInvocation actionInvocation) throws Exception {
        RequestContext requestContext = new RequestContext(ServletActionContext.getRequest());
        ResponseContext responseContext = new ResponseContext(ServletActionContext.getResponse());
        try {
            ActionProxy actionProxy = actionInvocation.getProxy();
            requestContext.setActionConfig(actionProxy.getConfig());
            Action2 action2 = (Action2)((Object)actionProxy.getAction());
            action2.setRequestContext(requestContext);
            requestContext.setPageName("/" + actionProxy.getActionName() + ConfigManager.system.getExtension());
            if (!RequestInterceptor.validate(requestContext, responseContext)) {
                return null;
            }
            return actionProxy.getInvocation().invoke();
        }
        catch (AuthenticationRequiredException e) {
            responseContext.sendUnauthorized();
            return "authentication_required";
        }
        catch (AjaxAuthenticationRequiredException e) {
            AjaxTemplate ajaxTemplate = new AjaxTemplate(requestContext);
            ajaxTemplate.setAjaxTemplatePath(AjaxTemplate.getTemplatePath(requestContext, "ajax_authentication_required"));
            ajaxTemplate.applyTemplate();
            requestContext.getRequest().setAttribute("redirectUrl", (Object)e.getLoginUrl());
            return "ajax_template";
        }
        catch (AccessDeniedException e) {
            return "access_denied";
        }
        catch (FileNotFoundException e) {
            return "file_not_found";
        }
        catch (NonSupportedBrowserException e) {
            return "non_supported_browser";
        }
        catch (ObjectNotFoundException e) {
            LOGGER.log(Level.WARNING, "Object not found. " + e.getMessage());
            return "object_not_found";
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Problem processing request.", e);
            responseContext.sendServerError();
            return null;
        }
    }

    public static boolean validate(RequestContext requestContext, ResponseContext responseContext) throws Exception {
        SystemInfo systemInfo;
        HttpServletRequest request = requestContext.getRequest();
        HttpServletResponse response = responseContext.getResponse();
        request.setCharacterEncoding(ConfigManager.system.getCharacterEncoding());
        request.setAttribute("_pageStartTime", (Object)System.currentTimeMillis());
        response.setHeader("X-UA-Compatible", "IE=edge,chrome=1");
        HttpHelper.setNoCacheResponseHeaders(response);
        response.setCharacterEncoding(ConfigManager.system.getCharacterEncoding());
        if (!SystemInitServlet.init) {
            LOGGER.warning("System not initialized. " + SystemInitServlet.initError);
            responseContext.sendServiceUnavailable();
            return false;
        }
        SystemService systemService = ServiceProvider.getSystemService(requestContext);
        try {
            systemInfo = systemService.getSystemInfo();
            if (!systemInfo.getCacheKey().equals(ConfigManager.system.getCacheKey())) {
                ConfigManager.getInstance().init();
            }
            new CacheManager(requestContext).checkRemoveCaches(systemInfo.getSysdate().getTime());
        }
        catch (DatabaseException e) {
            responseContext.sendServiceUnavailable();
            return false;
        }
        RequestInterceptor.initSession(requestContext);
        String pageName = requestContext.getPageName();
        AccessPage accessPage = Access.getAccessPage(pageName);
        requestContext.setModuleId(accessPage == null ? 0 : accessPage.getModuleId());
        requestContext.setSysdate(systemInfo.getSysdate());
        Cookie[] cookies = request.getCookies();
        AccessUser user = Access.getCookieUser(cookies);
        String sessionToken = CookieManager.getSessionToken(cookies).trim();
        LOGGER.info(LogConfigManager.PAGE_REQUEST_PREFIX + " (" + request.getMethod() + ") " + AppPaths.ROOT + requestContext.getPageName() + ", user ID: " + user.getId());
        AuthService authService = ServiceProvider.getAuthService(requestContext);
        boolean isValidSessionToken = authService.isValidUserSession(user.getId(), sessionToken);
        if (!isValidSessionToken) {
            if (ConfigManager.auth.isBasicAuth()) {
                if (!sessionToken.isEmpty() || !authService.isValidBasicAuthentication(user)) {
                    AuthUtils.resetAuthCookies(response, user);
                    Access.requestBasicAuthCredential(requestContext, responseContext);
                    return false;
                }
                authService.initializeUserSession(request, response, user);
                isValidSessionToken = true;
            } else {
                AuthUtils.resetAuthCookies(response, user);
            }
        }
        AdminService adminService = ServiceProvider.getAdminService(requestContext);
        user = adminService.getUser(user.getId());
        request.setAttribute("_user", (Object)user);
        if (user.hasPermission(pageName)) {
            return true;
        }
        if (accessPage == null) {
            throw new FileNotFoundException();
        }
        if (!user.isLoggedOn()) {
            Access.requestCredential(requestContext, responseContext, "loginRequired");
            return false;
        }
        if (!isValidSessionToken) {
            Access.requestCredential(requestContext, responseContext, "sessionExpired");
            return false;
        }
        throw new AccessDeniedException();
    }

    private static void initSession(RequestContext requestContext) throws NonSupportedBrowserException {
        HttpSession session = requestContext.getSession();
        if (session.getAttribute("SESSION_INIT") == null) {
            session.setAttribute("SESSION_INIT", (Object)true);
            Localizer.setSessionLocale(session, ConfigManager.system.getLocaleString());
        }
        if (session.getAttribute("BROWSER_CHECKED") == null && !requestContext.getPageName().equals(AppPaths.HOME_NON_SUPPORTED_BROWSER)) {
            if (!BrowserValidator.isSupportedBrowser(requestContext.getRequest().getHeader("user-agent"))) {
                throw new NonSupportedBrowserException();
            }
            session.setAttribute("BROWSER_CHECKED", (Object)true);
        }
    }

    public static void printRequest(HttpServletRequest request) {
        System.out.println("\n=== Method ===");
        System.out.println(request.getMethod());
        System.out.println("\n=== Headers ===");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            System.out.println(name + ": " + request.getHeader(name));
        }
        System.out.println("\n=== Parameters ===");
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            System.out.println(name + ": " + request.getParameter(name));
        }
    }
}

