/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.tags;

import com.kwoksys.framework.util.HtmlUtils;
import com.kwoksys.framework.util.StringUtils;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.struts2.ServletActionContext;

public class DefineTag
extends TagSupport {
    protected String id;
    protected String name;
    protected String property;
    protected String type;
    protected boolean encodeHtml;
    protected String value;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doStartTag() throws JspException {
        Object output;
        if (this.value != null) {
            output = this.value;
        } else {
            output = this.pageContext.getAttribute(this.name);
            if (output == null) {
                output = ServletActionContext.getRequest().getAttribute(this.name);
            }
            if (this.property != null) {
                if (output instanceof Map) {
                    output = ((Map)output).get(this.property);
                } else if (output instanceof Map.Entry) {
                    if (this.property.equals("key")) {
                        output = ((Map.Entry)output).getKey();
                    } else {
                        if (!this.property.equals("value")) throw new JspException("Property not supported on Map.Entry");
                        output = ((Map.Entry)output).getValue();
                    }
                } else {
                    Method m = null;
                    try {
                        m = output.getClass().getMethod("get" + StringUtils.capitalizeFirstLetter(this.property), null);
                        output = m.invoke(output, new Object[0]);
                    }
                    catch (Exception e) {
                        try {
                            m = output.getClass().getMethod("is" + StringUtils.capitalizeFirstLetter(this.property), null);
                            output = m.invoke(output, new Object[0]);
                        }
                        catch (Exception e2) {
                            throw new JspException((Throwable)e2);
                        }
                    }
                }
            }
        }
        if (this.encodeHtml) {
            output = HtmlUtils.encode((String)output);
        }
        this.pageContext.setAttribute(this.id, output);
        return 0;
    }

    public void release() {
        super.release();
        this.id = null;
        this.name = null;
        this.type = null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setEncodeHtml(boolean encodeHtml) {
        this.encodeHtml = encodeHtml;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

