/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.ui;

import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.util.HtmlUtils;
import com.kwoksys.framework.util.StringUtils;

public class Link {
    private RequestContext requestContext;
    private String name;
    private String title;
    private String path;
    private String id;
    private String inlineImage;
    private boolean imgAlignRight = false;
    private String imgSrc;
    private String imgId;
    private String imageTitle = "";
    private String imgStyleClass;
    private int imgWidth;
    private int imgHeight;
    private String target;
    private String styleClass;
    private String onclick;
    private String dataAttr;

    public Link(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    @Deprecated
    public String toString() {
        return this.getString();
    }

    public String getString() {
        StringBuilder link = new StringBuilder();
        if (!StringUtils.isEmpty(this.imgSrc)) {
            link.append("<img src=\"").append(this.imgSrc).append("\" class=\"standard");
            if (this.imgStyleClass != null) {
                link.append(" ").append(this.imgStyleClass);
            }
            link.append("\" alt=\"").append(this.imageTitle).append("\" title=\"").append(this.imageTitle).append("\"");
            if (this.imgId != null) {
                link.append(" id=\"").append(this.imgId).append("\"");
            }
            if (this.imgWidth != 0 && this.imgHeight != 0) {
                link.append(" width=\"").append(this.imgWidth).append("\" height=\"").append(this.imgHeight).append("\"");
            }
            link.append(">");
        }
        if (!StringUtils.isEmpty(this.inlineImage)) {
            if (this.imgAlignRight) {
                if (this.title != null) {
                    link.append(this.title);
                }
                link.append(this.inlineImage);
            } else {
                link.append(this.inlineImage);
                if (this.title != null) {
                    link.append(this.title);
                }
            }
        } else if (this.title != null) {
            if (this.imgAlignRight) {
                link.insert(0, this.title);
            } else {
                link.append(this.title);
            }
        }
        if (!StringUtils.isEmpty(this.path)) {
            StringBuilder sb = new StringBuilder();
            if (this.target != null) {
                sb.append(" target=\"" + this.target + "\"");
            }
            if (this.styleClass != null) {
                sb.append(" class=\"" + this.styleClass + "\"");
            }
            if (this.onclick != null) {
                sb.append(" onclick=\"" + this.onclick + "\"");
            }
            if (this.dataAttr != null) {
                sb.append(" " + this.dataAttr);
            }
            if (!StringUtils.isEmpty(this.id)) {
                sb.append(" id=\"" + this.id + "\"");
            }
            link.insert(0, "<a href=\"" + this.path + "\"" + sb.toString() + ">");
            link.append("</a>");
        }
        return link.toString();
    }

    public Link setAjaxPath(String path) {
        this.path = AppPaths.ROOT + path;
        this.dataAttr = "data-script=\"updateViewHistory\"";
        return this;
    }

    public Link setExportPath(String path) {
        this.path = AppPaths.ROOT + path;
        this.target = "_blank";
        return this;
    }

    public Link setAppPath(String path) {
        this.path = AppPaths.ROOT + path;
        return this;
    }

    public Link setPath(String path) {
        this.path = path;
        return this;
    }

    public Link setJavascript(String javascript) {
        this.path = "javascript:void(0);";
        this.onclick = javascript;
        return this;
    }

    public Link setExternalPath(String path) {
        this.path = HtmlUtils.encode(path);
        this.target = "_blank";
        return this;
    }

    public Link setOnclick(String onclick) {
        this.onclick = onclick;
        return this;
    }

    public Link setTitle(String title) {
        this.title = HtmlUtils.encode(title);
        return this;
    }

    public Link setEscapeTitle(String title) {
        this.title = title;
        return this;
    }

    public Link setTitleKey(String contentKey) {
        this.title = Localizer.getText(this.requestContext, contentKey);
        return this;
    }

    public Link setImgSrc(String iconPath) {
        this.imgSrc = iconPath;
        return this;
    }

    public Link setAppImgSrc(String iconPath) {
        this.imgSrc = AppPaths.ROOT + iconPath;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public String getImgSrc() {
        return this.imgSrc;
    }

    public Link setTarget(String target) {
        this.target = target;
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    public Link setStyleClass(String styleClass) {
        this.styleClass = styleClass;
        return this;
    }

    public void setImgAltText(String imageTitle) {
        this.imageTitle = imageTitle;
    }

    public void setImgAltKey(String imageTitleKey) {
        this.imageTitle = Localizer.getText(this.requestContext, imageTitleKey);
    }

    public void setImgSize(int width, int height) {
        this.imgWidth = width;
        this.imgHeight = height;
    }

    public Link setImgStyleClass(String imgStyleClass) {
        this.imgStyleClass = imgStyleClass;
        return this;
    }

    public Link setImgAlignRight() {
        this.imgAlignRight = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Link setName(String name) {
        this.name = name;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Link setId(String id) {
        this.id = id;
        return this;
    }

    public Link setImgId(String imgId) {
        this.imgId = imgId;
        return this;
    }

    public Link setInlineImage(String inlineImage) {
        this.inlineImage = inlineImage;
        return this;
    }
}

