/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.ui;

import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class WidgetUtils {
    public static String formatCreatorInfo(RequestContext requestContext, String creationDate, AccessUser accessUser) {
        String output = "";
        if (!creationDate.isEmpty()) {
            String username = AdminUtils.getSystemUsername(requestContext, accessUser);
            output = Localizer.getText(requestContext, "common.audit.creator", (Object[])new String[]{creationDate, HtmlUtils.encode(username)});
        }
        return output;
    }

    public static List<LabelValueBean> getOnOffOptions(RequestContext requestContext) {
        return Arrays.asList(new LabelValueBean(Localizer.getText(requestContext, "common.boolean.on_off.true"), "true"), new LabelValueBean(Localizer.getText(requestContext, "common.boolean.on_off.false"), "false"));
    }

    public static List<LabelValueBean> getBooleanOptions(RequestContext requestContext) {
        return Arrays.asList(new LabelValueBean(Localizer.getText(requestContext, "common.boolean.true_false.true"), "true"), new LabelValueBean(Localizer.getText(requestContext, "common.boolean.true_false.false"), "false"));
    }

    public static List<LabelValueBean> getYesNoOptions(RequestContext requestContext) {
        return Arrays.asList(new LabelValueBean(Localizer.getText(requestContext, "common.boolean.yes_no.true"), "1"), new LabelValueBean(Localizer.getText(requestContext, "common.boolean.yes_no.false"), "0"));
    }

    public static List<LabelValueBean> getLocaleOptions(RequestContext requestContext) {
        ArrayList<LabelValueBean> localeOptions = new ArrayList<LabelValueBean>();
        for (String localeString : ConfigManager.system.getLocaleOptions()) {
            String[] strings = localeString.split("_");
            Locale locale = new Locale(strings[0], strings[1]);
            String label = Localizer.getText(requestContext, "admin.config.locale." + localeString);
            if (!locale.equals(requestContext.getLocale())) {
                label = label + " - " + Localizer.getText(locale, "admin.config.locale." + localeString);
            }
            localeOptions.add(new LabelValueBean(label, localeString));
        }
        return localeOptions;
    }
}

