/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CurrencyUtils {
    private static final Logger LOGGER = Logger.getLogger(CurrencyUtils.class.getName());
    private static DecimalFormatSymbols decimalFormatSymbols;

    public static String formatCurrency(double input, String currencySymbol) {
        if (input == 0.0) {
            return "";
        }
        DecimalFormat currency = new DecimalFormat(currencySymbol + "###,###.00", decimalFormatSymbols);
        return currency.format(input);
    }

    public static String formatCurrency(Object input, String currencySymbol) {
        if (input == null) {
            return "";
        }
        try {
            return CurrencyUtils.formatCurrency(Double.parseDouble((String)input), currencySymbol);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Problem formatting currency " + input, e);
            return currencySymbol + String.valueOf(input);
        }
    }

    public static void testFormatCurrency(String[] args) {
        System.out.println(Locale.getDefault());
        System.out.println(CurrencyUtils.formatCurrency("a", "$"));
        System.out.println(CurrencyUtils.formatCurrency("0", "$"));
        System.out.println(CurrencyUtils.formatCurrency("0.1", "$"));
        System.out.println(CurrencyUtils.formatCurrency("1", "$"));
        System.out.println(CurrencyUtils.formatCurrency("2649", "$"));
        System.out.println(CurrencyUtils.formatCurrency(264.0, ""));
        System.out.println(CurrencyUtils.formatCurrency(1000.0, "$"));
        System.out.println(CurrencyUtils.formatCurrency("1000", "$"));
        System.out.println(CurrencyUtils.formatCurrency("1000000000000", "$"));
    }

    public static boolean isValidFormat(String input) {
        if (input != null && !input.isEmpty()) {
            try {
                Double.parseDouble(input);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    static {
        Locale defaultLocale = new Locale("en", "US");
        decimalFormatSymbols = new DecimalFormatSymbols(defaultLocale);
    }
}

