/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.util;

import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.parsers.wiki.TextParser;
import com.kwoksys.framework.util.CurrencyUtils;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.HtmlUtils;
import com.kwoksys.framework.util.StringUtils;
import java.util.List;

public class CustomFieldFormatter {
    private RequestContext requestContext;
    private Attribute attr;
    private Object fieldValue;
    private boolean editPage = false;

    public CustomFieldFormatter(RequestContext requestContext, Attribute attr, Object fieldValue) {
        this.requestContext = requestContext;
        this.attr = attr;
        this.fieldValue = fieldValue;
    }

    public String getAttributeValue() {
        if (this.editPage) {
            return this.getAttributeTextValue();
        }
        return this.getAttributeHtmlValue();
    }

    public String getAttributeHtmlValue() {
        if (this.attr.getType().equals(Attribute.ATTR_TYPE_DATE)) {
            try {
                this.fieldValue = DatetimeUtils.toShortDate(Long.valueOf((String)this.fieldValue));
            }
            catch (Exception exception) {}
        } else if (this.attr.getType().equals(Attribute.ATTR_TYPE_MULTISELECT)) {
            if (this.fieldValue instanceof List) {
                List<String> values = HtmlUtils.encode((List)this.fieldValue);
                this.fieldValue = StringUtils.join(values, "<br>");
            }
        } else if (this.attr.getType().equals(Attribute.ATTR_TYPE_CURRENCY)) {
            this.fieldValue = CurrencyUtils.formatCurrency(this.fieldValue, this.attr.getTypeCurrencySymbol());
        } else {
            TextParser textParser = new TextParser();
            textParser.setOption("encodehtml", "true");
            if (this.attr.getType().equals(Attribute.ATTR_TYPE_MULTILINE)) {
                textParser.setOption("replacelinebreak", "true");
            }
            if (this.attr.isConvertUrl()) {
                textParser.setOption("converturls", "true");
            }
            this.fieldValue = textParser.parseHtml(this.requestContext, (String)this.fieldValue);
        }
        return (String)this.fieldValue;
    }

    public String getAttributeTextValue() {
        if (this.attr.getType().equals(Attribute.ATTR_TYPE_DATE)) {
            try {
                this.fieldValue = DatetimeUtils.toShortDate(Long.valueOf((String)this.fieldValue));
            }
            catch (Exception exception) {}
        } else if (this.attr.getType().equals(Attribute.ATTR_TYPE_MULTISELECT)) {
            this.fieldValue = StringUtils.join((List)this.fieldValue, "\n");
        } else if (this.attr.getType().equals(Attribute.ATTR_TYPE_CURRENCY) && !this.editPage) {
            this.fieldValue = CurrencyUtils.formatCurrency(this.fieldValue, this.attr.getTypeCurrencySymbol());
        }
        return (String)this.fieldValue;
    }

    public String getAttributeRawValue() {
        if (this.attr.getType().equals(Attribute.ATTR_TYPE_DATE)) {
            try {
                this.fieldValue = String.valueOf(DatetimeUtils.parseDate((String)this.fieldValue, ConfigManager.system.getDateFormat()).getTime());
            }
            catch (Exception exception) {}
        } else if (this.attr.getType().equals(Attribute.ATTR_TYPE_CURRENCY)) {
            this.fieldValue = ((String)this.fieldValue).replace(",", "");
        }
        return (String)this.fieldValue;
    }

    public boolean isEditPage() {
        return this.editPage;
    }

    public void setEditPage(boolean editPage) {
        this.editPage = editPage;
    }
}

