/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.util;

import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.http.RequestContext;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DatetimeUtils {
    public static final long ONE_DAY_MILLISECONDS = 86400000L;
    public static final long ONE_HOUR_MILLISECONDS = 3600000L;
    public static final long ONE_MINUTE_MILLISECONDS = 60000L;
    public static final long ONE_SECOND_MILLISECONDS = 1000L;

    public static Calendar newCalendar() {
        return new GregorianCalendar(ConfigManager.system.getTimezoneBase());
    }

    public static Calendar newLocalCalendar(RequestContext requestContext) {
        GregorianCalendar calendar = new GregorianCalendar(ConfigManager.system.getTimezoneLocal());
        calendar.setTimeInMillis(requestContext.getSysdate().getTime() + (long)DatetimeUtils.getTimeOffsetMs(requestContext.getSysdate()));
        return calendar;
    }

    public static Date newDate(long milliseconds) {
        GregorianCalendar calendar = new GregorianCalendar(ConfigManager.system.getTimezoneBase());
        calendar.setTimeInMillis(milliseconds);
        return calendar.getTime();
    }

    public static String createDatetimeString(String year, String month, String date) {
        if (year.isEmpty() || month.isEmpty() || date.isEmpty()) {
            return "";
        }
        return year + "-" + month + "-" + date + " 00:00:00";
    }

    public static Date getDate(ResultSet rs, String column) throws SQLException {
        return rs.getTimestamp(column, DatetimeUtils.newCalendar());
    }

    public static String toLocalDate(Date date) {
        return DatetimeUtils.toLocalString(date, ConfigManager.system.getDateFormat());
    }

    public static String toLocalDatetime(Date date) {
        return DatetimeUtils.toLocalString(date, ConfigManager.system.getDateFormat() + " " + ConfigManager.system.getTimeFormat());
    }

    public static String toLocalDatetime(long milliseconds) {
        return DatetimeUtils.toLocalString(DatetimeUtils.newDate(milliseconds), ConfigManager.system.getDateFormat() + " " + ConfigManager.system.getTimeFormat());
    }

    public static String toShortDate(Date date) {
        return DatetimeUtils.toString(date, ConfigManager.system.getDateFormat());
    }

    public static String toShortDate(long milliseconds) {
        return DatetimeUtils.toString(DatetimeUtils.newDate(milliseconds), ConfigManager.system.getDateFormat());
    }

    public static String toYearString(Date date) {
        return DatetimeUtils.toString(date, "yyyy");
    }

    public static String toMonthString(Date date) {
        return DatetimeUtils.toString(date, "MM");
    }

    public static String toDateString(Date date) {
        return DatetimeUtils.toString(date, "dd");
    }

    private static String formatDate(Date date, String pattern, TimeZone timezone) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setTimeZone(timezone);
        return dateFormat.format(date);
    }

    private static String toLocalString(Date date, String pattern) {
        return DatetimeUtils.formatDate(date, pattern, ConfigManager.system.getTimezoneLocal());
    }

    private static String toString(Date date, String pattern) {
        return DatetimeUtils.formatDate(date, pattern, ConfigManager.system.getTimezoneBase());
    }

    public static Date parseDate(String datetime, String pattern) throws Exception {
        if (datetime == null || datetime.isEmpty()) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(ConfigManager.system.getTimezoneBase());
        return dateFormat.parse(datetime);
    }

    public static boolean isValidDate(String year, String month, String date) {
        try {
            Calendar gc = DatetimeUtils.newCalendar();
            gc.setLenient(false);
            gc.set(1, Integer.parseInt(year));
            gc.set(2, Integer.parseInt(month) - 1);
            gc.set(5, Integer.parseInt(date));
            gc.getTime();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidDateString(String fieldValue) {
        try {
            DatetimeUtils.parseDate(fieldValue, ConfigManager.system.getDateFormat());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getTimeOffsetMs(Date currentDate) {
        int offset = ConfigManager.system.getTimezoneLocal().getRawOffset();
        if (ConfigManager.system.getTimezoneLocal().inDaylightTime(currentDate)) {
            offset += ConfigManager.system.getTimezoneLocal().getDSTSavings();
        }
        return offset;
    }

    public static double getTimeOffsetHours(Date currentDate) {
        double offsetMs = DatetimeUtils.getTimeOffsetMs(currentDate);
        return offsetMs / 3600000.0;
    }
}

