/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.util;

import com.kwoksys.biz.system.core.Image;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.StringUtils;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;

public class HtmlUtils {
    public static String formatExternalLink(RequestContext requestContext, String url) {
        if (!StringUtils.isEmpty(url)) {
            return new Link(requestContext).setExternalPath(url).setTitle(url).setInlineImage(Image.getInstance().getExternalPopupIcon(requestContext)).setImgAlignRight().getString();
        }
        return "";
    }

    public static String encode(String input) {
        if (StringUtils.isEmpty(input)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    int cp = input.codePointAt(i);
                    if (cp > 32 && cp < 48 || cp > 57 && cp < 65 || cp > 90 && cp < 97 || cp > 122 && cp < 127) {
                        sb.append("&#").append(cp).append(";");
                        continue block6;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static StringBuffer encode(StringBuffer input) {
        if (input == null) {
            return new StringBuffer();
        }
        if (input.length() == 0) {
            return input;
        }
        StringBuffer sb = new StringBuffer();
        block6: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb;
    }

    public static String decodeHtml4(String input) {
        return StringEscapeUtils.unescapeHtml4((String)input);
    }

    public static String formatMailtoLink(String emailAddress) {
        if (emailAddress == null || emailAddress.isEmpty()) {
            return "";
        }
        return new Link(null).setExternalPath("mailto:" + HtmlUtils.encode(emailAddress)).setTitle(emailAddress).getString();
    }

    public static List<String> encode(List<String> values) {
        for (int i = 0; i < values.size(); ++i) {
            values.set(i, HtmlUtils.encode(values.get(i)));
        }
        return values;
    }

    public static String formatMultiLineDisplay(String input) {
        return input == null ? "" : HtmlUtils.encode(input).replace("\n", "<br>");
    }

    public static String removeHtmlTags(String input) {
        return input == null ? "" : input.replace("\n", "").replaceAll("\\<script.*?\\</script\\>", "").replaceAll("\\<.*?\\>", "");
    }

    public static void main(String[] args) {
        String test = "This is a \"Test\" @ # & <b>";
        System.out.println(test);
        String encodedTest = HtmlUtils.encode(test);
        System.out.println(encodedTest);
        System.out.println(HtmlUtils.decodeHtml4(encodedTest));
        StringBuffer testBuffer = new StringBuffer(test);
        System.out.println(HtmlUtils.encode(testBuffer));
    }
}

