/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.util;

import com.kwoksys.framework.connections.CustomSslSocketFactory;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class HttpHelper {
    private static final Logger LOGGER = Logger.getLogger(HttpHelper.class.getName());
    private boolean printResponse;
    private String proxyServerAddress;
    private Integer proxyServerPort;

    public String getContent(String url) throws Exception {
        HttpGet httpget = new HttpGet(url);
        return this.httpExecute((HttpUriRequestBase)httpget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpExecute(HttpUriRequestBase requestBase) throws Exception {
        CloseableHttpClient httpclient = HttpHelper.createAcceptSelfSignedCertificateClient().build();
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(5L, TimeUnit.SECONDS);
        if (this.proxyServerAddress != null && this.proxyServerPort != null) {
            builder.setProxy(new HttpHost(this.proxyServerAddress, this.proxyServerPort.intValue()));
        }
        RequestConfig requestConfig = builder.build();
        HttpClientContext context = HttpClientContext.create();
        LOGGER.log(Level.INFO, "Connecting to " + requestBase.getRequestUri() + ", proxy address: " + this.proxyServerAddress + ", proxy port: " + this.proxyServerPort);
        requestBase.setConfig(requestConfig);
        try (CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)requestBase, (HttpContext)context);){
            int statusCode = response.getCode();
            if (statusCode != 200) {
                throw new Exception("HTTP method error: " + response.getReasonPhrase());
            }
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
    }

    public static HttpClientBuilder createAcceptSelfSignedCertificateClient() throws Exception {
        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
        NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
        SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts);
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMinutes((long)1L)).build()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(Timeout.ofMinutes((long)1L)).setConnectTimeout(Timeout.ofMinutes((long)1L)).setTimeToLive(TimeValue.ofMinutes((long)10L)).build()).build();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager);
    }

    public static void setNoCacheResponseHeaders(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
    }

    public static void setDownloadResponseHeaders(HttpServletResponse response, String fileName) {
        HttpHelper.setNoCacheResponseHeaders(response);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
    }

    public static void setFilenameResponseHeaders(HttpServletResponse response, String fileName) {
        HttpHelper.setNoCacheResponseHeaders(response);
        response.setHeader("Content-Disposition", "filename=\"" + fileName + "\"");
    }

    public static List<String> getListeningPorts() {
        ArrayList<String> endPoints = new ArrayList<String>();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            Set<ObjectName> objs = mbs.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("*")));
            for (ObjectName obj : objs) {
                String scheme = mbs.getAttribute(obj, "scheme").toString();
                String protocol = mbs.getAttribute(obj, "protocol").toString();
                String port = obj.getKeyProperty("port");
                String ep = "[" + protocol + ": " + scheme + " " + port + "]";
                endPoints.add(ep);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return endPoints;
    }

    public void get(String endpoint) throws Exception {
        URL url = new URL(endpoint);
        HttpsURLConnection.setDefaultSSLSocketFactory(new CustomSslSocketFactory());
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
        Map<String, List<String>> map = conn.getHeaderFields();
        if (!this.printResponse) {
            return;
        }
        LOGGER.log(Level.INFO, "Request URL: " + endpoint);
        StringBuilder response = new StringBuilder();
        response.append("Resonse content:\n");
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (entry.getKey() != null) {
                response.append(entry.getKey() + ": ");
            }
            for (String string : entry.getValue()) {
                response.append(string + "\n");
            }
            if (!"Content-Encoding".equals(entry.getKey())) continue;
        }
        LOGGER.log(Level.INFO, response.toString());
        HttpHelper.printContents(conn);
    }

    private static void printContents(URLConnection conn) throws Exception {
        String result = HttpHelper.convertInputstream(conn.getInputStream());
        LOGGER.log(Level.INFO, result);
    }

    public HttpHelper setPrintResponse(boolean printResponse) {
        this.printResponse = printResponse;
        return this;
    }

    private static String convertInputstream(InputStream inputStream) throws Exception {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            sb.append(line);
        }
        rd.close();
        return sb.toString();
    }

    public String getProxyServerAddress() {
        return this.proxyServerAddress;
    }

    public void setProxyServerAddress(String proxyServerAddress) {
        this.proxyServerAddress = proxyServerAddress;
    }

    public Integer getProxyServerPort() {
        return this.proxyServerPort;
    }

    public void setProxyServerPort(Integer proxyServerPort) {
        this.proxyServerPort = proxyServerPort;
    }
}

