/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.util;

public class NumberUtils {
    public static boolean isInteger(String temp) {
        try {
            Integer.parseInt(temp);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isNonNegativeInteger(String temp) {
        return NumberUtils.isInteger(temp) && Integer.parseInt(temp) >= 0;
    }

    public static Integer replaceNull(String temp, Integer defaultValue) {
        if (temp == null || temp.isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(temp);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Integer replaceNull(Object temp) {
        return NumberUtils.replaceNull(String.valueOf(temp), 0);
    }

    public static Integer replaceNull(String temp) {
        return NumberUtils.replaceNull(temp, 0);
    }

    public static double setDefaultDouble(Object temp, double defaultValue) {
        if (temp == null || temp.equals("")) {
            return defaultValue;
        }
        return Double.parseDouble(String.valueOf(temp));
    }

    public static double setDefaultDouble(Object temp) {
        return NumberUtils.setDefaultDouble(temp, 0.0);
    }
}

