/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.BCodec;

public class StringUtils {
    private static final Logger LOGGER = Logger.getLogger(StringUtils.class.getName());

    public static String replaceNull(Object temp, String defaultValue) {
        if (temp == null || temp.toString().trim().isEmpty()) {
            return defaultValue;
        }
        return temp.toString().trim();
    }

    public static String replaceNull(Object temp) {
        return StringUtils.replaceNull(temp, "");
    }

    public static String encodeVCard(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        return input;
    }

    public static String encodeMatcherReplacement(String input) {
        return Matcher.quoteReplacement(input);
    }

    public static String encodeJavascript(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\").replace("'", "\\x27").replace("\"", "\\x22");
    }

    public static String encodeCkeditorJs(String input) {
        if (input == null) {
            return "";
        }
        return input;
    }

    public static String encodeBase64Codec(String input) {
        BCodec codec = new BCodec();
        try {
            return codec.encode(input);
        }
        catch (EncoderException e) {
            LOGGER.warning("Problem with base64 encoding.");
            return "";
        }
    }

    public static String decodeBase64Codec(String input) {
        if (input.isEmpty()) {
            return "";
        }
        BCodec codec = new BCodec();
        try {
            return codec.decode(input);
        }
        catch (DecoderException e) {
            LOGGER.warning("Problem with base64 decoding.");
            return "";
        }
    }

    public static String decodeBase64(String input) {
        return new String(Base64.decodeBase64((byte[])input.getBytes()));
    }

    public static String join(String[] strings, String token) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean appendToken = false;
        for (String string : strings) {
            if (string.isEmpty()) continue;
            if (appendToken) {
                sb.append(token);
            }
            sb.append(string);
            appendToken = true;
        }
        return sb.toString();
    }

    public static String join(Collection<String> strings, String token) {
        if (strings == null || strings.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean appendToken = false;
        for (String string : strings) {
            if (string.isEmpty()) continue;
            if (appendToken) {
                sb.append(token);
            }
            sb.append(string);
            appendToken = true;
        }
        return sb.toString();
    }

    public static String joinIntegers(List<Integer> integers, String token) {
        if (integers == null || integers.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        boolean appendToken = false;
        for (Integer integer : integers) {
            if (appendToken) {
                buffer.append(token);
            }
            buffer.append(integer);
            appendToken = true;
        }
        return buffer.toString();
    }

    public static String join(List<Map<String, String>> maps, String key, String token) {
        StringBuilder buffer = new StringBuilder();
        boolean appendToken = false;
        for (Map<String, String> map : maps) {
            if (map.isEmpty()) continue;
            if (appendToken) {
                buffer.append(token);
            }
            buffer.append(map.get(key));
            appendToken = true;
        }
        return buffer.toString();
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static String capitalizeFirstLetter(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        return value.substring(0, 1).toUpperCase() + value.substring(1, value.length());
    }
}

