/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.util;

import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.util.StringUtils;
import com.kwoksys.test.cases.KwokTestCase;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtilsTest
extends KwokTestCase {
    public StringUtilsTest(RequestContext requestContext) {
        super(requestContext);
    }

    public static void main(String[] args) throws Exception {
        new StringUtilsTest(null).execute();
    }

    public void execute() throws Exception {
        this.testJoin();
    }

    public void testJoin() {
        String expectedString = "a1, b1, c1";
        List<String> strings = Arrays.asList("a1", "b1", "", "c1");
        String joinedString = StringUtils.join(strings, ", ");
        this.addResult("Result... " + joinedString, expectedString.equals(joinedString));
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("a1");
        set.add("b1");
        set.add("");
        set.add("c1");
        joinedString = StringUtils.join(set, ", ");
        this.addResult("Result... " + joinedString, expectedString.equals(joinedString));
    }

    public void test() {
        String httpRegex = "(?<!\")((http|https)://[^\\s]+)(?!\")";
        String string = "URL conversion testLowercase: http://example.com \nLowercase with punctuation: http://example.com. \nURL parameters: http://example.com?a=1 \nURL parameters: http://example.com?a=1, \nAlready a link: <a href=\"http://example.com\">example</a> \nUpper case https: Https://example.com \n";
        Pattern p = Pattern.compile(httpRegex, 2);
        Matcher m = p.matcher(string);
        if (m.find()) {
            string = m.replaceAll("<a href=\"$1\">$1</a>");
        }
        System.out.println(string);
    }
}

