/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.validations;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BrowserValidator {
    private static final Logger LOGGER = Logger.getLogger(BrowserValidator.class.getName());
    private static final Pattern TRIDEN_PATTERN = Pattern.compile(".*Trident/(.*?)\\.");
    private static final Pattern MSIE_PATTERN = Pattern.compile(".*MSIE (.*?)\\.");
    private static final Pattern FIREFOX_PATTERN = Pattern.compile(".*Firefox/(.*?)\\.");
    private static final Pattern CHROME_PATTERN = Pattern.compile(".*Chrome/(.*?)\\.");
    private static final String TRIDENT = "TRIDENT";
    private static final String MSIE = "MSIE";
    private static final String CHROME = "CHROME";
    private static final String FIREFOX = "FIREFOX";
    public static Map<String, Integer> minimumVersions = new HashMap<String, Integer>();

    public static boolean isSupportedBrowser(String userAgent) {
        if (userAgent == null) {
            return true;
        }
        try {
            Matcher m;
            if (userAgent.contains("Trident/") || userAgent.contains("MSIE ")) {
                Double msieVersion;
                Double tridentVersion;
                Matcher m2 = TRIDEN_PATTERN.matcher(userAgent);
                if (m2.find() && (tridentVersion = Double.valueOf(m2.group(1))) >= (double)minimumVersions.get(TRIDENT).intValue()) {
                    return true;
                }
                m2 = MSIE_PATTERN.matcher(userAgent);
                return m2.find() && (msieVersion = Double.valueOf(m2.group(1))) >= (double)minimumVersions.get(MSIE).intValue();
            }
            String browser = null;
            Double version = null;
            if (userAgent.contains("Firefox/")) {
                Matcher m3 = FIREFOX_PATTERN.matcher(userAgent);
                if (m3.find()) {
                    browser = FIREFOX;
                    version = Double.valueOf(m3.group(1));
                }
            } else if (userAgent.contains("Chrome/") && (m = CHROME_PATTERN.matcher(userAgent)).find()) {
                browser = CHROME;
                version = Double.valueOf(m.group(1));
            }
            if (version != null && version < (double)minimumVersions.get(browser).intValue()) {
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Problem parsing user-agent header: " + userAgent, e);
        }
        return true;
    }

    static {
        minimumVersions.put(TRIDENT, 6);
        minimumVersions.put(MSIE, 10);
        minimumVersions.put(CHROME, 30);
        minimumVersions.put(FIREFOX, 30);
    }
}

