/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.validations;

import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.validations.BrowserValidator;
import com.kwoksys.test.cases.KwokTestCase;

public class BrowserValidatorTest
extends KwokTestCase {
    public BrowserValidatorTest(RequestContext requestContext) {
        super(requestContext);
    }

    public static void main(String[] args) throws Exception {
        new BrowserValidatorTest(null).execute();
    }

    public void execute() throws Exception {
        String userAgent;
        this.addResult(userAgent, BrowserValidator.isSupportedBrowser(userAgent = "Edge/14.14393"));
        userAgent = "Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; AS; rv:11.0) like Gecko";
        this.addResult(userAgent, BrowserValidator.isSupportedBrowser(userAgent));
        userAgent = "Mozilla/5.0 (compatible; MSIE 10.6; Windows NT 6.1; Trident/5.0; InfoPath.2; SLCC1)";
        this.addResult(userAgent, BrowserValidator.isSupportedBrowser(userAgent));
        userAgent = "Mozilla/4.0 (Compatible; MSIE 8.0; Windows NT 5.2; Trident/6.0)";
        this.addResult(userAgent, BrowserValidator.isSupportedBrowser(userAgent));
        userAgent = "Mozilla/4.0 (compatible; MSIE 10.0; Windows NT 6.1; Trident/5.0)";
        this.addResult(userAgent, BrowserValidator.isSupportedBrowser(userAgent));
        userAgent = "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)";
        this.addResult(userAgent, !BrowserValidator.isSupportedBrowser(userAgent));
        userAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)";
        this.addResult(userAgent, !BrowserValidator.isSupportedBrowser(userAgent));
        userAgent = "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:40.0) Gecko/20100101 Firefox/40.0";
        this.addResult(userAgent, BrowserValidator.isSupportedBrowser(userAgent));
        userAgent = "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36";
        this.addResult(userAgent, BrowserValidator.isSupportedBrowser(userAgent));
    }
}

