/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.framework.validations;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeValue;
import com.kwoksys.biz.base.BaseObject;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Schema;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.CurrencyUtils;
import com.kwoksys.framework.util.CustomFieldFormatter;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import com.kwoksys.framework.validations.ColumnField;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.MaskFormatter;

public class InputValidator {
    private RequestContext requestContext;
    private ActionMessages errors;

    public InputValidator(RequestContext requestContext, ActionMessages errors) {
        this.requestContext = requestContext;
        this.errors = errors;
    }

    public void validate(ColumnField columnField) {
        if (!columnField.isNullable() && columnField.getLength() == 0) {
            this.errors.add(columnField.getName(), new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, columnField.getTitleKey())));
        }
        if (columnField.getColumnName() != null) {
            int maxLength = Schema.getColumnLength(columnField.getColumnName());
            if (columnField.getLength() > maxLength) {
                this.errors.add(columnField.getName(), new ActionMessage("common.form.fieldExceededMaxLen", new String[]{Localizer.getText(this.requestContext, columnField.getTitleKey()), String.valueOf(maxLength)}));
            }
        }
    }

    public void validateAttrs(BaseObject baseObject, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        this.validateAttrs(baseObject, null, customAttributes);
    }

    public void validateAttrs(BaseObject baseObject, Integer objectAttrTypeId, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        for (Attribute attr : new AttributeManager(this.requestContext).getSystemAttributes(baseObject).values()) {
            if (!attr.isRequired() || !baseObject.isAttrEmpty(attr.getName())) continue;
            this.errors.add(attr.getCamelCaseName(), new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column." + attr.getName())));
        }
        if (customAttributes != null && !customAttributes.isEmpty()) {
            AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
            List<Integer> mappedAttrIds = null;
            if (objectAttrTypeId != null) {
                mappedAttrIds = adminService.getSavedAttributeFieldTypes(objectAttrTypeId);
            }
            for (Attribute attr : customAttributes.values()) {
                AttributeValue attrValue = baseObject.getCustomValues().get(attr.getId());
                String formFieldId = "attrId" + attr.getId();
                if (attrValue == null || attrValue.getAttributeValue().isEmpty()) {
                    if (!attr.isRequired() || mappedAttrIds != null && !mappedAttrIds.contains(attr.getId())) continue;
                    this.errors.add(formFieldId, new ActionMessage("common.form.fieldRequired", attr.getName()));
                    continue;
                }
                if (attr.getType().equals(Attribute.ATTR_TYPE_DATE)) {
                    if (!DatetimeUtils.isValidDateString(attrValue.getAttributeValue())) {
                        this.errors.add(formFieldId, new ActionMessage("common.form.fieldDateInvalid", attr.getName()));
                        continue;
                    }
                    attrValue.setRawValue(new CustomFieldFormatter(this.requestContext, attr, attrValue.getAttributeValue()).getAttributeRawValue());
                    continue;
                }
                if (attr.getType().equals(Attribute.ATTR_TYPE_CURRENCY)) {
                    attrValue.setRawValue(new CustomFieldFormatter(this.requestContext, attr, attrValue.getAttributeValue()).getAttributeRawValue());
                    if (CurrencyUtils.isValidFormat(attrValue.getRawValue())) continue;
                    this.errors.add(formFieldId, new ActionMessage("common.form.fieldFormatError", attr.getName()));
                    continue;
                }
                if (attr.getInputMask().isEmpty() || attrValue.getAttributeValue().isEmpty()) continue;
                try {
                    MaskFormatter formatter = new MaskFormatter(attr.getInputMask());
                    formatter.stringToValue(attrValue.getAttributeValue());
                    attrValue.setRawValue(formatter.valueToString(attrValue.getAttributeValue()));
                }
                catch (Exception e) {
                    this.errors.add(formFieldId, new ActionMessage("common.form.fieldFormatError", attr.getName(), attr.getDescription()));
                }
            }
        }
    }

    public void validatePassword(String passwordMessageKey, AccessUser accessUser) {
        if (accessUser.getPasswordNew() != null && accessUser.getPasswordConfirm() != null && !accessUser.getPasswordNew().equals(accessUser.getPasswordConfirm())) {
            this.errors.add("password", new ActionMessage("admin.userEdit.error.passwordMismatch"));
        } else if (accessUser.isAccountEnabled()) {
            if (StringUtils.isEmpty(accessUser.getPasswordNew())) {
                if (!ConfigManager.admin.isAllowBlankUserPassword()) {
                    this.errors.add("password", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, passwordMessageKey)));
                }
            } else if (accessUser.getPasswordNew().length() < ConfigManager.auth.getSecurityMinPasswordLength()) {
                this.errors.add("password", new ActionMessage("admin.userEdit.error.passwordMinLen", ConfigManager.auth.getSecurityMinPasswordLength()));
            } else if (!InputValidator.validatePasswordComplexity(accessUser)) {
                this.errors.add("password", new ActionMessage("admin.config.security.passwordComplexity.desc"));
            }
        }
    }

    private static boolean validatePasswordComplexity(AccessUser accessUser) {
        String newPassword = accessUser.getPasswordNew();
        if (!ConfigManager.admin.isSecurityPasswordComplexityEnabled()) {
            return true;
        }
        if (newPassword.toLowerCase().contains(accessUser.getFirstName().toLowerCase())) {
            return false;
        }
        if (newPassword.toLowerCase().contains(accessUser.getLastName().toLowerCase())) {
            return false;
        }
        List<String> requirements = Arrays.asList("([a-z])", "([A-Z])", "([0-9])", "([\\p{Punct}])");
        int found = 0;
        for (String regex : requirements) {
            Matcher m = Pattern.compile(regex).matcher(newPassword);
            if (!m.find()) continue;
            ++found;
        }
        return found >= 3;
    }
}

