class Kis {
    append(input, targetElem) {
        if (Kis.isFunction(input)) {
            for (var i in this.items) {
                var item = this.items[i];
                targetElem.insertAdjacentHTML('beforeend', input(item));
            }
        } else {
            return Kis.append(input, targetElem);
        }
    }
    
    join(callbackFn) {
        return this.items.map(callbackFn).join('');
    }
    
    do(callbackFn) {
        for (var i in this.items) {
            var item = this.items[i];
            callbackFn(item, i);
        }
    }

	fadeOut(elem) {
		Kis.show(elem);

		var delay = this.delayMs == null ? 3000 : this.delayMs;
		
        var animationDurationMs = 3000;
        
        elem.style['animation-name'] = 'kis-animation-fadeout';
        elem.style['animation-delay'] = delay + 'ms';
        elem.style['animation-duration'] = animationDurationMs + 'ms';

        // Set a timeout to hide the element. Timeout should match the animation duration.
        setTimeout(function() {
            elem.style['animation-name'] = null;
            elem.style['animation-delay'] = null;
            elem.style['animation-duration'] = null;
            
            Kis.hide(elem);
        }, delay + animationDurationMs);
	}
}

/*
 * Defines items to be used for looping.
 */
Kis.foreach = function(items) {
    var kis = new Kis();
    kis.items = items;
    return kis;
};

Kis.delay = function(delayMs) {
    var kis = new Kis();
	kis.delayMs = delayMs;
	return kis;
};

/*
 * Makes an element movable.
 * cfg: {
 *     moveElem:
 *     moveElemLeft:
 *     moveElemTop: 
 * }
 */
Kis.movable = function(draggerElem, cfg = {}) {
    console.log('Kis.movable()... ' + (draggerElem.id != null ? draggerElem.id : draggerElem));
    
    Kis.addClass('kis-movable-dragger', draggerElem);
    
    if (cfg.moveElem == null) {
        cfg.moveElem = draggerElem;
    }
    
	var drag = false;
	var mouseStartX = 0;
	var elemStartX = 0;
	var elemEndX = cfg.moveElemLeft != null ? cfg.moveElemLeft : 0;
	
	var mouseStartY = 0;
	var elemStartY = 0;
	var elemEndY = cfg.moveElemTop != null ? cfg.moveElemTop : 0;
	
	var mousemove = function(event) {
		if (drag) {
			var diffX = event.clientX - mouseStartX;
			elemEndX = elemStartX + diffX;
			// console.log('Kis.movable(), x elem start ' + elemStartX + ' mouse start ' + mouseStartX + ', mouse ' + event.clientX + ', diff ' + diffX + ', move to ' + elemEndX + 'px, ' + (draggerElem.id != null ? draggerElem.id : draggerElem));
			cfg.moveElem.style.left = elemEndX + 'px';

			var diffY = event.clientY - mouseStartY;
			elemEndY = elemStartY + diffY;
			// console.log('Kis.movable(), y elem start ' + elemStartY + ' mouse start ' + mouseStartY + ', mouse ' + event.clientY + ', diff ' + diffY + ', move to ' + elemEndY + 'px, ' + (draggerElem.id != null ? draggerElem.id : draggerElem));
			cfg.moveElem.style.top = elemEndY + 'px';
		}
	};
	
	var mouseup = function() {
		drag = false;
		// console.log('Kis.movable(), mouseup');
		document.removeEventListener('mousemove', mousemove);
	};
		
	document.addEventListener('mouseup', mouseup);
		
	draggerElem.onmousedown = function(event) {
		drag = true;
		mouseStartX = event.clientX;
		elemStartX = elemEndX;
		mouseStartY = event.clientY;
		elemStartY = elemEndY;

		document.addEventListener('mousemove', mousemove);
	}
};

Kis.isString = function(input) {
	return typeof input === 'string';
};

Kis.isFunction = function(input) {
	return typeof input === 'function';
};

/*
 * Sets targetElem with inupt using innerHTML for string or Javascript's append() for object.
 */
Kis.render = function(input, targetElem) {
    console.log('Kis.render()... targetElem: ' + (targetElem.id != null ? targetElem.id : targetElem));
    
    if (Kis.isString(input)) {
        targetElem.innerHTML = input;
        
    } else {
        targetElem.innerHTML = '';
        targetElem.append(input);
    } 
}

/*
 * Adds inupt to targetElem using insertAdjacentHTML() for string or Javascript's append() for object.
 */
Kis.append = function(input, targetElem) {
    console.log('Kis.append()... targetElem: ' + (targetElem.id != null ? targetElem.id : targetElem));
	
    if (Kis.isString(input)) {
        targetElem.insertAdjacentHTML('beforeend', input);
        
    } else {
        targetElem.append(input);
    }
}

/*
 * Adds inupt to targetElem using insertAdjacentHTML() for string.
 */
Kis.prepend = function(input, targetElem) {
    if (Kis.isString(input)) {
        targetElem.insertAdjacentHTML('afterbegin', input);

    } else {
        targetElem.prepend(input);
    }
}

/* 
 * Encodes HTML.
 */
Kis.encodeHtml = function(string) {
	var elem = document.createElement('span');
	elem.innerText = string;
    return elem.innerHTML;
}

/* 
 * Encodes form input.
 * var value1 = "This is a 'test'.";
 * var value2 = 'This is a "test".';
 *
 * Usage:
 * <input ... value="${Kis.encodeInput(value1)}">
 * <input ... value='${Kis.encodeInput(value2)}'>
 */
Kis.encodeInput = function(string) {
    if (Kis.isEmpty(string)) {
        return '';
    }
    return string.replace('"', '&quot').replace('\'', '&apos;');
}

/**
 * options: JSON object in {label: <option label>, value: <option value>}.
 * selectElem: Select element to add options to.
 * selectedValue: Value selected.
 */
Kis.addFormOptions = function(options, selectElem, selectedValue) {
    console.log('Kis.addFormOptions() ' + selectedValue);
    
    for (var i in options) {
        var option = options[i];
        
        var selected = (selectedValue != null && selectedValue == option.value);
        
        // Trick: Need to check null value because when submitting <option> without value, label 
        // will be used instead.
        var optionElem = new Option(option.label, option.value != null ? option.value : '',
            selected, selected);
             
        selectElem.add(optionElem);
    }
}

/*
 * Gets browser window width (not including non-viewable area).
 */
Kis.getVisibleWidth = function() {
    return window.innerWidth;
};

/*
 * Gets browser window height (not including non-viewable area).
 */
Kis.getVisibleHeight = function() {
    return window.innerHeight;
};

/*
 * Checks for the given class in the elem, returns true/false.
 */
Kis.hasClass = function(className, elem) {
    return elem.classList.contains(className);
};

/*
 * Adds the given class to elem.
 */
Kis.addClass = function(className, elem) {
    return elem.classList.add(className);
};

/*
 * Removes the given class from elem.
 */
Kis.removeClass = function(className, elem) {
    return elem.classList.remove(className);
};

Kis.toggleClass = function(className, elem) {
    if (Kis.hasClass(className, elem)) {
        Kis.removeClass(className, elem);
    } else {
        Kis.addClass(className, elem);
    }
};

Kis.toggle = function(elem) {
    Kis.toggleClass("kis-display-none", elem);
};

Kis.isHidden = function(elem) {
    return Kis.hasClass('kis-display-none', elem);
};

Kis.hide = function(elem) {
    Kis.addClass('kis-display-none', elem);
};

Kis.hideOptional = function(elem) {
    if (elem != null) {
        Kis.hide(elem);
    }
}

Kis.show = function(elem) {
    Kis.removeClass('kis-display-none', elem);
};

Kis.isEmpty = function(input) {
    return input == null || input.length == 0;
};

Kis.isEmptyString = function(string) {
    return !string || string.replace(/^\s+|\s+$/g,"") == '';
};

Kis.globalEval = function(elem) {
	// Example from https://community.oracle.com/blogs/driscoll/2009/09/08/eval-javascript-global-context
	if (window.execScript) {
		window.execScript(elem.innerHTML);
	} else {
		window.eval.call(window, elem.innerHTML);
	}
}

class KisTest {
    constructor(name, action) {
        this.name = name;
        this.action = action;
    }
}

/*
 * cfg.id:
 * cfg.tasks:
 */
class KisBot {
    constructor(cfg) {
        this.cfg = cfg;
        
        this.consoleElem = document.getElementById(this.cfg.id);
    
        if (this.consoleElem == null) {
            this.consoleElem = document.createElement('div');
            this.consoleElem.setAttribute('id', this.cfg.id);
            Kis.prepend(this.consoleElem, document.getElementsByTagName('body')[0]);
        }
		
		this.numberOfJobs = cfg.tasks.length;
    }

    changeStatus(message) {
        Kis.render(message, this.consoleElem);
        console.log(message);
    }
    
    appendStatus(message) {
        Kis.append(message, this.consoleElem);
        console.log(message);
    }
    
    start() {
        this.changeStatus('Test started');
    
        this.scheduleNextTest();
    }
}
