/*
 * Copyright 2016 Kwoksys
 *
 * http://www.kwoksys.com/LICENSE
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var USER_STATUS_ENABLED = -1;
var URL_PARAM_AJAX = '_ajax';
var CONTENT_ELEM_ID = 'content';
var NOTIFICATION_DELAY = 3000;
var CUSTOM_FIELD_EXPAND_COOKIE = 'customFieldsExpand';

var ATTR_TYPE_STRING = 1;
var ATTR_TYPE_MULTILINE = 2;
var ATTR_TYPE_SELECTBOX = 3;
var ATTR_TYPE_RADIO_BUTTON = 4;
var ATTR_TYPE_DATE = 5;
var ATTR_TYPE_MULTISELECT = 6;
var ATTR_TYPE_CURRENCY = 7;

/* All images should have 24px x 24px set in case CSS doesn't work, images won't be too big. */
var KW_IMAGES = {
    /* Material Design https://material.io/tools/icons/ */
	'admin-g-settings': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 20 20"><path fill="none" d="M0 0h20v20H0V0z"/><path class="defaultPath" d="M15.95 10.78c.03-.25.05-.51.05-.78s-.02-.53-.06-.78l1.69-1.32c.15-.12.19-.34.1-.51l-1.6-2.77c-.1-.18-.31-.24-.49-.18l-1.99.8c-.42-.32-.86-.58-1.35-.78L12 2.34c-.03-.2-.2-.34-.4-.34H8.4c-.2 0-.36.14-.39.34l-.3 2.12c-.49.2-.94.47-1.35.78l-1.99-.8c-.18-.07-.39 0-.49.18l-1.6 2.77c-.1.18-.06.39.1.51l1.69 1.32c-.04.25-.07.52-.07.78s.02.53.06.78L2.37 12.1c-.15.12-.19.34-.1.51l1.6 2.77c.1.18.31.24.49.18l1.99-.8c.42.32.86.58 1.35.78l.3 2.12c.04.2.2.34.4.34h3.2c.2 0 .37-.14.39-.34l.3-2.12c.49-.2.94-.47 1.35-.78l1.99.8c.18.07.39 0 .49-.18l1.6-2.77c.1-.18.06-.39-.1-.51l-1.67-1.32zM10 13c-1.65 0-3-1.35-3-3s1.35-3 3-3 3 1.35 3 3-1.35 3-3 3z"/></svg>',
	'g-account_box': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path class="defaultPath" d="M3 5v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2H5c-1.11 0-2 .9-2 2zm12 4c0 1.66-1.34 3-3 3s-3-1.34-3-3 1.34-3 3-3 3 1.34 3 3zm-9 8c0-2 4-3.1 6-3.1s6 1.1 6 3.1v1H6v-1z"/><path d="M0 0h24v24H0z" fill="none"/></svg>',
	'g-apps': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="none" d="M0 0h24v24H0V0z"/><path class="defaultPath" d="M4 8h4V4H4v4zm6 12h4v-4h-4v4zm-6 0h4v-4H4v4zm0-6h4v-4H4v4zm6 0h4v-4h-4v4zm6-10v4h4V4h-4zm-6 4h4V4h-4v4zm6 6h4v-4h-4v4zm0 6h4v-4h-4v4z"/></svg>',
	'g-business': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M0 0h24v24H0z" fill="none"/><path class="defaultPath" d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z"/></svg>',
	'g-cancel': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path class="defaultPath" d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z"/><path d="M0 0h24v24H0z" fill="none"/></svg>',
	'g-chat': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path class="defaultPath" d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM6 9h12v2H6V9zm8 5H6v-2h8v2zm4-6H6V6h12v2z"/><path d="M0 0h24v24H0z" fill="none"/></svg>',
	'g-check_circle': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M0 0h24v24H0z" fill="none"/><path class="defaultPath" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>',
	'g-close': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path class="defaultPath" d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/><path d="M0 0h24v24H0z" fill="none"/></svg>',	
	'g-delete': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path class="defaultPath" d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"/><path d="M0 0h24v24H0z" fill="none"/></svg>',
	'g-delete_outline': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path class="defaultPath" d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM8 9h8v10H8V9zm7.5-5l-1-1h-5l-1 1H5v2h14V4z"/><path fill="none" d="M0 0h24v24H0V0z"/></svg>',
	'g-edit': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path class="defaultPath" d="M 3 17.25 V 21 h 3.75 L 17.81 9.94 l -3.75 -3.75 L 3 17.25 Z M 20.71 7.04 c 0.39 -0.39 0.39 -1.02 0 -1.41 l -2.34 -2.34 c -0.39 -0.39 -1.02 -0.39 -1.41 0 l -1.83 1.83 l 3.75 3.75 l 1.83 -1.83 Z" /><path fill="none" d="M 0 0 h 24 v 24 H 0 Z" /></svg>',
	'g-email': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path class="defaultPath" d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/><path d="M0 0h24v24H0z" fill="none"/></svg>',
	'g-error': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M0 0h24v24H0z" fill="none"/><path class="defaultPath" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/></svg>',
	'g-exit_to_app': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M0 0h24v24H0z" fill="none"/><path class="defaultPath" d="M10.09 15.59L11.5 17l5-5-5-5-1.41 1.41L12.67 11H3v2h9.67l-2.58 2.59zM19 3H5c-1.11 0-2 .9-2 2v4h2V5h14v14H5v-4H3v4c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z"/></svg>',
	'g-expand_less': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path class="defaultPath" d="M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14z"/><path d="M0 0h24v24H0z" fill="none"/></svg>',
	'g-expand_more': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path class="defaultPath" d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"/><path d="M0 0h24v24H0z" fill="none"/></svg>',
	'g-help': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M0 0h24v24H0z" fill="none"/><path class="defaultPath" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 17h-2v-2h2v2zm2.07-7.75l-.9.92C13.45 12.9 13 13.5 13 15h-2v-.5c0-1.1.45-2.1 1.17-2.83l1.24-1.26c.37-.36.59-.86.59-1.41 0-1.1-.9-2-2-2s-2 .9-2 2H8c0-2.21 1.79-4 4-4s4 1.79 4 4c0 .88-.36 1.68-.93 2.25z"/></svg>',
	'g-info': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M0 0h24v24H0z" fill="none"/><path class="defaultPath" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z"/></svg>',
	'g-note_add': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M0 0h24v24H0z" fill="none"/><path class="defaultPath" d="M14 2H6c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6zm2 14h-3v3h-2v-3H8v-2h3v-3h2v3h3v2zm-3-7V3.5L18.5 9H13z"/></svg>',
	'g-open_in_new': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="none" d="M 0 0 h 24 v 24 H 0 Z" /><path class="defaultPath" d="M 19 19 H 5 V 5 h 7 V 3 H 5 c -1.11 0 -2 0.9 -2 2 v 14 c 0 1.1 0.89 2 2 2 h 14 c 1.1 0 2 -0.9 2 -2 v -7 h -2 v 7 Z M 14 3 v 2 h 3.59 l -9.83 9.83 l 1.41 1.41 L 19 6.41 V 10 h 2 V 3 h -7 Z" /></svg>',
	'g-phone': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M0 0h24v24H0z" fill="none"/><path class="defaultPath" d="M6.62 10.79c1.44 2.83 3.76 5.14 6.59 6.59l2.2-2.2c.27-.27.67-.36 1.02-.24 1.12.37 2.33.57 3.57.57.55 0 1 .45 1 1V20c0 .55-.45 1-1 1-9.39 0-17-7.61-17-17 0-.55.45-1 1-1h3.5c.55 0 1 .45 1 1 0 1.25.2 2.45.57 3.57.11.35.03.74-.25 1.02l-2.2 2.2z"/></svg>',
	'g-print': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path class="defaultPath" d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z"/><path d="M0 0h24v24H0z" fill="none"/></svg>',
	'g-search': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path class="defaultPath" d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"/><path d="M0 0h24v24H0z" fill="none"/></svg>',
	
	/* Flaticon (Freepik): https://www.flaticon.com/free-icon/copyright_1046496 */
	'flaticon-credits': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 512 512"><circle style="fill:#FEE572;" cx="256" cy="256" r="256"/><path style="fill:#FFC100;" d="M511.982,257.395L386.504,131.917C353.698,97.423,307.361,75.92,256,75.92  c-99.456,0-180.08,80.625-180.08,180.08c0,51.361,21.503,97.698,55.996,130.504l125.478,125.478  C397.671,511.232,511.232,397.671,511.982,257.395z"/><circle style="fill:#006EF5;" cx="256" cy="256" r="180.08"/><path style="fill:#0043A3;" d="M436.08,256c0,99.46-80.62,180.08-180.08,180.08V75.92C355.46,75.92,436.08,156.54,436.08,256z"/><path style="fill:#FFFFFF;" d="M141.895,253.969c0-14.664,2.65-29.16,7.954-43.49c5.298-14.326,13.029-27.128,23.183-38.413  c10.154-11.28,22.559-20.418,37.229-27.414c14.663-6.991,31.358-10.491,50.089-10.491c22.11,0,41.232,4.854,57.366,14.552  c16.128,9.704,28.143,22.338,36.044,37.905l-35.875,24.707c-3.163-6.769-6.996-12.464-11.507-17.091  c-4.517-4.622-9.366-8.292-14.553-10.999c-5.193-2.708-10.608-4.681-16.245-5.923c-5.643-1.238-11.169-1.862-16.584-1.862  c-11.734,0-21.946,2.369-30.629,7.107c-8.689,4.738-15.907,10.888-21.661,18.445c-5.753,7.561-10.1,16.134-13.029,25.721  c-2.935,9.593-4.4,19.122-4.4,28.598c0,10.608,1.692,20.815,5.076,30.63s8.176,18.445,14.384,25.891  c6.202,7.446,13.648,13.426,22.337,17.937c8.684,4.517,18.218,6.769,28.598,6.769c5.415,0,11.053-0.677,16.923-2.031  c5.865-1.354,11.449-3.495,16.753-6.43c5.299-2.93,10.207-6.711,14.722-11.338c4.511-4.623,8.123-10.206,10.83-16.753l38.244,21.998  c-3.839,9.027-9.307,16.981-16.414,23.861c-7.108,6.885-15.119,12.692-24.029,17.429c-8.916,4.738-18.446,8.351-28.599,10.831  c-10.153,2.48-20.084,3.722-29.782,3.722c-17.149,0-32.829-3.606-47.044-10.83c-14.215-7.219-26.457-16.637-36.721-28.26  c-10.27-11.618-18.276-24.817-24.029-39.597C144.772,284.376,141.895,269.315,141.895,253.969z"/><path style="fill:#FFF4AA;" d="M318.9,300c-2.71,6.54-6.32,12.13-10.83,16.75c-4.52,4.63-9.42,8.41-14.72,11.34  c-5.31,2.93-10.89,5.07-16.75,6.43c-5.87,1.35-11.51,2.03-16.93,2.03c-1.24,0-2.46-0.03-3.67-0.1v41.37  c0.77,0.01,1.54,0.02,2.32,0.02c9.7,0,19.63-1.24,29.78-3.72c10.16-2.48,19.68-6.1,28.6-10.83c8.91-4.74,16.92-10.55,24.03-17.43  s12.57-14.84,16.41-23.86L318.9,300z M275.58,177.31c5.64,1.24,11.05,3.22,16.24,5.93c5.19,2.7,10.04,6.37,14.56,10.99  c4.51,4.63,8.34,10.33,11.5,17.1l35.88-24.71c-7.9-15.57-19.92-28.2-36.04-37.91c-16.14-9.69-35.26-14.55-57.37-14.55  c-1.46,0-2.91,0.02-4.35,0.06v41.29c0.99-0.04,1.99-0.06,3-0.06C264.41,175.45,269.94,176.07,275.58,177.31z"/></svg>',

	/* Flaticon (Smashicons): https://www.flaticon.com/free-icon/database_148825 */
	'flaticon-data_import': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 53 53"><path style="fill:#424A60;" d="M50.455,8L50.455,8C49.724,3.538,39.281,0,26.5,0S3.276,3.538,2.545,8l0,0H2.5v0.5V20v0.5V21v11v0.5V33v12h0.045c0.731,4.461,11.175,8,23.955,8s23.224-3.539,23.955-8H50.5V33v-0.5V32V21v-0.5V20V8.5V8H50.455z"/><g><path style="fill:#424A60;" d="M26.5,41c-13.255,0-24-3.806-24-8.5V45h0.045c0.731,4.461,11.175,8,23.955,8s23.224-3.539,23.955-8H50.5V32.5C50.5,37.194,39.755,41,26.5,41z"/><path style="fill:#424A60;" d="M2.5,32v0.5c0-0.168,0.018-0.334,0.045-0.5H2.5z"/><path style="fill:#424A60;" d="M50.455,32c0.027,0.166,0.045,0.332,0.045,0.5V32H50.455z"/></g><g><path style="fill:#556080;" d="M26.5,29c-13.255,0-24-3.806-24-8.5V33h0.045c0.731,4.461,11.175,8,23.955,8s23.224-3.539,23.955-8H50.5V20.5C50.5,25.194,39.755,29,26.5,29z"/><path style="fill:#556080;" d="M2.5,20v0.5c0-0.168,0.018-0.334,0.045-0.5H2.5z"/><path style="fill:#556080;" d="M50.455,20c0.027,0.166,0.045,0.332,0.045,0.5V20H50.455z"/></g><ellipse style="fill:#7FABDA;" cx="26.5" cy="8.5" rx="24" ry="8.5"/><g><path style="fill:#7383BF;" d="M26.5,17c-13.255,0-24-3.806-24-8.5V21h0.045c0.731,4.461,11.175,8,23.955,8s23.224-3.539,23.955-8H50.5V8.5C50.5,13.194,39.755,17,26.5,17z"/><path style="fill:#7383BF;" d="M2.5,8v0.5c0-0.168,0.018-0.334,0.045-0.5H2.5z"/><path style="fill:#7383BF;" d="M50.455,8C50.482,8.166,50.5,8.332,50.5,8.5V8H50.455z"/></g></svg>',
	
	/* Flaticon (Vectors Market): https://www.flaticon.com/free-icon/email_321817 */
	'flaticon-email_settings': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 502.073 502.073"><path style="fill:#FFD15C;" d="M501.812,481.176c0,6.269-2.09,11.494-6.269,15.673c-4.18,3.135-8.359,5.224-14.629,5.224H21.159	c-5.224,0-10.449-2.09-14.629-5.224c-4.18-4.18-6.269-9.404-6.269-15.673V175.02h501.551V481.176z"/><path style="fill:#F8B64C;" d="M495.543,496.849c-4.18,3.135-8.359,5.224-14.629,5.224H21.159c-5.224,0-10.449-2.09-14.629-5.224	l244.506-210.024L495.543,496.849z"/><path style="fill:#40596B;" d="M501.812,175.02l-71.053,51.2L264.62,345.339c-8.359,6.269-19.853,6.269-28.212,0L71.314,226.22	l-71.053-51.2l71.053-51.2L225.959,13.061l11.494-8.359c8.359-6.269,19.853-6.269,28.212,0l11.494,8.359l74.188,53.29l36.571,26.122	l42.841,31.347L501.812,175.02z"/><path style="fill:#F2F2F2;" d="M430.759,77.845V226.22L264.62,345.339c-8.359,6.269-19.853,6.269-28.212,0L71.314,226.22V33.959	c0-11.494,9.404-20.898,20.898-20.898h272.718L430.759,77.845z"/><path style="fill:#CDD6E0;" d="M365.975,61.127c0,9.404,7.314,16.718,16.718,16.718h48.065l-64.784-64.784L365.975,61.127	L365.975,61.127z"/><path style="fill:#FF7058;" d="M312.686,223.086h16.718c-5.224,11.494-13.584,19.853-25.078,26.122	c-12.539,7.314-28.212,10.449-47.02,10.449c-17.763,0-33.437-3.135-45.976-9.404c-12.539-6.269-22.988-14.629-29.257-27.167	c-6.269-11.494-9.404-25.078-9.404-38.661c0-15.673,3.135-29.257,10.449-42.841c7.314-13.584,16.718-22.988,29.257-29.257	c12.539-6.269,27.167-9.404,42.841-9.404c13.584,0,26.122,3.135,36.571,8.359c10.449,5.224,18.808,12.539,24.033,22.988	c5.224,9.404,8.359,20.898,8.359,32.392c0,13.584-4.18,26.122-12.539,37.616c-10.449,14.629-24.033,20.898-40.751,20.898	c-4.18,0-8.359-1.045-10.449-2.09c-2.09-2.09-4.18-4.18-4.18-7.314c-6.269,6.269-13.584,9.404-21.943,9.404	c-9.404,0-16.718-3.135-21.943-9.404c-6.269-6.269-9.404-14.629-9.404-25.078c0-12.539,3.135-24.033,10.449-35.527	c8.359-12.539,19.853-18.808,33.437-18.808c9.404,0,16.718,4.18,21.943,11.494l2.09-9.404h21.943l-12.539,58.514	c-1.045,4.18-1.045,6.269-1.045,7.314s0,2.09,1.045,3.135s1.045,1.045,2.09,1.045c2.09,0,6.269-2.09,10.449-5.224	c5.224-4.18,10.449-9.404,13.584-16.718c3.135-7.314,5.224-14.629,5.224-21.943c0-13.584-5.224-25.078-14.629-33.437	c-9.404-9.404-22.988-13.584-40.751-13.584c-14.629,0-27.167,3.135-37.616,9.404c-10.449,6.269-17.763,14.629-22.988,25.078	s-7.314,21.943-7.314,34.482c0,11.494,3.135,21.943,8.359,31.347c6.269,9.404,13.584,16.718,24.033,20.898	c10.449,4.18,21.943,6.269,35.527,6.269c12.539,0,24.033-2.09,33.437-5.224C299.102,235.624,306.416,230.4,312.686,223.086z	 M223.869,189.649c0,7.314,1.045,11.494,4.18,15.673c3.135,3.135,6.269,5.224,10.449,5.224c3.135,0,6.269-1.045,8.359-2.09	c2.09-1.045,4.18-3.135,6.269-5.224c3.135-3.135,5.225-8.359,7.314-14.629c2.09-6.269,3.135-12.539,3.135-17.763	c0-6.269-1.045-10.449-4.18-14.629c-3.135-3.135-6.269-5.224-10.449-5.224c-4.18,0-9.404,2.09-12.539,5.224	c-4.18,3.135-7.314,8.359-9.404,15.673C224.914,178.155,223.869,184.424,223.869,189.649z"/></svg>',
	
    /* Flaticon (Smashicons): https://www.flaticon.com/free-icon/write-letter_1034249 */
    'flaticon-feedback': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 504.036 504.036"><g><path style="fill:#F3D55B;" d="M347.119,278.052v208.271c-0.029,9.574-7.782,17.327-17.356,17.356H17.356 C7.782,503.651,0.029,495.897,0,486.323V17.713C0.029,8.14,7.782,0.386,17.356,0.357h312.407 c9.574,0.029,17.327,7.782,17.356,17.356V278.052z"/><polygon style="fill:#AF8066;" points="88.888,383.064 52.068,468.967 137.971,432.147 147.525,416.9 104.136,373.51 "/><g><path style="fill:#3D324C;" d="M69.424,87.137h208.271c4.793,0,8.678-3.885,8.678-8.678c0-4.793-3.885-8.678-8.678-8.678H69.424 c-4.793,0-8.678,3.885-8.678,8.678C60.746,83.252,64.631,87.137,69.424,87.137z"/><path style="fill:#3D324C;" d="M277.695,121.849H69.424c-4.793,0-8.678,3.885-8.678,8.678c0,4.793,3.885,8.678,8.678,8.678 h208.271c4.793,0,8.678-3.885,8.678-8.678C286.373,125.734,282.488,121.849,277.695,121.849z"/><path style="fill:#3D324C;" d="M225.627,173.916H69.424c-4.793,0-8.678,3.885-8.678,8.678s3.885,8.678,8.678,8.678h156.203 c4.793,0,8.678-3.885,8.678-8.678S230.42,173.916,225.627,173.916z"/></g>  <rect x="41.646" y="199.659" transform="matrix(-0.7071 0.7071 -0.7071 -0.7071 655.1008 197.3902)" style="fill:#F29C1F;" width="490.047" height="69.424"/>  <rect x="406.704" y="60.872" transform="matrix(-0.7071 0.7071 -0.7071 -0.7071 793.8229 -137.6442)" style="fill:#D1D4D1;" width="37.428" height="69.424"/><path style="fill:#DF4D60;" d="M493.863,76.289l-30.633,30.633l-49.117-49.117l30.633-30.633 c8.774-8.774,21.562-12.201,33.548-8.989s21.347,12.573,24.559,24.559C506.064,54.727,502.637,67.515,493.863,76.289z"/></g></svg>',

    /* Flaticon (Smashicons): https://www.flaticon.com/free-icon/folder_148956 */
    'flaticon-file_settings': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 58 58"><path style="fill:#EFCE4A;" d="M46.324,58H1.565c-1.03,0-1.779-0.978-1.51-1.973l10.166-27.871C10.405,27.474,11.024,27,11.731,27	H56.49c1.03,0,1.51,0.984,1.51,1.973L47.834,56.844C47.65,57.526,47.031,58,46.324,58z"/><path style="fill:#F4EFDC;" d="M10.221,28.156C10.405,27.474,11.024,27,11.731,27H46V15L31,0H8v34.245L10.221,28.156z"/><g><path style="fill:#EBBA16;" d="M50.268,18H46v9h6v-7.268C52,18.775,51.224,18,50.268,18z"/><path style="fill:#EBBA16;" d="M8,11H1.732C0.776,11,0,11.775,0,12.732V55.46c0.069,0.002,0.138,0.006,0.205,0.01L8,34.212V11z"/></g><path style="fill:#CEC9AE;" d="M25,16H15c-0.552,0-1-0.447-1-1s0.448-1,1-1h10c0.552,0,1,0.447,1,1S25.552,16,25,16z"/><path style="fill:#CEC9AE;" d="M25,9H15c-0.552,0-1-0.447-1-1s0.448-1,1-1h10c0.552,0,1,0.447,1,1S25.552,9,25,9z"/><path style="fill:#CEC9AE;" d="M39,23H15c-0.552,0-1-0.447-1-1s0.448-1,1-1h24c0.552,0,1,0.447,1,1S39.552,23,39,23z"/><polygon style="fill:#D1BF86;" points="31,15 46,15 31,0 "/></svg>',
    
    /* Flaticon (srip): https://www.flaticon.com/free-icon/file_1264571 */
    'flaticon-file': '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="-63 -5 480 480"><path d="m248.5 112v-104h-240v464h336v-360zm0 0" fill="#fff"/><path d="m344.5 112-96-104v104zm0 0" fill="#9bc9ff"/><g fill="#1e81ce"><path d="m352.410156 111.519531c-.042968-.648437-.164062-1.289062-.359375-1.910156-.078125-.25-.136719-.503906-.238281-.746094-.34375-.835937-.828125-1.609375-1.433594-2.289062l-96-104c-.683594-.714844-1.5-1.296875-2.398437-1.71875-.242188-.113281-.472657-.191407-.71875-.28125-.742188-.277344-1.523438-.441407-2.3125-.4765628-.148438-.0429687-.296875-.0742187-.449219-.0976562h-240c-4.417969 0-8 3.582031-8 8v464c0 4.417969 3.582031 8 8 8h336c4.417969 0 8-3.582031 8-8v-360c0-.167969-.078125-.320312-.089844-.480469zm-26.183594-7.519531h-69.726562v-75.535156zm-309.726562 360v-448h224v96c0 4.417969 3.582031 8 8 8h88v344zm0 0"/><path d="m192.5 104h-128c-4.417969 0-8-3.582031-8-8s3.582031-8 8-8h128c4.417969 0 8 3.582031 8 8s-3.582031 8-8 8zm0 0"/><path d="m288.5 176h-224c-4.417969 0-8-3.582031-8-8s3.582031-8 8-8h224c4.417969 0 8 3.582031 8 8s-3.582031 8-8 8zm0 0"/><path d="m288.5 248h-224c-4.417969 0-8-3.582031-8-8s3.582031-8 8-8h224c4.417969 0 8 3.582031 8 8s-3.582031 8-8 8zm0 0"/><path d="m288.5 320h-224c-4.417969 0-8-3.582031-8-8s3.582031-8 8-8h224c4.417969 0 8 3.582031 8 8s-3.582031 8-8 8zm0 0"/><path d="m288.5 392h-224c-4.417969 0-8-3.582031-8-8s3.582031-8 8-8h224c4.417969 0 8 3.582031 8 8s-3.582031 8-8 8zm0 0"/></g></svg>',

    /* Flaticon (Freepik): https://www.flaticon.com/free-icon/csv-file-format-extension_28842 */
    'flaticon-file_ext_csv': '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 548.29 548.291"><g><path style="fill:#217346" d="M486.2,196.121h-13.164V132.59c0-0.399-0.064-0.795-0.116-1.2c-0.021-2.52-0.824-5-2.551-6.96L364.656,3.677c-0.031-0.034-0.064-0.044-0.085-0.075c-0.629-0.707-1.364-1.292-2.141-1.796c-0.231-0.157-0.462-0.286-0.704-0.419c-0.672-0.365-1.386-0.672-2.121-0.893c-0.199-0.052-0.377-0.134-0.576-0.188C358.229,0.118,357.4,0,356.562,0H96.757C84.893,0,75.256,9.649,75.256,21.502v174.613H62.093c-16.972,0-30.733,13.756-30.733,30.73v159.81c0,16.966,13.761,30.736,30.733,30.736h13.163V526.79c0,11.854,9.637,21.501,21.501,21.501h354.777c11.853,0,21.502-9.647,21.502-21.501V417.392H486.2c16.966,0,30.729-13.764,30.729-30.731v-159.81C516.93,209.872,503.166,196.121,486.2,196.121z M96.757,21.502h249.053v110.006c0,5.94,4.818,10.751,10.751,10.751h94.973v53.861H96.757V21.502z M258.618,313.18c-26.68-9.291-44.063-24.053-44.063-47.389c0-27.404,22.861-48.368,60.733-48.368c18.107,0,31.447,3.811,40.968,8.107l-8.09,29.3c-6.43-3.107-17.862-7.632-33.59-7.632c-15.717,0-23.339,7.149-23.339,15.485c0,10.247,9.047,14.769,29.78,22.632c28.341,10.479,41.681,25.239,41.681,47.874c0,26.909-20.721,49.786-64.792,49.786c-18.338,0-36.449-4.776-45.497-9.77l7.38-30.016c9.772,5.014,24.775,10.006,40.264,10.006c16.671,0,25.488-6.908,25.488-17.396C285.536,325.789,277.909,320.078,258.618,313.18z M69.474,302.692c0-54.781,39.074-85.269,87.654-85.269c18.822,0,33.113,3.811,39.549,7.149l-7.392,28.816c-7.38-3.084-17.632-5.939-30.491-5.939c-28.822,0-51.206,17.375-51.206,53.099c0,32.158,19.051,52.4,51.456,52.4c10.947,0,23.097-2.378,30.241-5.238l5.483,28.346c-6.672,3.34-21.674,6.919-41.208,6.919C98.06,382.976,69.474,348.424,69.474,302.692z M451.534,520.962H96.757v-103.57h354.777V520.962z M427.518,380.583h-42.399l-51.45-160.536h39.787l19.526,67.894c5.479,19.046,10.479,37.386,14.299,57.397h0.709c4.048-19.298,9.045-38.352,14.526-56.693l20.487-68.598h38.599L427.518,380.583z"/></g></svg>',

    /* Flaticon (Freepik): https://www.flaticon.com/free-icon/picture_1026469 */
    'flaticon-file_ext_image': '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 512 512"><path style="fill:#FFFFFF;" d="M458,101.127V482c0,11.046-8.954,20-20,20H74c-11.046,0-20-8.954-20-20V30c0-11.046,8.954-20,20-20h293"/><path style="fill:#72D8FF;" d="M368.167,10v69.833c0,11.046,8.954,20,20,20H458L368.167,10z"/><path d="M458,342.333c5.523,0,10-4.477,10-10V101.127c0-0.244-0.019-0.482-0.036-0.722c0.16-2.795-0.84-5.59-2.892-7.643L375.238,2.929c-2.032-2.032-4.793-3.029-7.56-2.894C367.453,0.019,367.229,0,367,0H74C57.458,0,44,13.458,44,30v452c0,16.542,13.458,30,30,30h364c16.542,0,30-13.458,30-30v-55c0-5.523-4.477-10-10-10s-10,4.477-10,10v55c0,5.514-4.486,10-10,10H74c-5.514,0-10-4.486-10-10V30c0-5.514,4.486-10,10-10h284.167v59.833c0,16.542,13.458,30,30,30H448v222.5C448,337.856,452.477,342.333,458,342.333z M388.167,89.833c-5.514,0-10-4.486-10-10V34.142l55.691,55.691H388.167z"/><path d="M458,388.95c-2.63,0-5.21-1.07-7.07-2.93c-1.86-1.86-2.93-4.43-2.93-7.07c0-2.63,1.07-5.21,2.93-7.07c1.86-1.86,4.44-2.93,7.07-2.93s5.21,1.07,7.07,2.93s2.93,4.44,2.93,7.07s-1.07,5.21-2.93,7.07C463.21,387.88,460.63,388.95,458,388.95z"/><path style="fill:#C9F3FF;" d="M372,384H140c-11.046,0-20-8.954-20-20V188c0-11.046,8.954-20,20-20h232c11.046,0,20,8.954,20,20v176C392,375.046,383.046,384,372,384z"/><path style="fill:#62CD4D;" d="M392,338l-87-87L172,384h200c11.046,0,20-8.954,20-20V338z"/><polygon style="fill:#A0E557;" points="222.5,305.833 144.333,384 300.667,384 "/><path d="M275,178c-2.63,0-5.21-1.07-7.07-2.93c-1.86-1.86-2.93-4.44-2.93-7.07s1.07-5.21,2.93-7.07S272.37,158,275,158s5.21,1.07,7.07,2.93c1.86,1.86,2.93,4.44,2.93,7.07s-1.07,5.21-2.93,7.07S277.63,178,275,178z"/><path d="M372,158h-60c-5.523,0-10,4.477-10,10s4.477,10,10,10h60c5.514,0,10,4.486,10,10v125.857l-69.929-69.929c-3.905-3.904-10.237-3.904-14.143,0l-40.667,40.667c-3.905,3.905-3.905,10.237,0,14.143c3.905,3.905,10.237,3.905,14.143,0L305,265.142l77,77V364c0,5.514-4.486,10-10,10H168.476l54.024-54.024l29.429,29.429c3.905,3.905,10.237,3.905,14.143,0c3.905-3.905,3.905-10.237,0-14.143l-36.5-36.5c-3.905-3.905-10.237-3.905-14.143,0L140.191,374H140c-5.514,0-10-4.486-10-10V188c0-5.514,4.486-10,10-10h86c5.523,0,10-4.477,10-10s-4.477-10-10-10h-86c-16.542,0-30,13.458-30,30v176c0,16.542,13.458,30,30,30h232c16.542,0,30-13.458,30-30V188C402,171.458,388.542,158,372,158z"/><circle style="fill:#FFFFFF;" cx="199.67" cy="251" r="22"/><path d="M199.667,283c-17.645,0-32-14.355-32-32s14.355-32,32-32s32,14.355,32,32S217.312,283,199.667,283z M199.667,239c-6.617,0-12,5.383-12,12s5.383,12,12,12s12-5.383,12-12S206.283,239,199.667,239z"/></svg>',
    
    /* Flaticon (Freepik): https://www.flaticon.com/free-icon/pdf-file-format-symbol_29099 */
    'flaticon-file_ext_pdf': '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 550.801 550.801"><g><path style="fill:#A91D23" d="M160.381,282.225c0-14.832-10.299-23.684-28.474-23.684c-7.414,0-12.437,0.715-15.071,1.432V307.6c3.114,0.707,6.942,0.949,12.192,0.949C148.419,308.549,160.381,298.74,160.381,282.225z"/><path style="fill:#A91D23" d="M272.875,259.019c-8.145,0-13.397,0.717-16.519,1.435v105.523c3.116,0.729,8.142,0.729,12.69,0.729c33.017,0.231,54.554-17.946,54.554-56.474C323.842,276.719,304.215,259.019,272.875,259.019z"/><path style="fill:#A91D23" d="M488.426,197.019H475.2v-63.816c0-0.398-0.063-0.799-0.116-1.202c-0.021-2.534-0.827-5.023-2.562-6.995L366.325,3.694c-0.032-0.031-0.063-0.042-0.085-0.076c-0.633-0.707-1.371-1.295-2.151-1.804c-0.231-0.155-0.464-0.285-0.706-0.419c-0.676-0.369-1.393-0.675-2.131-0.896c-0.2-0.056-0.38-0.138-0.58-0.19C359.87,0.119,359.037,0,358.193,0H97.2c-11.918,0-21.6,9.693-21.6,21.601v175.413H62.377c-17.049,0-30.873,13.818-30.873,30.873v160.545c0,17.043,13.824,30.87,30.873,30.87h13.224V529.2c0,11.907,9.682,21.601,21.6,21.601h356.4c11.907,0,21.6-9.693,21.6-21.601V419.302h13.226c17.044,0,30.871-13.827,30.871-30.87v-160.54C519.297,210.838,505.47,197.019,488.426,197.019z M97.2,21.605h250.193v110.513c0,5.967,4.841,10.8,10.8,10.8h95.407v54.108H97.2V21.605z M362.359,309.023c0,30.876-11.243,52.165-26.82,65.333c-16.971,14.117-42.82,20.814-74.396,20.814c-18.9,0-32.297-1.197-41.401-2.389V234.365c13.399-2.149,30.878-3.346,49.304-3.346c30.612,0,50.478,5.508,66.039,17.226C351.828,260.69,362.359,280.547,362.359,309.023z M80.7,393.499V234.365c11.241-1.904,27.042-3.346,49.296-3.346c22.491,0,38.527,4.308,49.291,12.928c10.292,8.131,17.215,21.534,17.215,37.328c0,15.799-5.25,29.198-14.829,38.285c-12.442,11.728-30.865,16.996-52.407,16.996c-4.778,0-9.1-0.243-12.435-0.723v57.67H80.7V393.499z M453.601,523.353H97.2V419.302h356.4V523.353z M484.898,262.127h-61.989v36.851h57.913v29.674h-57.913v64.848h-36.593V232.216h98.582V262.127z"/></g></svg>',
    
    /* Flaticon (Freepik): https://www.flaticon.com/free-icon/rar-file-format_28792 */
    'flaticon-file_ext_rar': '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 548.291 548.291"><g><path style="fill:#610353" d="M270.082,281.054c-2.871-9.531-5.725-21.441-8.105-30.969h-0.48c-2.375,9.528-4.756,21.675-7.38,30.969l-9.525,34.053h35.498L270.082,281.054z"/><path style="fill:#610353" d="M486.201,196.121h-13.166v-63.525c0-0.396-0.062-0.795-0.115-1.196c-0.021-2.523-0.825-5-2.552-6.964L364.657,3.677c-0.033-0.031-0.064-0.042-0.085-0.075c-0.63-0.704-1.364-1.29-2.143-1.796c-0.229-0.154-0.461-0.283-0.702-0.418c-0.672-0.366-1.387-0.671-2.121-0.892c-0.2-0.055-0.379-0.136-0.577-0.188C358.23,0.118,357.401,0,356.562,0H96.757C84.894,0,75.256,9.649,75.256,21.502v174.613H62.092c-16.971,0-30.732,13.756-30.732,30.733v159.812c0,16.968,13.761,30.731,30.732,30.731h13.164V526.79c0,11.854,9.638,21.501,21.501,21.501h354.776c11.853,0,21.501-9.647,21.501-21.501V417.392h13.166c16.966,0,30.729-13.764,30.729-30.731V226.854C516.93,209.877,503.167,196.121,486.201,196.121z M96.757,21.507h249.054v110.01c0,5.939,4.817,10.75,10.751,10.75h94.972v53.861H96.757V21.507z M336.771,383.469h-39.076l-12.379-41.208h-45.977l-11.428,41.208h-37.633l49.061-160.544h47.636L336.771,383.469z M94.511,320.351v63.118H58.544V225.074c11.67-1.913,29.063-3.338,48.353-3.338c23.821,0,40.501,3.57,51.929,12.623c9.52,7.617,14.771,18.819,14.771,33.586c0,20.485-14.527,34.538-28.344,39.542v0.717c11.198,4.526,17.384,15.235,21.434,30.013c5.003,18.1,9.998,39.06,13.105,45.254h-37.155c-2.625-4.529-6.441-17.615-11.197-37.396c-4.289-20.007-11.192-25.492-25.964-25.723H94.511z M451.534,520.968H96.757V417.392h354.776V520.968z M442.315,383.469c-2.625-4.529-6.436-17.615-11.202-37.396c-4.278-20.007-11.196-25.492-25.952-25.723H394.2v63.118h-35.97V225.074c11.675-1.913,29.051-3.338,48.347-3.338c23.828,0,40.495,3.57,51.933,12.623c9.528,7.617,14.777,18.819,14.777,33.586c0,20.485-14.541,34.538-28.356,39.542v0.717c11.201,4.526,17.396,15.235,21.438,30.013c5.009,18.1,10.006,39.06,13.109,45.254H442.315z"/><path d="M137.626,271.046c0-14.771-10.002-22.153-26.677-22.4c-8.816,0-13.814,0.714-16.444,1.192v44.297h14.294C126.913,294.146,137.626,285.095,137.626,271.046z"/><path d="M410.64,248.651c-8.824,0-13.815,0.714-16.446,1.192v44.303h14.294c18.09,0,28.82-9.051,28.82-23.1C437.308,256.274,427.313,248.893,410.64,248.651z"/></g></svg>',
    
    /* Flaticon (Freepik): https://www.flaticon.com/free-icon/zip-file-format_28814 */
    'flaticon-file_ext_zip': '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 548.291 548.291"><g><path style="fill:#9E7120" d="M486.201,196.121h-13.166v-63.525c0-0.396-0.062-0.795-0.115-1.196c-0.021-2.523-0.825-5-2.552-6.964L364.657,3.677c-0.033-0.031-0.064-0.042-0.085-0.075c-0.63-0.704-1.364-1.29-2.143-1.796c-0.229-0.154-0.461-0.283-0.702-0.418c-0.672-0.366-1.387-0.671-2.121-0.892c-0.2-0.055-0.379-0.136-0.577-0.188C358.23,0.118,357.401,0,356.562,0H96.757C84.894,0,75.256,9.649,75.256,21.502v174.613H62.092c-16.971,0-30.732,13.756-30.732,30.733v159.812c0,16.968,13.761,30.731,30.732,30.731h13.164V526.79c0,11.854,9.638,21.501,21.501,21.501h354.776c11.853,0,21.501-9.647,21.501-21.501V417.392h13.166c16.966,0,30.729-13.764,30.729-30.731V226.854C516.93,209.877,503.167,196.121,486.201,196.121z M96.757,21.507h249.054v110.01c0,5.939,4.817,10.75,10.751,10.75h94.972v53.861H96.757V21.507z M323.311,223.638v160.545h-36.447V223.638H323.311z M146.309,253.649v-30.011h116.474v20.967l-74.789,108.618v0.944h75.985v30.016H139.165v-19.537l76.465-110.039v-0.958H146.309z M451.534,520.968H96.757V417.392h354.776V520.968z M455.276,310.586c-12.384,11.671-30.724,16.903-52.164,16.903c-4.775,0-9.05-0.23-12.388-0.709v57.402H354.76v-158.4c11.192-1.914,26.909-3.336,49.061-3.336c22.399,0,38.349,4.284,49.077,12.861c10.236,8.097,17.145,21.438,17.145,37.161C470.047,288.188,464.804,301.526,455.276,310.586z"/><path style="fill:#9E7120" d="M405.738,249.838c-7.401,0-12.405,0.717-15.014,1.436v47.397c3.086,0.714,6.908,0.956,12.152,0.956c19.286,0,31.203-9.775,31.203-26.201C434.08,258.655,423.837,249.838,405.738,249.838z"/></g></svg>',
    
    /* Flaticon (Pixel perfect): https://www.flaticon.com/free-icon/excel_888850 */
	'flaticon-file_ext_ms_excel': '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 542 512"><g><path style="fill:#4CAF50;" d="M294.656,13.014c-2.531-2.056-5.863-2.842-9.045-2.133l-277.333,64C3.397,76.003-0.047,80.369,0,85.377v362.667c0.002,5.263,3.843,9.739,9.045,10.539l277.333,42.667c5.823,0.895,11.269-3.099,12.164-8.921c0.082-0.535,0.124-1.076,0.124-1.617V21.377C298.676,18.124,297.199,15.045,294.656,13.014z"/><path style="fill:#4CAF50;" d="M501.334,458.71H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h202.667V74.71H288c-5.891,0-10.667-4.776-10.667-10.667S282.109,53.377,288,53.377h213.333c5.891,0,10.667,4.776,10.667,10.667v384C512,453.935,507.225,458.71,501.334,458.71z"/></g><g><path style="fill:#FAFAFA;" d="M202.667,352.044c-3.678,0-7.096-1.895-9.045-5.013L86.955,176.364c-3.279-4.894-1.969-11.52,2.925-14.799s11.52-1.969,14.799,2.925c0.129,0.192,0.251,0.388,0.367,0.588l106.667,170.667c3.11,5.003,1.576,11.58-3.427,14.691C206.599,351.484,204.653,352.041,202.667,352.044z"/><path style="fill:#FAFAFA;" d="M96,352.044c-5.891-0.012-10.657-4.797-10.645-10.688c0.004-1.992,0.566-3.943,1.621-5.632l106.667-170.667c2.954-5.097,9.481-6.834,14.577-3.88c5.097,2.954,6.834,9.481,3.88,14.577c-0.116,0.2-0.238,0.396-0.367,0.588L105.067,347.009C103.119,350.142,99.69,352.047,96,352.044z"/></g><g><path style="fill:#4CAF50;" d="M373.334,458.71c-5.891,0-10.667-4.776-10.667-10.667v-384c0-5.891,4.776-10.667,10.667-10.667c5.891,0,10.667,4.776,10.667,10.667v384C384,453.935,379.225,458.71,373.334,458.71z"/><path style="fill:#4CAF50;" d="M501.334,394.71H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h213.333c5.891,0,10.667,4.776,10.667,10.667C512,389.935,507.225,394.71,501.334,394.71z"/><path style="fill:#4CAF50;" d="M501.334,330.71H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h213.333c5.891,0,10.667,4.776,10.667,10.667C512,325.935,507.225,330.71,501.334,330.71z"/><path style="fill:#4CAF50;" d="M501.334,266.71H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h213.333c5.891,0,10.667,4.776,10.667,10.667C512,261.935,507.225,266.71,501.334,266.71z"/><path style="fill:#4CAF50;" d="M501.334,202.71H288c-5.891,0-10.667-4.776-10.667-10.667s4.776-10.667,10.667-10.667h213.333c5.891,0,10.667,4.776,10.667,10.667S507.225,202.71,501.334,202.71z"/><path style="fill:#4CAF50;" d="M501.334,138.71H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h213.333c5.891,0,10.667,4.776,10.667,10.667C512,133.935,507.225,138.71,501.334,138.71z"/></g></svg>',

    /* Flaticon (Pixel perfect): https://www.flaticon.com/free-icon/powerpoint_888874 */
    'flaticon-file_ext_ms_powerpoint': '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 542 512"><g><path style="fill:#FF5722;" d="M373.334,117.377c-5.891,0-10.667,4.776-10.667,10.667v64c0,5.891,4.776,10.667,10.667,10.667h64c5.891,0,10.667-4.776,10.667-10.667C448,150.807,414.571,117.377,373.334,117.377z"/><path style="fill:#FF5722;" d="M373.334,224.044c-17.673,0-32-14.327-32-32v-52.245c-40.733,5.794-69.056,43.512-63.262,84.245c5.794,40.733,43.512,69.056,84.245,63.262c32.812-4.668,58.594-30.45,63.262-63.262H373.334z"/><path style="fill:#FF5722;" d="M294.656,13.014c-2.531-2.056-5.863-2.842-9.045-2.133l-277.333,64C3.397,76.003-0.047,80.369,0,85.377v362.667c0.002,5.263,3.843,9.739,9.045,10.539l277.333,42.667c5.823,0.895,11.269-3.099,12.164-8.921c0.082-0.535,0.124-1.076,0.124-1.617V21.377C298.676,18.124,297.199,15.045,294.656,13.014z"/><path style="fill:#FF5722;" d="M501.334,458.71H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h202.667V74.71H288c-5.891,0-10.667-4.776-10.667-10.667S282.109,53.377,288,53.377h213.333c5.891,0,10.667,4.776,10.667,10.667v384C512,453.935,507.225,458.71,501.334,458.71z"/><path style="fill:#FF5722;" d="M437.334,394.71H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h149.333c5.891,0,10.667,4.776,10.667,10.667C448,389.935,443.225,394.71,437.334,394.71z"/><path style="fill:#FF5722;" d="M437.334,330.71H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h149.333c5.891,0,10.667,4.776,10.667,10.667C448,325.935,443.225,330.71,437.334,330.71z"/></g><path style="fill:#FAFAFA;" d="M96,352.044c-5.891,0-10.667-4.776-10.667-10.667V170.71c0-5.891,4.776-10.667,10.667-10.667h42.667c29.455,0,53.333,23.878,53.333,53.333v21.333c0,29.455-23.878,53.333-53.333,53.333h-32v53.333C106.667,347.268,101.892,352.044,96,352.044z M106.667,266.71h32c17.673,0,32-14.327,32-32v-21.333c0-17.673-14.327-32-32-32h-32V266.71z"/></svg>',
    
    /* Flaticon (Pixel perfect): https://www.flaticon.com/free-icon/word_732226 */
    'flaticon-file_ext_ms_word': '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 542 512"><g><path style="fill:#1565C0;" d="M294.656,13.014c-2.531-2.056-5.863-2.842-9.045-2.133l-277.333,64C3.397,76.003-0.047,80.369,0,85.377v362.667c0.002,5.263,3.843,9.739,9.045,10.539l277.333,42.667c5.823,0.895,11.269-3.099,12.164-8.921c0.082-0.535,0.124-1.076,0.124-1.617V21.377C298.676,18.124,297.199,15.045,294.656,13.014z"/><path style="fill:#1565C0;" d="M501.334,458.71H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h202.667V74.71H288c-5.891,0-10.667-4.776-10.667-10.667S282.109,53.377,288,53.377h213.333c5.891,0,10.667,4.776,10.667,10.667v384C512,453.935,507.225,458.71,501.334,458.71z"/></g><path style="fill:#FAFAFA;" d="M181.334,352.044c-4.753-0.005-8.928-3.155-10.24-7.723L138.667,230.87L106.24,344.321c-2.342,5.661-8.83,8.352-14.492,6.01c-2.722-1.126-4.884-3.288-6.01-6.01L43.072,194.988c-1.786-5.614,1.318-11.612,6.932-13.398c5.614-1.786,11.612,1.318,13.398,6.932c0.063,0.198,0.12,0.398,0.172,0.599L96,302.55L128.427,189.1c2.342-5.661,8.83-8.352,14.492-6.01c2.722,1.126,4.884,3.288,6.01,6.01l32.405,113.451l32.427-113.429c1.535-5.614,7.331-8.921,12.945-7.386c0.08,0.022,0.159,0.045,0.239,0.068c5.66,1.622,8.935,7.523,7.317,13.184l-42.667,149.333C190.281,348.897,186.094,352.048,181.334,352.044z"/><g><path style="fill:#1565C0;" d="M458.667,138.71H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h170.667c5.891,0,10.667,4.776,10.667,10.667C469.334,133.935,464.558,138.71,458.667,138.71z"/><path style="fill:#1565C0;" d="M458.667,202.71H288c-5.891,0-10.667-4.776-10.667-10.667s4.776-10.667,10.667-10.667h170.667c5.891,0,10.667,4.776,10.667,10.667S464.558,202.71,458.667,202.71z"/><path style="fill:#1565C0;" d="M458.667,266.71H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h170.667c5.891,0,10.667,4.776,10.667,10.667C469.334,261.935,464.558,266.71,458.667,266.71z"/><path style="fill:#1565C0;" d="M458.667,330.71H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h170.667c5.891,0,10.667,4.776,10.667,10.667C469.334,325.935,464.558,330.71,458.667,330.71z"/><path style="fill:#1565C0;" d="M458.667,394.71H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h170.667c5.891,0,10.667,4.776,10.667,10.667C469.334,389.935,464.558,394.71,458.667,394.71z"/></g></svg>',
    
    /* Flaticon (Freepik): https://www.flaticon.com/free-icon/loading_248960 */
	'flaticon-loading': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 512 512"><path style="fill:#2D50A7;" d="M116.364,221.091H23.273C10.42,221.091,0,231.511,0,244.364c0,12.853,10.42,23.273,23.273,23.273h93.091c12.853,0,23.273-10.42,23.273-23.273C139.636,231.511,129.216,221.091,116.364,221.091z"/><path style="fill:#73A1FB;" d="M488.727,221.091h-93.091c-12.853,0-23.273,10.42-23.273,23.273c0,12.853,10.42,23.273,23.273,23.273h93.091c12.853,0,23.273-10.42,23.273-23.273C512,231.511,501.58,221.091,488.727,221.091z"/><path style="fill:#355EC9;" d="M140.805,326.645L74.98,392.471c-9.089,9.089-9.089,23.823,0,32.912c4.544,4.544,10.501,6.816,16.457,6.816s11.913-2.273,16.455-6.816l65.825-65.826c9.089-9.089,9.089-23.824,0-32.912S149.892,317.556,140.805,326.645z"/><g><path style="fill:#C4D9FD;" d="M256,11.636c-12.853,0-23.273,10.42-23.273,23.273v46.545c0,12.853,10.42,23.273,23.273,23.273c12.853,0,23.273-10.42,23.273-23.273V34.909C279.273,22.056,268.853,11.636,256,11.636z"/><path style="fill:#C4D9FD;" d="M404.105,63.344L338.28,129.17c-9.089,9.089-9.089,23.824,0,32.912c4.544,4.544,10.501,6.817,16.457,6.817s11.913-2.273,16.455-6.817l65.825-65.826c9.089-9.089,9.089-23.824,0-32.912C427.93,54.255,413.192,54.255,404.105,63.344z"/></g><path style="fill:#3D6DEB;" d="M256,360.727c-12.853,0-23.273,10.42-23.273,23.273v93.091c0,12.853,10.42,23.273,23.273,23.273c12.853,0,23.273-10.42,23.273-23.273V384C279.273,371.147,268.853,360.727,256,360.727z"/><path style="fill:#5286FA;" d="M371.192,326.645c-9.086-9.089-23.824-9.089-32.912,0c-9.089,9.087-9.089,23.824,0,32.912l65.825,65.826c4.544,4.544,10.501,6.816,16.457,6.816c5.955,0,11.913-2.273,16.455-6.816c9.089-9.089,9.089-23.824,0-32.912L371.192,326.645z"/></svg>',

	/* Flaticon (Freepik): https://www.flaticon.com/free-icon/palette_1010622 */
	'flaticon-palette': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 512 468"><path style="fill:#FADC60;" d="M237.348,22.076C0.953,29.902,0,171.914,0,171.914c0,118.929,159.244,96.756,169.323,240.882C179.402,556.921,512,498.931,512,240.682C512,20.768,249.287,21.681,237.348,22.076z M331.275,415.334c-29.569,29.569-71.836,35.246-94.404,12.678c-22.568-22.567-16.892-64.834,12.678-94.404c29.57-29.57,71.836-35.246,94.404-12.678C366.522,343.498,360.845,385.764,331.275,415.334z"/><path style="fill:#E6CB59;" d="M200.228,402.494C190.15,258.367,30.905,280.541,30.905,161.612c0,0,0.56-83.135,106.707-125.693C0.67,73.337,0,171.914,0,171.914c0,118.929,159.244,96.756,169.323,240.882c5.315,75.992,100.29,95.785,188.9,59.671C279.715,492.938,204.927,469.681,200.228,402.494z"/><circle style="fill:#58B78C;" cx="102.874" cy="131.08" r="32.567"/><path style="fill:#46926F;" d="M113.181,153.348c-17.986,0-32.567-14.581-32.567-32.567c0-6.354,1.827-12.28,4.974-17.292c-9.174,5.761-15.276,15.962-15.276,27.593c0,17.986,14.581,32.567,32.567,32.567c11.632,0,21.833-6.103,27.593-15.276C125.461,151.521,119.536,153.348,113.181,153.348z"/><circle style="fill:#FF98C9;" cx="211.084" cy="94.828" r="32.567"/><path style="fill:#EB6DA8;" d="M221.387,117.095c-17.986,0-32.567-14.581-32.567-32.567c0-6.354,1.827-12.28,4.974-17.292c-9.174,5.761-15.276,15.962-15.276,27.593c0,17.986,14.581,32.567,32.567,32.567c11.632,0,21.833-6.103,27.593-15.276C233.667,115.267,227.742,117.095,221.387,117.095z"/><circle style="fill:#6EE3FF;" cx="317.347" cy="103.008" r="32.567"/><path style="fill:#42C3E2;" d="M327.649,125.272c-17.986,0-32.567-14.581-32.567-32.567c0-6.354,1.827-12.28,4.974-17.292c-9.174,5.761-15.276,15.962-15.276,27.593c0,17.986,14.581,32.567,32.567,32.567c11.632,0,21.833-6.103,27.593-15.276C339.929,123.446,334.003,125.272,327.649,125.272z"/><circle style="fill:#FD6F71;" cx="410.022" cy="154.424" r="32.567"/><path style="fill:#E36465;" d="M420.323,176.689c-17.986,0-32.567-14.58-32.567-32.567c0-6.354,1.827-12.28,4.974-17.292c-9.174,5.761-15.276,15.962-15.276,27.593c0,17.986,14.581,32.567,32.567,32.567c11.632,0,21.833-6.103,27.593-15.276C432.603,174.862,426.678,176.689,420.323,176.689z"/><circle style="fill:#B6A4FF;" cx="436.683" cy="254.403" r="32.567"/><path style="fill:#937FE6;" d="M446.981,276.668c-17.986,0-32.567-14.581-32.567-32.567c0-6.354,1.827-12.28,4.974-17.292c-9.174,5.761-15.276,15.962-15.276,27.593c0,17.986,14.581,32.567,32.567,32.567c11.632,0,21.833-6.103,27.593-15.276C459.261,274.841,453.335,276.668,446.981,276.668z"/></svg>',
	
	/* https://www.flaticon.com/free-icon/rss-feeds-symbol-in-a-rounded-square_37430 */
	'flaticon-rss': '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 527.164 527.164"><g><g><path style="fill:#fd982c" d="M428.32,0.006H98.844c-27.228,0-50.508,9.664-69.841,28.997C9.663,48.335,0,71.622,0,98.85v329.476    c0,27.228,9.663,50.515,29.002,69.836c19.333,19.333,42.614,28.996,69.841,28.996H428.32c27.228,0,50.502-9.663,69.842-28.996    c19.333-19.321,29.002-42.607,29.002-69.836V98.85c0-27.228-9.669-50.515-29.002-69.848C478.822,9.669,455.542,0.006,428.32,0.006    z M162.853,426.436c-8.581,8.58-18.936,12.87-31.059,12.87c-12.13,0-22.479-4.29-31.059-12.87    c-8.58-8.58-12.87-18.93-12.87-31.065c0-12.117,4.29-22.485,12.87-31.065c8.581-8.58,18.929-12.87,31.059-12.87    c12.124,0,22.479,4.29,31.059,12.87c8.58,8.58,12.87,18.941,12.87,31.065C175.723,407.506,171.433,417.855,162.853,426.436z     M293.099,435.872c-2.289,2.295-4.92,3.434-7.895,3.434h-43.93c-2.974,0-5.489-0.967-7.552-2.926    c-2.057-1.946-3.207-4.4-3.434-7.374c-2.521-35.233-16.358-65.436-41.53-90.613c-25.171-25.153-55.374-38.996-90.606-41.518    c-2.975-0.227-5.441-1.383-7.381-3.434c-1.946-2.062-2.919-4.571-2.919-7.546V241.96c0-2.974,1.144-5.606,3.433-7.895    c2.283-2.277,5.031-3.311,8.238-3.084c53.079,2.974,98.379,23.219,135.907,60.747c37.522,37.522,57.773,82.822,60.747,135.901    C296.41,430.848,295.382,433.583,293.099,435.872z M424.887,435.872c-2.289,2.295-4.92,3.434-7.895,3.434h-43.93    c-2.975,0-5.489-1.034-7.552-3.097c-2.057-2.051-3.207-4.56-3.434-7.546c-1.604-46.665-14.357-89.915-38.269-129.731    c-23.91-39.805-55.771-71.66-95.582-95.577c-39.811-23.905-83.054-36.665-129.731-38.274c-2.975-0.214-5.49-1.365-7.552-3.433    c-2.056-2.05-3.09-4.56-3.09-7.546v-43.936c0-2.962,1.145-5.594,3.433-7.883c2.056-2.295,4.688-3.323,7.895-3.097    c35.232,1.15,69.266,7.546,102.106,19.223c32.828,11.665,62.577,27.631,89.236,47.876c26.652,20.245,50.104,43.703,70.355,70.355    c20.251,26.665,36.206,56.402,47.877,89.236c11.671,32.846,18.072,66.873,19.223,102.105    C428.431,431.178,427.402,433.81,424.887,435.872z" fill="#D80027"/></g></g></svg>',
	
	/* Flaticon (Smashicons): https://www.flaticon.com/free-icon/locked_149077 */
	'flaticon-security': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 57 57"><path style="fill:none;stroke:#424A60;stroke-width:4;stroke-linecap:round;stroke-miterlimit:10;" d="M16.5,28V12.601  C16.5,6.77,21.675,2,28,2h0c6.325,0,11.5,4.77,11.5,10.601V28H16.5z"/><rect x="7.5" y="25" style="fill:#EBBA16;" width="42" height="32"/><path style="fill:#424A60;" d="M28.5,45L28.5,45c-1.65,0-3-1.35-3-3v-6c0-1.65,1.35-3,3-3h0c1.65,0,3,1.35,3,3v6  C31.5,43.65,30.15,45,28.5,45z"/><rect x="7.5" y="51" style="fill:#38454F;" width="42" height="6"/></svg>',
	
	/* Flaticon (srip): https://www.flaticon.com/free-icon/gear_1260792 */
	'flaticon-system_settings': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 480 480"><path fill="#9bc9ff" d="m 399.52 148.398 l 38.4805 -38.4766 l -67.9219 -67.9219 l -38.4766 38.4805 c -13.6641 -7.94531 -28.3281 -14.0234 -43.6016 -18.082 v -54.3984 h -96 v 54.3984 c -15.2734 4.05859 -29.9375 10.1367 -43.6016 18.082 l -38.4766 -38.4805 l -67.9219 67.9219 l 38.4805 38.4766 c -7.94531 13.6641 -14.0234 28.3281 -18.082 43.6016 h -54.3984 v 96 h 54.3984 c 4.05859 15.2734 10.1367 29.9375 18.082 43.6016 l -38.4805 38.4766 l 67.9219 67.9219 l 38.4766 -38.4805 c 13.6641 7.94531 28.3281 14.0234 43.6016 18.082 v 54.3984 h 96 v -54.3984 c 15.2734 -4.05859 29.9375 -10.1367 43.6016 -18.082 l 38.4766 38.4805 l 67.9219 -67.9219 l -38.4805 -38.4766 c 7.94531 -13.6641 14.0234 -28.3281 18.082 -43.6016 h 54.3984 v -96 h -54.3984 c -4.05859 -15.2734 -10.1367 -29.9375 -18.082 -43.6016 Z m -159.52 211.602 c -66.2734 0 -120 -53.7266 -120 -120 s 53.7266 -120 120 -120 s 120 53.7266 120 120 c -0.074219 66.2422 -53.7578 119.926 -120 120 Z m 0 0" /><g fill="#1e81ce"><path d="m 472 184 h -48.3438 c -3.58203 -11.8477 -8.33984 -23.3125 -14.1992 -34.2148 l 34.1992 -34.2109 c 3.12109 -3.12109 3.12109 -8.1875 0 -11.3086 l -67.9219 -67.9219 c -3.12109 -3.12109 -8.1875 -3.12109 -11.3086 0 l -34.2109 34.1992 c -10.9023 -5.86328 -22.3633 -10.6211 -34.2148 -14.1992 v -48.3438 c 0 -4.41797 -3.58203 -8 -8 -8 h -96 c -4.41797 0 -8 3.58203 -8 8 v 48.3438 c -11.8516 3.57813 -23.3125 8.33594 -34.2148 14.1992 l -34.2109 -34.1992 c -3.12109 -3.12109 -8.1875 -3.12109 -11.3086 0 l -67.9219 67.9219 c -3.12109 3.12109 -3.12109 8.1875 0 11.3086 l 34.1992 34.2109 c -5.85938 10.9023 -10.6172 22.3672 -14.1992 34.2148 h -48.3438 c -4.41797 0 -8 3.58203 -8 8 v 96 c 0 4.41797 3.58203 8 8 8 h 48.3438 c 3.58203 11.8477 8.33984 23.3125 14.1992 34.2148 l -34.1992 34.2109 c -3.12109 3.12109 -3.12109 8.1875 0 11.3086 l 67.9219 67.9219 c 3.12109 3.12109 8.1875 3.12109 11.3086 0 l 34.2109 -34.1992 c 10.9023 5.86328 22.3633 10.6211 34.2148 14.1992 v 48.3438 c 0 4.41797 3.58203 8 8 8 h 96 c 4.41797 0 8 -3.58203 8 -8 v -48.3438 c 11.8516 -3.57813 23.3125 -8.33594 34.2148 -14.1992 l 34.2109 34.1992 c 3.12109 3.12109 8.1875 3.12109 11.3086 0 l 67.9219 -67.9219 c 3.12109 -3.12109 3.12109 -8.1875 0 -11.3086 l -34.1992 -34.2109 c 5.85938 -10.9023 10.6172 -22.3672 14.1992 -34.2148 h 48.3438 c 4.41797 0 8 -3.58203 8 -8 v -96 c 0 -4.41797 -3.58203 -8 -8 -8 Z m -8 96 h -46.3984 c -3.63281 0 -6.80859 2.44141 -7.73828 5.95313 c -3.875 14.5742 -9.67969 28.5625 -17.2617 41.5977 c -1.82031 3.14063 -1.30469 7.10938 1.26172 9.67188 l 32.8008 32.8008 l -56.5859 56.6641 l -32.7969 -32.8008 c -2.56641 -2.55859 -6.53125 -3.07813 -9.66406 -1.26172 c -13.0352 7.58203 -27.0273 13.3906 -41.6016 17.2617 c -3.52734 0.902343 -6 4.07422 -6.01563 7.71484 v 46.3984 h -80 v -46.3984 c 0 -3.63281 -2.44922 -6.8125 -5.96094 -7.73828 c -14.5742 -3.875 -28.5625 -9.67969 -41.5977 -17.2617 c -3.13672 -1.81641 -7.10156 -1.30078 -9.66406 1.26172 l -32.8008 32.8008 l -56.6641 -56.5859 l 32.8008 -32.7969 c 2.5625 -2.56641 3.08203 -6.53516 1.26172 -9.67188 c -7.58203 -13.0352 -13.3867 -27.0273 -17.2617 -41.6016 c -0.90625 -3.52344 -4.07422 -5.99219 -7.71484 -6.00781 h -46.3984 v -80 h 46.3984 c 3.63281 0 6.80859 -2.44141 7.73828 -5.95313 c 3.875 -14.5742 9.67969 -28.5625 17.2617 -41.5977 c 1.82031 -3.14063 1.30469 -7.10938 -1.26172 -9.67188 l -32.8008 -32.8008 l 56.5859 -56.6641 l 32.7969 32.8008 c 2.56641 2.55859 6.53125 3.07813 9.66406 1.26172 c 13.0352 -7.58203 27.0273 -13.3906 41.6016 -17.2617 c 3.52734 -0.902343 6 -4.07422 6.01563 -7.71484 v -46.3984 h 80 v 46.3984 c 0 3.63281 2.44922 6.8125 5.96094 7.73828 c 14.5742 3.875 28.5625 9.67969 41.5977 17.2617 c 3.13672 1.81641 7.10156 1.30078 9.66406 -1.26172 l 32.8008 -32.8008 l 56.6094 56.6094 l -32.8008 32.7969 c -2.56641 2.56641 -3.08594 6.53516 -1.26563 9.67187 c 7.58203 13.0391 13.3906 27.0273 17.2656 41.6016 c 0.921875 3.53516 4.11719 5.99609 7.76953 5.98438 h 46.3984 Z m 0 0" /><path d="m 240 112 c -70.6914 0 -128 57.3086 -128 128 s 57.3086 128 128 128 s 128 -57.3086 128 -128 c -0.082031 -70.6563 -57.3438 -127.918 -128 -128 Z m 0 240 c -61.8555 0 -112 -50.1445 -112 -112 s 50.1445 -112 112 -112 s 112 50.1445 112 112 c -0.066406 61.8281 -50.1719 111.934 -112 112 Z m 0 0" /><path d="m 240 152 c -48.6016 0 -88 39.3984 -88 88 s 39.3984 88 88 88 s 88 -39.3984 88 -88 c -0.058594 -48.5781 -39.4219 -87.9414 -88 -88 Z m 0 160 c -39.7656 0 -72 -32.2344 -72 -72 s 32.2344 -72 72 -72 s 72 32.2344 72 72 c -0.042969 39.7461 -32.2539 71.957 -72 72 Z m 0 0" /></g></svg>',

	/* Flaticon (Freepik): https://www.flaticon.com/free-icon/user_166246 */
	'flaticon-user': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 389.34 389.34"><path style="fill:#1EA6C6;" d="M347.415,330.3c0,0.04,0,0.08,0,0.13c-40.37,36.61-93.96,58.91-152.74,58.91c-58.79,0-112.38-22.3-152.75-58.91c0-0.05,0-0.09,0-0.13c0-60.89,35.63-113.45,87.17-137.98c19.37,19.32,42.05,29.73,65.58,29.73c23.54,0,46.21-10.41,65.59-29.73C311.805,216.85,347.415,269.41,347.415,330.3z"/><path style="fill:#FCD09F;" d="M194.675,0c46.66,0,84.49,37.82,84.49,84.48c0,46.67-37.83,110.49-84.49,110.49s-84.49-63.82-84.49-110.49C110.185,37.82,148.015,0,194.675,0z"/></svg>',
	
	/* Flaticon (Freepik): https://www.flaticon.com/free-icon/user_166252 */
	'flaticon-user_logout': '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 417.118 417.118"><g><g><g><g><path style="fill:#FCD09F;" d="M176.505,0c46.66,0,84.49,37.82,84.49,84.48c0,46.67-37.83,110.49-84.49,110.49s-84.49-63.82-84.49-110.49C92.015,37.82,129.845,0,176.505,0z"/></g><circle style="fill:#EF806F;" cx="303.365" cy="327.118" r="90"/><polygon style="fill:#FFFFFF;" points="235.836,334.618 342.181,334.618 315.386,361.413 325.993,372.019 370.893,327.118 325.993,282.217 315.386,292.823 342.181,319.618 235.836,319.618 "/></g></g><path style="fill:#1EA6C6;" d="M199.363,327.118c0,21.69,6.67,41.85,18.09,58.54c-13.28,2.42-26.97,3.68-40.95,3.68c-58.79,0-112.38-22.3-152.75-58.91v-0.13c0-60.89,35.63-113.45,87.17-137.98c19.37,19.32,42.05,29.73,65.58,29.73c23.54,0,46.21-10.41,65.59-29.73c16.76,7.98,31.84,18.92,44.54,32.15C237.213,232.488,199.363,275.468,199.363,327.118z"/></g></svg>',
	
	/* Flaticon (Freepik): https://www.flaticon.com/free-icon/group_166257 */
	'flaticon-user_group': '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 411.223 411.223"><g><g><g id="XMLID_27_"><g><path style="fill:#1EA6C6;" d="M405.169,352.183c0,0.04,0,0.08,0,0.13c-40.37,36.61-93.96,58.91-152.74,58.91c-58.79,0-112.38-22.3-152.75-58.91c0-0.05,0-0.09,0-0.13c0-60.89,35.63-113.45,87.17-137.98c19.37,19.32,42.05,29.73,65.58,29.73c23.54,0,46.21-10.41,65.59-29.73C369.559,238.733,405.169,291.293,405.169,352.183z"/><path style="fill:#FCD09F;" d="M252.429,21.883c46.66,0,84.49,37.82,84.49,84.48c0,46.67-37.83,110.49-84.49,110.49s-84.49-63.82-84.49-110.49C167.939,59.703,205.769,21.883,252.429,21.883z"/></g></g></g><g><g id="XMLID_22_"><g><path style="fill:#EF806F;" d="M181.224,187.15c2.59,3.69,5.27,7.15,8.04,10.4l-8.43,4.01c-28.06,13.35-51.8,34.24-68.67,60.41c-13.72,21.29-22.32,45.29-25.31,70.31c-30.49-8.31-58.05-23.72-80.8-44.35v-0.11c0-53.06,31.05-98.86,75.96-120.24c16.88,16.84,36.64,25.91,57.14,25.91c13.43,0,26.55-3.89,38.74-11.31C178.964,183.86,180.084,185.52,181.224,187.15z"/><path style="fill:#EFC59C;" d="M153.944,106.36c0,17.54,4.56,36.84,12.68,54.98c-8.49,5.38-17.76,8.55-27.47,8.55c-40.66,0-73.62-55.61-73.62-96.28c0-40.66,32.96-73.61,73.62-73.61c22.55,0,42.74,10.14,56.24,26.11C170.324,43.99,153.944,73.3,153.944,106.36z"/></g></g></g></g></svg>',
	
	/* Flaticon (Pixel perfect): https://www.flaticon.com/free-icon/contact_891182 */
	'flaticon-vcard': '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="24px" height="24px"><path style="fill:#2196F3;" d="M501.333,96H10.667C4.776,96,0,100.776,0,106.667v298.667C0,411.224,4.776,416,10.667,416h64c5.891,0,10.667-4.776,10.667-10.667c0.108-1.863,0.72-3.663,1.771-5.205c2.006-3.365,2.006-7.558,0-10.923c-1.051-1.543-1.663-3.342-1.771-5.205c0-5.891,4.776-10.667,10.667-10.667c5.891,0,10.667,4.776,10.667,10.667c-0.108,1.863-0.72,3.663-1.771,5.205c-2.006,3.365-2.006,7.558,0,10.923c1.051,1.543,1.663,3.342,1.771,5.205c0,5.891,4.776,10.667,10.667,10.667h64c5.891,0,10.667-4.776,10.667-10.667c0.108-1.863,0.72-3.663,1.771-5.205c2.006-3.365,2.006-7.558,0-10.923c-1.051-1.543-1.663-3.342-1.771-5.205c0-5.891,4.776-10.667,10.667-10.667s10.667,4.776,10.667,10.667c-0.108,1.863-0.72,3.663-1.771,5.205c-2.006,3.365-2.006,7.558,0,10.923c1.051,1.543,1.663,3.342,1.771,5.205c0,5.891,4.776,10.667,10.667,10.667h64c5.891,0,10.667-4.776,10.667-10.667c0.108-1.863,0.72-3.663,1.771-5.205c2.006-3.365,2.006-7.558,0-10.923c-1.051-1.543-1.663-3.342-1.771-5.205c0-5.891,4.776-10.667,10.667-10.667S320,378.109,320,384c-0.108,1.863-0.72,3.663-1.771,5.205c-2.006,3.365-2.006,7.558,0,10.923c1.051,1.543,1.663,3.342,1.771,5.205c0,5.891,4.776,10.667,10.667,10.667h64c5.891,0,10.667-4.776,10.667-10.667c0.108-1.863,0.72-3.663,1.771-5.205c2.006-3.365,2.006-7.558,0-10.923c-1.051-1.543-1.663-3.342-1.771-5.205c0-5.891,4.776-10.667,10.667-10.667c5.891,0,10.667,4.776,10.667,10.667c-0.108,1.863-0.72,3.663-1.771,5.205c-2.006,3.365-2.006,7.558,0,10.923c1.051,1.543,1.663,3.342,1.771,5.205c0,5.891,4.776,10.667,10.667,10.667h64c5.891,0,10.667-4.776,10.667-10.667V106.667C512,100.776,507.224,96,501.333,96z"/><g><circle style="fill:#FAFAFA;" cx="138.667" cy="192" r="42.667"/><path style="fill:#FAFAFA;" d="M224,320c0-47.128-38.205-85.333-85.333-85.333S53.333,272.872,53.333,320H224z"/></g><g><path style="fill:#90CAF9;" d="M458.667,181.333H288c-5.891,0-10.667-4.776-10.667-10.667S282.109,160,288,160h170.667c5.891,0,10.667,4.776,10.667,10.667S464.558,181.333,458.667,181.333z"/><path style="fill:#90CAF9;" d="M394.667,245.333H288c-5.891,0-10.667-4.776-10.667-10.667S282.109,224,288,224h106.667c5.891,0,10.667,4.776,10.667,10.667S400.558,245.333,394.667,245.333z"/><path style="fill:#90CAF9;" d="M458.667,309.333H288c-5.891,0-10.667-4.776-10.667-10.667c0-5.891,4.776-10.667,10.667-10.667h170.667c5.891,0,10.667,4.776,10.667,10.667C469.333,304.558,464.558,309.333,458.667,309.333z"/></g></svg>'
};

var WIDGET_LOADING_IMAGE = '<span class="loading small">' + KW_IMAGES['flaticon-loading'] + '</span>'; 

function App() {}
	
//
// Jquery
//
App.delayFadeOut = function(object) {
    object.delay(NOTIFICATION_DELAY).fadeOut();
};

App.serializeForm = function(object) {
    object.serialize();
};

//
// JqueryUI
//
App.generateDatepicker = function(object, options) {
    object.datepicker(options);
};

//
// Common
//
/*
 * TODO:
 * This is for submiting a form when the user change selectbox value.
 * We'll be submitting to a different page according to formAction.
 */
function changeAction(thisObject, formAction) {
    thisObject.form.action = formAction;
    thisObject.form.submit();
}

App.changeSelectedOption = function(thisObject) {
    App.updateViewHistory(thisObject.form.action + '&' + thisObject.name + '=' + thisObject.value);
};

/*
 * Submits a form when the user change selectbox value.
 * This is different from changeSelectedOption where it invokes an ajax request instead.
 */
App.changeLocaleSelectedOption = function(thisObject) {
    thisObject.form.submit();
};

App.disableButton = function(buttonElem) {
    buttonElem.innerHTML = WIDGET_LOADING_IMAGE + buttonElem.innerHTML;
    buttonElem.disabled = true;
};

App.disableButtonSubmit = function(buttonElem) {
	var buttonDisabled = buttonElem.disabled;
    buttonElem.innerHTML = WIDGET_LOADING_IMAGE + buttonElem.innerHTML;
    if (!buttonDisabled) {
        buttonElem.disabled = true;
        buttonElem.form.submit();
    }
    return false;
};

App.highlightModuleTab = function(moduleIds, selectedModuleId) {
    for (var i in moduleIds) {
        var elem = document.getElementById('headerModule' + moduleIds[i]);
        if (elem != null) {
            if (moduleIds[i] == selectedModuleId) {
                elem.className = 'themeDarkBg themeBorder';
            } else {
                elem.className = 'themeHoverBg themeBorder';
            }
        }
    }
};

App.indicateError = function(thisForm, fieldName) {
	console.log('ActionMessages field name: ' + fieldName);

	if (thisForm == undefined) {
		return;
	} 
		
	if (thisForm.elements[fieldName] != undefined && thisForm.elements[fieldName].classList != undefined) {
	    thisForm.elements[fieldName].classList.add('formFieldError');
	}
};

/*
 * App.invokeAjax cfg options:
 *  cfg.uri
 * 	cfg.callback
 * 	cfg.data: for post
 */
App.invokeAjax = function(cfg) {
    var ajax = Js.Ajax.newInstance();
    var request = ajax.request;

    // The appending of ?/& and ajax=true must happen here instead of in java code. Or ajax=true will be
    // pushed to the browser history too.
    cfg.uri += ((cfg.uri.indexOf('?') == -1) ? '?' : '&') + URL_PARAM_AJAX + '=true'

	request.onreadystatechange = function() {
        // Ready State:
        // 0 - Uninitialized
        // 1 - Loading
        // 2 - Loaded
        // 3 - Interactive
        // 4 - Completed
        if (request.readyState == 4) {
        	var result;

        	if (request.responseXML != null) { // We have the response in XML format, which is good.
        		result = request.responseXML.documentElement.getElementsByTagName('result')[0].firstChild.data;
        		
        	} else {
            	if (request.status == 0) {
            		result = '<h2>' + SERVER_CONN_ERROR_HEADER + '</h2><div>' + SERVER_CONN_ERROR_BODY + '</div>';
            	} else {
                	// This is not a valid response in XML format, may due to error in JSP.
                    result = request.responseText;
            	}

            	// We may get an ajax response (in the case of "Not Authorized", "Forbidden", etc).
            	cfg.callback = function(result) {
       				Js.Element.setHtml(CONTENT_ELEM_ID, result);
            	};
        	}
        	
			// Invoke callback function.
        	setTimeout(function() { // Gives a delay so that the loading icon doesn't flash too fast.
            	// Need this to hide the loading icon.
        		if (cfg.loadElemId != undefined) {
        			if (cfg.loadElemId == CONTENT_ELEM_ID) {
        				Js.Display.hide('loadingImage');
        				Js.Display.hide('loadingBackground');
        				
        			} else {
        	            Js.Element.setHtml(cfg.loadElemId, '');
        			}
                }
				cfg.callback(result);
        	}, 200);
        }
    };
    if (cfg.data != undefined) {
        ajax.post(cfg.uri, cfg.data);
    } else {
        ajax.get(cfg.uri);
    }
    return false;
};

/*
 * Updates the element of given ID only instead of refreshing the whole page. 
 */
App.updateView = function(input, url, params) {
	console.log('App.updateView');

	var cfg = input;
	/*
	 * var cfg = {
	 * 		loadElemId:,
	 *	    targetElemId:
	 * };
	 */
	if (typeof input == 'string') {
	    cfg = {
	    	loadElemId: input,
	    	targetElemId: input
	    };
	}

	if (cfg.loadElemId != undefined) {
		if (cfg.loadElemId == CONTENT_ELEM_ID) {
			Js.Display.show('loadingImage');
			Js.Display.show('loadingBackground');
			
		} else {
			// Replace the target element with a small loading image.
			Js.Element.setHtml(cfg.loadElemId, WIDGET_LOADING_IMAGE);
		}
    }

	cfg.uri = url;
    cfg.data = params;
	cfg.callback = function(result) {
        // Replace div area content with result.
    	Js.Element.setHtml(cfg.targetElemId, result);

        // Executes javascript embedded in ajax.
        var scriptElems = document.getElementById(cfg.targetElemId).getElementsByTagName('script');
        for (var i = 0; i < scriptElems.length; i++) {
        	// console.log(i + ': ' + scriptElems[i].innerHTML);
        	Js.globalEval(scriptElems[i].innerHTML);
        }
        
    	App.dataScript();
	};
	
	return App.invokeAjax(cfg);
};

/*
 * Updates the element of given ID only instead of refreshing the whole page.
 */
App.updateViewHistory = function(url) {
	console.log('App.updateViewHistory');

    return Js.Response.updateHistory(url, function(){
        App.updateView(CONTENT_ELEM_ID, url);
    });
};

/* 
 * cfg.disable: Disable the button name specified.
 * cfg.allowResubmit: By default, after submitting the form, it adds data-form-submit-disabled to allow multiple 
 * 		submits while a request is being processed. This allows overriding that behavior in case of auto-suggestion.
 */
App.submitFormUpdate = function(formElem, cfg) {
    if (cfg == undefined) {
    	cfg = {};
    }

    if (cfg.allowResubmit == undefined && formElem.elements['data-form-submit-disabled'] != undefined) {
    	console.log('Ignore form submit.')
        return false;
    }

    // Setting form.action to empty to prevent this form being resubmitted again, e.g. by double-clicking.
    formElem.elements['data-form-submit-disabled'] = 'true';

    if (cfg.url != undefined) {
        formElem.action = cfg.url;
    }
    
    if (cfg.disable != undefined) {
    	App.disableButton(cfg.disable);
    }
    
    if (cfg.targetElemId == undefined) {
    	cfg.targetElemId = CONTENT_ELEM_ID;
     }
    
    App.updateView(cfg, formElem.action, $('#' + formElem.id).serialize());
    
    // Return false to disable default form submit behavior.
    return false;
};

App.updateViewLazy = function(elemId, url) {
    if (Js.Element.isEmpty(elemId)) {
        App.updateView(elemId, url);
    }
};

App.updateViewToggle = function(elemId, url) {
    var isHidden = Js.Display.toggle(elemId);
    if (!isHidden) {
        App.updateView(elemId, url);
    }
};

App.toggleCustomFields = function(targetElemId, collapsedLabel, expandedLabel) {
	Js.Display.toggle(targetElemId, function() {
		var imageElem = document.getElementById('customFieldToggleImage');
		
		if (document.getElementById(targetElemId).style.display == 'none') {
			Js.Cookies.setCookie(CUSTOM_FIELD_EXPAND_COOKIE, false, APP_PATH);
			imageElem.setAttribute('data-image', 'g-expand_more');
			imageElem.parentNode.title = expandedLabel;
		} else {
			Js.Cookies.setCookie(CUSTOM_FIELD_EXPAND_COOKIE, true, APP_PATH);
			imageElem.setAttribute('data-image', 'g-expand_less');
			imageElem.parentNode.title = collapsedLabel;
		}
		App.replaceSvgImage(imageElem);
	});
};

App.toggleCustomFieldsUpdate = function(spanElem, elemId, elemUrl, collapsedLabel, expandedLabel) {
	Js.Display.toggle(elemId, function() {
		var imageElem = spanElem.firstChild;
		
		if (document.getElementById(elemId).style.display == 'none') {
			imageElem.setAttribute('data-image', 'g-expand_more');
			imageElem.parentNode.title = expandedLabel;
			
		} else {
			imageElem.setAttribute('data-image', 'g-expand_less');
			imageElem.parentNode.title = collapsedLabel;
			
			App.updateView(elemId, elemUrl);
		}
		App.replaceSvgImage(imageElem);
	});
}

// Footer scripts
App.footer = function() {
	// Highlight selected module tab
	App.highlightModuleTab(MODULE_IDS, CURRENT_MODULE_ID);

    // Call the callbacks at the end. In case this fails, it won't affect the above scripts.
	if (CALLBACKS != undefined) {
	    for (var i in CALLBACKS) {
	        CALLBACKS[i]();
	    }
	}
};

/*
 * Replace SVG with data-image attribute. Replaced SVG will have data-image-loaded. 
 */
App.replaceSvgImage = function(item) {
	var dataImageName = item.getAttribute('data-image');
	var replaceSvgElem = KW_IMAGES[dataImageName];

	var tempElem = document.createElement('span');
	tempElem.innerHTML = replaceSvgElem;
	var newSvgElem = tempElem.childNodes[0];

	if (newSvgElem == null) {
		console.log('App.replaceSvgImage(), ' + dataImageName + ' not found.')
		return;
	}
	
	var attrs = ['class', 'id'];
	for (var i in attrs) {
		var attr = attrs[i]
	 	if (item.getAttribute(attr) != null) {
	 		newSvgElem.setAttribute(attr, item.getAttribute(attr));
 		}
	}
	
	newSvgElem.setAttribute('data-image-loaded', dataImageName);
	
	var parentElem = item.parentNode;
	parentElem.insertBefore(newSvgElem, item);
	$(item).remove();
}

App.dataScript = function() {
    // Focus on the first form element that has autofocus attribute set.
    Js.Form.autofocus();

    // Replace SVG images.
    var svgElems = $('svg[data-image]').each(function(index, item) {
    	App.replaceSvgImage(item);
    });
    
    $('a[data-script="updateViewHistory"]').off('click').on('click', function() {
        window.scrollTo(0, 0);
		return App.updateViewHistory(this.href);
    });

    $('form[data-form-submit]').off('submit').on('submit', function() {
    	var buttonName = $(this).attr('data-form-submit'); // Get button name from attribute.
    	var cfg = {'disable' : this.elements[buttonName]};
    	
    	var target = $(this).attr('data-form-submit-target');
		if (target != undefined) {
			cfg.targetElemId = target;
		}
    	return App.submitFormUpdate(this, cfg); // Disable button and submit.
    });
    
    $( document ).tooltip({
        items: "[data-tooltip], [title]",
        content: function() {
	        var element = $( this );
	        if ( element.is('[data-tooltip]') ) {
	        	return element.attr('[data-tooltip]');
	        }
	        if ( element.is('[title]') ) {
	            return element.attr('title');
	        }
        }
    });
}; 

//
// Admin module
//
/*
 * Shows browser size dynamatically. 
 */
App.browserSizeRefresh = function() {
	Js.Element.setHtml('browserSize', Js.Display.getVisibleWidth() + ' x ' + Js.Display.getVisibleHeight());
};

/*
 * This is for creating a new User. We want the display name field to reflect
 * what first name and last name are.
 */
App.refreshDisplayName = function(formFirstName, formLastName, formDisplayName) {
    Js.Form.setValue(formDisplayName, formFirstName.value + ' ' + formLastName.value);
};

/*
 * If user account status is enabled, password/confirm password fields are required, and vice versa. This script is
 * used to toggle the required field indicators "*".
 */
App.togglePasswordFields = function(status, formPassword, formConfirmPassword) {
    if (status == USER_STATUS_ENABLED) {
        Js.Visibility.show(formPassword);
        Js.Visibility.show(formConfirmPassword);
    } else {
        Js.Visibility.hide(formPassword);
        Js.Visibility.hide(formConfirmPassword);
    }
};

/**
 * Select all buttons for edit Permission
 * @param thisForm
 * @param list
 */
App.selectAllAccessItems = function(elem, perms) {
    for (var i in perms) {
        var formFields = elem.form.elements['formAccess_' + perms[i]];
        for(var j in formFields) {
            if (formFields[j].value == elem.value) {
                formFields[j].checked = true;
                break;
            }
        }
    }
};

App.updateAttrOptions = function(attrTypeId) {
	Js.Display.hide(['attrOptions', 'attrCurrencySymbol', 'convertUrl']);

    if (attrTypeId == ATTR_TYPE_STRING) {
    	Js.Display.show(['convertUrl']);
    } else if (attrTypeId == ATTR_TYPE_MULTILINE) {
    	Js.Display.show(['convertUrl']);
    } else if (attrTypeId == ATTR_TYPE_SELECTBOX) {
    	Js.Display.show(['attrOptions']);
    } else if (attrTypeId == ATTR_TYPE_RADIO_BUTTON) {
    	Js.Display.show(['attrOptions']);
    } else if (attrTypeId == ATTR_TYPE_DATE) {
    	// nothing to show
    } else if (attrTypeId == ATTR_TYPE_CURRENCY) {
    	Js.Display.show(['attrCurrencySymbol']);
    }
};

App.toggleImportType = function(importType) {
    if (importType == 'hardware_import') {
    	Js.Display.show('allowDuplicate');
    } else {
    	Js.Display.hide('allowDuplicate');
    }
};

//
// Auth module
//
App.focusLogin = function(formUsername, formPassword) {
    // If the email field is empty, move the cursor there.
    // If the user has a saved email address, move the cursor to the password field.
	if (formUsername.value == '' ) {
		formUsername.focus();
	} else {
		formPassword.focus();
	}
};

//
// Blogs module
//
/*
 * Allows HTML preview when composing a new post.
 */
App.refreshPostPreview = function(thisObject, id) {
	Js.Element.setHtml(id, Js.String.replace(Js.String.replace(thisObject.value,'\r\n','<br>'),'\n','<br>'));
};

//
// Hardware module
//
App.setWarrantyExpireYear = function(formName, year) {
    if (year == 0) {
        return;
    }

    document.forms[formName].warrantyMonth.value = document.forms[formName].purchaseMonth.value;
    document.forms[formName].warrantyDate.value = document.forms[formName].purchaseDate.value;

    var purchaseYear = document.forms[formName].purchaseYear.value;

    if (purchaseYear != 0) {
        purchaseYear = parseInt(purchaseYear) + parseInt(year);
    }
    document.forms[formName].warrantyYear.value = purchaseYear;
};

/*
 * Gets hardware details in-page popup.
 */
var hardwarePopupAjax = {
    divPos: 'right',
	popupDiv: '',
	url: '',
    input: '',
	show: function(thisObject, input) {
		var thisDiv = document.getElementById(this.popupDiv);
        if (!Js.Display.isHidden(thisDiv) && (this.input == input)) {
        	Js.Display.hide(thisDiv);
        } else {
            // Clears out old result
        	Js.Element.setHtml(thisDiv, '');
            // Keeps track of last input
            this.input = input;
            
        	var cfg = {
    			uri: this.url + input,
    	        callback: function(result) {
	                var topPdding = 20;
	                
	                // Replace div area content with result.
	                thisDiv.innerHTML = result;

	                // Shows div
	                Js.Display.show(thisDiv);

	                var top = Js.Element.getPositionTop(thisObject) - thisDiv.offsetHeight + topPdding;
	               	if (top < 0) {
	               		top = 0;
	               	}

	               	var left = Js.Element.getPositionLeft(thisObject) + 20;
	                
	                thisDiv.style.top = top + 'px';
	                thisDiv.style.left = left + 'px';
	                
	                App.dataScript();
    	        }
        	}
            App.invokeAjax(cfg);
        }
    },
    // Clear previously values, especially when using ajax to navigate from one page to another.
    clearCache:function(){
        divPos = 'right';
        popupDiv = '';
        url = '', 
        input = '';
    }
};

//
// Issues module
//
App.toggleIssueDueDate = function(elem) {
    var disabled = (elem.value==1) ? false : true;
    
    elem.form.dueDateMonth.disabled = disabled;
    elem.form.dueDateDate.disabled = disabled;
    elem.form.dueDateYear.disabled = disabled;
};

App.issueDisplayHtml = function(path) {
	console.log('App.issueDisplayHtml: ' + path);
    Js.Display.hide('issueText');
    Js.Display.show('issueHtml');
    
    var iframe = document.getElementById('issueHtmlContent');
    iframe.src = path;
};

App.issueDisplayText = function() {
    Js.Display.show('issueText');
    Js.Display.hide('issueHtml');
};

//
// Reports module
//
App.checkReportTypeEnabled = function(reportTypeField) {
    reportTypeField.form.submitBtn.disabled = (reportTypeField.value == '');
};

//
// Software module
//
App.toggleHardwareLicenseDetails = function(targetElemId, licElemId, licElemUrl, collapsedLabel, expandedLabel) {
	Js.Display.toggle(targetElemId, function() {
		var imageElem = document.getElementById('toggleImg' + licElemId);
		
		if (document.getElementById(targetElemId).style.display == 'none') {
			imageElem.setAttribute('data-image', 'g-expand_less');
			imageElem.parentNode.title = collapsedLabel;
			
			App.updateViewToggle('cf' + licElemId, licElemUrl);
			
		} else {
			imageElem.setAttribute('data-image', 'g-expand_more');
			imageElem.parentNode.title = expandedLabel;
			
			Js.Display.hide('cf' + licElemId);
		}
		App.replaceSvgImage(imageElem);
	});
}
