<%--
 * Copyright 2016 Kwoksys
 *
 * http://www.kwoksys.com/LICENSE
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
--%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://www.kwoksys.com/tags" prefix="k" %>

<jsp:include page="/jsp/common/template/ActionMessages.jsp"/>

<form action="${formAction}" method="post" id="groupAddForm" onsubmit="Js.Form.selectAllOptions(this.selectedMembers); return App.submitFormUpdate(this, {'disable' : this.submitBtn})">
<table class="${RootTemplate.detailsTableStyle}">
    <tr>
        <th>${image.requiredField}<k:message key="common.column.group_name"/>:</th>
        <td><input type="text" name="groupName" value="<k:write value="${form.groupName}"/>" autofocus></td>
    </tr>
    <tr>
        <th><k:message key="common.column.group_description"/>:</th>
        <td><html:textarea name="form" property="groupDescription" rows="10" cols="50"/></td>
    </tr>
    <tr>
        <th><k:message key="common.column.group_members"/>:</th>
        <td><table><tr>
            <td>
            <span class="formSubscriberHeader"><k:message key="admin.groupMembersEdit.availableMembers"/></span><Br>
            <html:select name="form" property="availableMembers" multiple="true" size="5" styleClass="formSubscriberSelectbox">
            <html:options collection="availableMembersOptions" property="value" labelProperty="label"/>
            </html:select>
            </td>
            <td valign="middle">
                <button type="button" onclick="Js.Form.moveOptions(this.form.availableMembers, this.form.selectedMembers)" style="padding:6px 20px">&gt;</button><p>
                <button type="button" onclick="Js.Form.moveOptions(this.form.selectedMembers, this.form.availableMembers)" style="padding:6px 20px">&lt;</button>
            </td>
            <td>
            <span class="formSubscriberHeader"><k:message key="admin.groupMembersEdit.selectedMembers"/></span><Br>
            <html:select name="form" property="selectedMembers" multiple="true" size="5" styleClass="formSubscriberSelectbox">
            <html:options collection="selectedMembersOptions" property="value" labelProperty="label"/>
            </html:select>
            </td>
            </tr></table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td>
        <button type="submit" name="submitBtn"><k:message key="form.button.save"/></button>
            ${formCancelLink}
        </td>
    </tr>
</table>
</form>
