<%--
 * Copyright 2016 Kwoksys
 *
 * http://www.kwoksys.com/LICENSE
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
--%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://www.kwoksys.com/tags" prefix="k" %>

<jsp:include page="/jsp/common/template/ActionMessages.jsp"/>

<form action="${formAction}" method="post" id="${form.id}" data-form-submit="submitBtn">
<table class="${RootTemplate.detailsTableStyle}">
    <tr>
        <th>${image.requiredField}<k:message key="common.column.post_name"/>:</th>
        <td><input type="text" name="postTitle" value="<k:write value="${form.postTitle}"/>" onkeyup="App.refreshPostPreview(this, 'postTitleDiv');" size="60" autofocus></td>
    </tr>
    <tr>
        <th><k:message key="common.column.post_description"/>:</th>
        <td><html:textarea name="form" property="postBody" rows="20" cols="120" onkeyup="App.refreshPostPreview(this, 'postBodyDiv');"/></td>
    </tr>
    <tr>
        <th><k:message key="common.column.category_id"/>:</th>
        <td><html:select name="form" property="categoryId">
            <html:options collection="postCategoryIdOptions" property="value" labelProperty="label"/>
            </html:select></td>
    </tr>
    <tr>
        <th><k:message key="common.column.post_allow_comment"/>:</th>
        <td><html:select name="form" property="postAllowComment">
            <html:options collection="postAllowCommentOptions" property="value" labelProperty="label"/>
        </html:select></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td><button type="submit" name="submitBtn"><k:message key="common.action.Add"/></button>
        ${formCancelLink}
        &nbsp;&nbsp;${previewLink}
        </td>
    </tr>
</table>
</form>

<div id="previewPostDiv" style="display:none">
<table class="standard">
<tr>
    <td><h2 style="text-align:center" id="postTitleDiv">[<k:message key="common.column.post_name"/>]</h2>
        <p><div class="infoContent"><k:write value="${postCreatorText}"/></div>
        <p><div id="postBodyDiv">[<k:message key="common.column.post_description"/>]</div>
    </td>
</tr>
</table>
<p>
</div>
