<%--
 * Copyright 2016 Kwoksys
 *
 * http://www.kwoksys.com/LICENSE
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
--%>
<%@ taglib uri="http://www.kwoksys.com/tags" prefix="k" %>

<k:define id="hideErrorTitle" value="false"/>

<k:if test="${ActionErrorsTemplate != null}">	
    <k:define id="actionErrorsTemplate" name="ActionErrorsTemplate" type="com.kwoksys.action.common.template.ActionErrorsTemplate"/>
    <k:define id="hideErrorTitle" name="actionErrorsTemplate" property="hideErrorTitle"/>
    
    <k:notEmpty name="actionErrorsTemplate" property="message">
        <div class="paddingBottom">${actionErrorsTemplate.message}</div>
    </k:notEmpty>
</k:if>

<k:notEmpty name="_messages">
<k:equal name="_hasErrors" value="true">
<div class="error">
    <k:if test="!${hideErrorTitle}">
        <b><k:message key="form.error.input"/></b>
    </k:if>
    <ul>
        <k:foreach id="message" name="_messages">
            <li>${message}</li>
        </k:foreach>
    </ul>
</div>
</k:equal>

<k:equal name="_hasErrors" value="false">
<div class="message"><b><k:message key="form.actionMessage"/></b>
    <ul>
        <k:foreach id="message" name="_messages">
            <li>${message}</li>
        </k:foreach>
    </ul>
</div>
</k:equal>

<p>
<script type="text/javascript">
CALLBACKS.push (
    function() {
        var thisForm = document.getElementById('${form.id}');
        console.log('ActionMessages form: ${form.id}');
        
        <%-- Change style of fields that have an error. --%>
        <k:foreach id="fieldName" name="_formErrorFields">
            App.indicateError(thisForm, '${fieldName}');
        </k:foreach>
    }
);
</script>

</k:notEmpty>