<%--
 * Copyright 2017 Kwoksys
 *
 * http://www.kwoksys.com/LICENSE
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
--%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://www.kwoksys.com/tags" prefix="k" %>

<k:notEmpty name="HeaderTemplate">
    <k:define id="headerTemplate" name="HeaderTemplate" type="com.kwoksys.action.common.template.HeaderTemplate"/>
</k:notEmpty>

<k:notEmpty name="HeaderSimpleTemplate">
    <k:define id="headerTemplate" name="HeaderSimpleTemplate" type="com.kwoksys.action.common.template.HeaderSimpleTemplate"/>
</k:notEmpty>

<!DOCTYPE html>
<html>
<head>
    <meta HTTP-EQUIV="Content-Type" content="text/html; charset=UTF-8">
    <title><k:write value="${headerTemplate.pageTitleText}"/></title>
    <%-- There's also set in headers, as in some cases, the compatibility mode is determined before receiving the meta tag. --%>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link href="${image.favicon}" rel="shortcut icon" type="image/x-icon">
    <link href="${path.defaultStyle}" rel="stylesheet" type="text/css">
	<link href="${path.root}/common/kis/kis.css?v=${path.buildDate}" rel="stylesheet" type="text/css">
    <link href="${headerTemplate.themeStylePath}" rel="stylesheet" type="text/css">

    <style type="text/css">
    html, body {
        font-size:${headerTemplate.fontSize}px;
    }
    <%-- User-defined stylesheet --%>
    ${headerTemplate.customStylesheet}
    </style>

    <script type="text/javascript">
        window.focus();
        var APP_PATH = '${path.cookieRoot}';
        var SERVER_CONN_ERROR_HEADER = '<k:message key="common.errorPages.serverConnection.header"/>';
        var SERVER_CONN_ERROR_BODY = '<k:message key="common.errorPages.serverConnection.body"/>';
    </script>

    <script type="text/javascript" src="${path.root}/common/kis/kis.js?v=${path.buildDate}"></script>
    <script type="text/javascript" src="${path.kwokJs}"></script>
    <script type="text/javascript" src="${path.appJs}"></script>
    <script type="text/javascript" src="${path.ckeditor}"></script>
    <script type="text/javascript" src="${path.chartJs}"></script>

    <%-- jQuery --%>
    <%-- Used by: calendar widget, fadeout, tooltip --%>
    <script type="text/javascript" src="${path.jqueryUiBase}/external/jquery/jquery-3.6.0.min.js"></script>

    <%-- jQuery UI --%>
    <link rel="stylesheet" href="${path.jqueryUiBase}/jquery-ui.min.css">
    <script type="text/javascript" src="${path.jqueryUiBase}/jquery-ui.min.js"></script>
    <script type="text/javascript">
        var DATE_PICKER_OPTIONS = {
            showOn: "button",
            buttonImage: "${image.calendar}",
            buttonImageOnly: true,
            dateFormat: "${headerTemplate.jqueryDateFormat}"
        };
    </script>
    
    <%-- Fastselect --%>
    <link rel="stylesheet" href="${path.fastselect}/fastselect.min.css">
    <script type="text/javascript" src="${path.fastselect}/fastselect.standalone.js"></script>
</head>

<body>

<k:notEmpty name="headerTemplate" property="themeTitleText">
    <div id="genericHeaderTitle" class="themeBg standardHeader">
        ${headerTemplate.themeTitleText}
    </div>
</k:notEmpty>
