<%--
 * Copyright 2016 Kwoksys
 *
 * http://www.kwoksys.com/LICENSE
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
--%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://www.kwoksys.com/tags" prefix="k" %>

<k:define id="contract" name="contract" type="com.kwoksys.biz.contracts.dto.Contract"/>

<jsp:include page="/jsp/common/template/ActionMessages.jsp"/>

<form action="${formAction}" method="post" id="${form.id}" data-form-submit="submitBtn">
<input type="hidden" name="_resubmit" value="true">
<table class="${RootTemplate.detailsTableStyle}">
    <tr>
        <th><k:message key="common.column.contract_id"/></th>
        <td><k:message key="form.autoId"/></td>
        <th>${image.requiredField}<k:message key="common.column.contract_name"/>:</th>
        <td><input type="text" name="contractName" value="<k:write value="${form.contractName}"/>" autofocus></td>
    </tr>
    <tr>
        <th><k:message key="common.column.contract_description"/>:</th>
        <td><html:textarea name="form" property="contractDescription" rows="10" cols="50"/></td>
        <th>${contract.getAttrRequiredText('contract_type')}<k:message key="common.column.contract_type"/>:</th>
        <td><html:select name="form" property="contractType" onchange="App.submitFormUpdate(this.form, {'url': '${formThisAction}'})">
            <html:options collection="contractTypeOptions" property="value" labelProperty="label"/>
            </html:select></td>
    </tr>
    <tr>
        <th>${contract.getAttrRequiredText('contract_stage')}<k:message key="common.column.contract_stage"/>:</th>
        <td><html:select name="form" property="contractStage">
            <html:options collection="contractStageOptions" property="value" labelProperty="label"/>
            </html:select></td>
        <th><k:message key="common.column.contract_owner"/>:</th>
        <td><html:select name="form" property="contractOwner">
            <html:options collection="contractOwnerOptions" property="value" labelProperty="label"/>
            </html:select>
            <script>
                $('[name="contractOwner"]').fastselect();
            </script>
        </td>
    </tr>
    <tr>
        <th><k:message key="common.column.contract_provider_name"/>:</th>
        <td><html:select name="form" property="contractProviderId">
            <html:options collection="contractProviderOptions" property="value" labelProperty="label"/>
            </html:select></td>
        <th><k:message key="common.column.contract_effective_date"/>:</th>
        <td><html:select name="form" property="contractEffectiveDateMonth">
            <html:options collection="monthOptions" property="value" labelProperty="label"/>
            </html:select>
            <html:select name="form" property="contractEffectiveDateDate">
            <html:options collection="dateOptions" property="value" labelProperty="label"/>
            </html:select>
            <html:select name="form" property="contractEffectiveDateYear">
            <html:options collection="yearOptions" property="value" labelProperty="label"/>
            </html:select></td>
    </tr>
    <tr>
        <th><k:message key="common.column.contract_expiration_date"/>:</th>
        <td><html:select name="form" property="contractExpirationDateMonth">
            <html:options collection="monthOptions" property="value" labelProperty="label"/>
            </html:select>
            <html:select name="form" property="contractExpirationDateDate">
            <html:options collection="dateOptions" property="value" labelProperty="label"/>
            </html:select>
            <html:select name="form" property="contractExpirationDateYear">
            <html:options collection="yearOptions" property="value" labelProperty="label"/>
            </html:select></td>
        <th><k:message key="common.column.contract_renewal_date"/>:</th>
        <td><html:select name="form" property="contractRenewalDateMonth">
            <html:options collection="monthOptions" property="value" labelProperty="label"/>
            </html:select>
            <html:select name="form" property="contractRenewalDateDate">
            <html:options collection="dateOptions" property="value" labelProperty="label"/>
            </html:select>
            <html:select name="form" property="contractRenewalDateYear">
            <html:options collection="yearOptions" property="value" labelProperty="label"/>
            </html:select></td>
    </tr>
    <tr>
        <th>${contract.getAttrRequiredText('contract_renewal_type')}<k:message key="common.column.contract_renewal_type"/>:</th>
        <td> <html:select name="form" property="contractRenewalType">
            <html:options collection="contractRenewalTypeOptions" property="value" labelProperty="label"/>
            </html:select></td>
    </tr>
    <tr>
        <td colspan="4"><jsp:include page="/jsp/common/template/CustomFieldsEdit.jsp"/></td>
    </tr>
</table>

<div style="text-align: center">
    <button type="submit" name="submitBtn"><k:message key="common.action.Add"/></button>
    ${formCancelLink}
</div>
</form>
