<%--
 * Copyright 2015 Kwoksys
 *
 * http://www.kwoksys.com/LICENSE
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
--%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://www.kwoksys.com/tags" prefix="k" %>

<k:define id="fileDeleteTemplate" name="FileDeleteTemplate" type="com.kwoksys.action.files.FileDeleteTemplate"/>

<!-- FileDeleteTemplate -->
<jsp:include page="/jsp/common/template/ActionMessages.jsp"/>

<form action="${fileDeleteTemplate.formAction}" method="post" id="fileDeleteForm" data-form-submit="submitBtn">
<div class="kwBorders">
    <h3><k:message key="files.fileDelete"/></h3>
    
    <div class="kwInlineFlexbox">
        <div>
            ${image.deleteIcon}
        </div>
        
        <div>
             <b><k:message key="files.fileDelete.warning"/></b>
        </div>
    </div>

    <table class="${RootTemplate.detailsTableStyle}">
        <tr>
            <th style="width:10%"><k:message key="files.colName.file_name"/>:</th>
            <td><k:write value="${fileDeleteTemplate.fileName}"/></td>
        </tr>
        <tr>
            <th><k:message key="files.colName.file_friendly_name"/>:</th>
            <td><k:write value="${fileDeleteTemplate.fileTitle}"/></td>
        </tr>
        <tr>
            <th><k:message key="files.colName.file_byte_size"/>:</th>
            <td><k:write value="${fileDeleteTemplate.fileSize}"/></td>
        </tr>
    </table>
    
    <p><button type="submit" name="submitBtn"><k:message key="common.action.Delete"/></button>
    ${fileDeleteTemplate.formCancelLink}</p>
        
</div>
</form>
